/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.entity;

import com.fireblaze.exhausted.capability.StaminaProvider;
import com.fireblaze.exhausted.comfort.ComfortProvider;
import com.fireblaze.exhausted.config.Settings;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class SeatEntity
extends Entity {
    private Player playerToMove = null;
    private int moveDelay = -1;
    private static final Map<UUID, Integer> tickCounter = new HashMap<UUID, Integer>();

    public SeatEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.moveDelay > 0) {
            --this.moveDelay;
        } else if (this.moveDelay == 0 && this.playerToMove != null) {
            BlockPos posBelow = this.m_20183_();
            BlockState state = this.m_9236_().m_8055_(posBelow);
            VoxelShape shape = state.m_60812_((BlockGetter)this.m_9236_(), posBelow);
            double height = shape.m_83281_() ? 1.0 : shape.m_83297_(Direction.Axis.Y);
            this.playerToMove.m_6034_(this.playerToMove.m_20185_(), (double)posBelow.m_123342_() + height, this.playerToMove.m_20189_());
            this.playerToMove = null;
            this.moveDelay = -1;
            this.m_146870_();
        }
        if (this.m_20197_().isEmpty() && this.moveDelay == -1) {
            this.m_146870_();
            return;
        }
        if (this.m_146895_() != null) {
            Player player = (Player)this.m_146895_();
            UUID id = player.m_20148_();
            int counter = tickCounter.getOrDefault(id, 0) + 1;
            tickCounter.put(id, counter);
            if (counter < 5) {
                return;
            }
            tickCounter.put(id, 0);
            BlockPos posBelow = this.m_20183_();
            BlockState state = this.m_9236_().m_8055_(posBelow);
            float hardness = state.m_60800_((BlockGetter)this.m_9236_(), posBelow);
            float hardnessFactor = hardness > 0.0f ? 1.0f / hardness : 1.0f;
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> player.getCapability(ComfortProvider.COMFORT_CAP).ifPresent(cap -> {
                double comfort = cap.getComfortLevel();
                stamina.rest(player, (float)(comfort * Settings.getRegenerationConfigs("comfortRegMultiplier") * 5.0), hardnessFactor / 1.5f);
            }));
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger instanceof Player) {
            Player player;
            this.playerToMove = player = (Player)passenger;
            this.moveDelay = 1;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

