/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.events;

import com.fireblaze.exhausted.ModifierUtils;
import com.fireblaze.exhausted.Sounds.PlaySoundPacket;
import com.fireblaze.exhausted.capability.StaminaProvider;
import com.fireblaze.exhausted.comfort.ComfortCalculator;
import com.fireblaze.exhausted.comfort.ComfortProvider;
import com.fireblaze.exhausted.comfort.ComfortUtils;
import com.fireblaze.exhausted.config.Settings;
import com.fireblaze.exhausted.entity.SeatEntity;
import com.fireblaze.exhausted.networking.ModMessages;
import com.fireblaze.exhausted.networking.packet.StaminaDataSyncS2CPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerTickHandler {
    private static final Map<UUID, Double> lastPlayerPosX = new HashMap<UUID, Double>();
    private static final Map<UUID, Double> lastPlayerPosZ = new HashMap<UUID, Double>();
    private static final Map<UUID, BlockPos> miningPlayers = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, Integer> tickCounter = new HashMap<UUID, Integer>();
    private static int currentTick = 0;
    public static final int tickMultiplier = 5;
    private static final Map<Entity, Vec3> lastPositions = new HashMap<Entity, Vec3>();
    private static final Map<UUID, Integer> vehicleTickCounter = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = event.player;
        UUID id = player.m_20148_();
        int counter = tickCounter.getOrDefault(id, 0) + 1;
        tickCounter.put(id, counter);
        if (counter < 5) {
            return;
        }
        tickCounter.put(id, 0);
        player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
            BlockState blockState;
            BlockPos blockPos;
            if (player.m_20142_()) {
                stamina.consume((float)Settings.getMovementCost("sprint", true) * 5.0f, (float)Settings.getMovementCost("sprint", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier(player, "movement"), player);
            } else if (PlayerTickHandler.isPlayerWalking(player)) {
                stamina.consume((float)Settings.getMovementCost("walk", true) * 5.0f, (float)Settings.getMovementCost("walk", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier(player, "movement"), player);
            }
            if (player.m_6047_() || player.m_6069_()) {
                stamina.consume((float)Settings.getMovementCost("crouch", true) * 5.0f, (float)Settings.getMovementCost("crouch", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier(player, "movement"), player);
            }
            if (player.m_20184_().f_82480_ > 0.0 && !player.m_20096_() && !player.m_20069_()) {
                stamina.consume((float)Settings.getMovementCost("jump", true) * 5.0f, (float)Settings.getMovementCost("jump", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier(player, "movement"), player);
            }
            if (player.m_21254_()) {
                stamina.consume((float)Settings.getCombatCost("block", true) * 5.0f, (float)Settings.getCombatCost("block", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier(player, "action"), player);
            }
            if ((blockPos = miningPlayers.get(id)) != null && !(blockState = player.m_9236_().m_8055_(blockPos)).m_60795_()) {
                float hardness = blockState.m_60800_((BlockGetter)player.m_9236_(), blockPos);
                ItemStack heldItem = player.m_21205_();
                float armorFactor = PlayerTickHandler.getArmorStaminaMultiplier(player, "action");
                if (heldItem.m_41735_(blockState)) {
                    if (blockState.m_204336_(BlockTags.f_144282_)) {
                        stamina.consume((float)Settings.getMiningCost("pickaxe", true) * 5.0f, (float)Settings.getMiningCost("pickaxe", false) * 5.0f, armorFactor, hardness, player);
                    } else if (blockState.m_204336_(BlockTags.f_144280_)) {
                        stamina.consume((float)Settings.getMiningCost("axe", true) * 5.0f, (float)Settings.getMiningCost("axe", false) * 5.0f, armorFactor, hardness, player);
                    } else if (blockState.m_204336_(BlockTags.f_144283_)) {
                        stamina.consume((float)Settings.getMiningCost("shovel", true) * 5.0f, (float)Settings.getMiningCost("shovel", false) * 5.0f, armorFactor, hardness, player);
                    } else if (blockState.m_204336_(BlockTags.f_144281_)) {
                        stamina.consume((float)Settings.getMiningCost("hoe", true) * 5.0f, (float)Settings.getMiningCost("hoe", false) * 5.0f, armorFactor, hardness, player);
                    } else {
                        stamina.consume((float)Settings.getMiningCost("unknown", true) * 5.0f, (float)Settings.getMiningCost("unknown", false) * 5.0f, armorFactor, hardness, player);
                    }
                } else {
                    stamina.consume((float)Settings.getMiningCost("hand", true) * 5.0f, (float)Settings.getMiningCost("hand", false) * 5.0f, 1.0f, hardness, player);
                }
            }
            float shortStam = stamina.getShortStamina();
            float longStam = stamina.getLongStamina();
            int newThreshold = -1;
            AttributeInstance speed = player.m_21051_(Attributes.f_22279_);
            UUID SPEED_MALUS_3_UUID = UUID.fromString("33333333-3333-3333-3333-333333333333");
            UUID SPEED_MALUS_2_UUID = UUID.fromString("22222222-2222-2222-2222-222222222222");
            UUID SPEED_MALUS_1_UUID = UUID.fromString("11111111-1111-1111-1111-111111111111");
            UUID SPEED_BONUS_1_UUID = UUID.fromString("44444444-4444-4444-4444-444444444444");
            boolean hasMalus3 = speed.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(SPEED_MALUS_3_UUID));
            boolean hasMalus2 = speed.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(SPEED_MALUS_2_UUID));
            boolean hasMalus1 = speed.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(SPEED_MALUS_1_UUID));
            boolean hasBonus1 = speed.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(SPEED_BONUS_1_UUID));
            int hungerDrainInterval = 40;
            ++currentTick;
            if ((double)shortStam <= Settings.getNegativeEffect3Threshold()) {
                newThreshold = 2;
                PlayerTickHandler.hungerSimulation(player, hungerDrainInterval);
                PlayerTickHandler.applyNegativeEffects(player);
                if (!hasMalus3) {
                    ModifierUtils.removeAllCustomModifiers(player);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22279_, "Speed malus 3", -0.45, AttributeModifier.Operation.MULTIPLY_TOTAL, SPEED_MALUS_3_UUID);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22281_, "Damage malus 3", -0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22283_, "Mining Fatigue malus 3", -0.99, AttributeModifier.Operation.MULTIPLY_TOTAL);
                }
            } else if ((double)shortStam <= Settings.getNegativeEffect2Threshold()) {
                newThreshold = 1;
                PlayerTickHandler.hungerSimulation(player, hungerDrainInterval);
                if (!hasMalus2) {
                    ModifierUtils.removeAllCustomModifiers(player);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22279_, "Speed malus 2", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL, SPEED_MALUS_2_UUID);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22281_, "Damage malus 2", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22283_, "Mining Fatigue malus 2", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
                }
            } else if ((double)shortStam <= Settings.getNegativeEffect1Threshold()) {
                newThreshold = 0;
                if (!hasMalus1) {
                    ModifierUtils.removeAllCustomModifiers(player);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22279_, "Speed malus 1", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL, SPEED_MALUS_1_UUID);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22281_, "Damage malus 1", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
                }
            } else if ((double)shortStam >= Settings.getPositiveEffectThreshold()) {
                if (!hasBonus1) {
                    ModifierUtils.removeAllCustomModifiers(player);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22279_, "Speed bonus 1", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL, SPEED_BONUS_1_UUID);
                    ModifierUtils.addCustomModifier(player, Attributes.f_22281_, "Damage bonus 1", 3.0, AttributeModifier.Operation.ADDITION);
                }
            } else {
                ModifierUtils.removeAllCustomModifiers(player);
            }
            ModMessages.sendToPlayer(new PlaySoundPacket(newThreshold), (ServerPlayer)player);
            stamina.tick(player, 5);
            ModMessages.sendToPlayer(new StaminaDataSyncS2CPacket(shortStam, longStam, stamina.getLongStaminaCap(), stamina.getStaminaExp(), stamina.getStaminaLvl()), (ServerPlayer)player);
        });
    }

    private static boolean isPlayerWalking(Player player) {
        UUID id = player.m_20148_();
        double x = player.m_20185_();
        double z = player.m_20189_();
        double lastX = lastPlayerPosX.getOrDefault(id, x);
        double lastZ = lastPlayerPosZ.getOrDefault(id, z);
        double distanceMoved = Math.sqrt(Math.pow(x - lastX, 2.0) + Math.pow(z - lastZ, 2.0));
        lastPlayerPosX.put(id, x);
        lastPlayerPosZ.put(id, z);
        return distanceMoved > 0.001 && !player.m_20142_();
    }

    public static void applyNegativeEffects(Player player) {
        int duration = 100;
        PlayerTickHandler.refreshEffect(player, MobEffects.f_19610_, 0, duration);
    }

    public static void applyPositiveEffects(Player player, int amplifier) {
        int duration = 100;
        PlayerTickHandler.refreshEffect(player, MobEffects.f_19596_, amplifier, duration);
        PlayerTickHandler.refreshEffect(player, MobEffects.f_19598_, amplifier, duration);
        PlayerTickHandler.refreshEffect(player, MobEffects.f_19600_, amplifier, duration);
    }

    private static void refreshEffect(Player player, MobEffect effect, int amplifier, int duration) {
        MobEffectInstance current = player.m_21124_(effect);
        if (current == null || current.m_19557_() <= 40 || current.m_19564_() != amplifier) {
            player.m_7292_(new MobEffectInstance(effect, duration, amplifier, false, false));
        }
    }

    private static void hungerSimulation(Player player, int hungerDrainInterval) {
        if (currentTick % hungerDrainInterval == 0) {
            FoodData foodData = player.m_36324_();
            if (foodData.m_38722_() > 0.0f) {
                foodData.m_38717_(Math.max(foodData.m_38722_() - 1.0f, 0.0f));
            } else {
                foodData.m_38705_(Math.max(foodData.m_38702_() - 1, 0));
            }
        }
    }

    public static float getArmorStaminaMultiplier(Player player, String activity) {
        float multiplier = 1.0f;
        if (Objects.equals(activity, "action")) {
            Item material;
            ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
            ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
            Item item = helmet.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem helmetArmor = (ArmorItem)item;
                material = helmetArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("helmetaction"));
            }
            if ((material = chest.m_41720_()) instanceof ArmorItem) {
                ArmorItem chestArmor = (ArmorItem)material;
                material = chestArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("chestplateaction"));
            }
            if ((material = legs.m_41720_()) instanceof ArmorItem) {
                ArmorItem legArmor = (ArmorItem)material;
                material = legArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("leggingsaction"));
            }
            if ((material = boots.m_41720_()) instanceof ArmorItem) {
                ArmorItem bootArmor = (ArmorItem)material;
                material = bootArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("bootsaction"));
            }
        } else if (Objects.equals(activity, "movement")) {
            ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
            ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
            Item material = helmet.m_41720_();
            if (material instanceof ArmorItem) {
                ArmorItem helmetArmor = (ArmorItem)material;
                material = helmetArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("helmetmovement"));
            }
            if ((material = chest.m_41720_()) instanceof ArmorItem) {
                ArmorItem chestArmor = (ArmorItem)material;
                material = chestArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("chestplatemovement"));
            }
            if ((material = legs.m_41720_()) instanceof ArmorItem) {
                ArmorItem legArmor = (ArmorItem)material;
                material = legArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("leggingsmovement"));
            }
            if ((material = boots.m_41720_()) instanceof ArmorItem) {
                ArmorItem bootArmor = (ArmorItem)material;
                material = bootArmor.m_40401_();
                multiplier += PlayerTickHandler.pieceMultiplier(PlayerTickHandler.materialMultiplier((ArmorMaterial)material), (float)Settings.getArmorCost("bootsmovement"));
            }
        }
        return multiplier;
    }

    public static float pieceMultiplier(float multiplier, float relevanceFactor) {
        return multiplier * relevanceFactor;
    }

    public static float materialMultiplier(ArmorMaterial material) {
        if (material.equals(ArmorMaterials.LEATHER)) {
            return (float)Settings.getArmorCost("leather");
        }
        if (material.equals(ArmorMaterials.CHAIN)) {
            return (float)Settings.getArmorCost("chain");
        }
        if (material.equals(ArmorMaterials.IRON)) {
            return (float)Settings.getArmorCost("iron");
        }
        if (material.equals(ArmorMaterials.GOLD)) {
            return (float)Settings.getArmorCost("gold");
        }
        if (material.equals(ArmorMaterials.DIAMOND)) {
            return (float)Settings.getArmorCost("diamond");
        }
        if (material.equals(ArmorMaterials.NETHERITE)) {
            return (float)Settings.getArmorCost("netherite");
        }
        return (float)Settings.getArmorCost("unknown");
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> stamina.consume((float)Settings.getCombatCost("hit", true), (float)Settings.getCombatCost("hit", false), PlayerTickHandler.getArmorStaminaMultiplier(player, "action"), player));
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float damage = event.getAmount();
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> stamina.consume((float)Settings.getCombatCost("hit", true) * damage, (float)Settings.getCombatCost("hit", false) * damage, 0.0f, player));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
            BlockState blockState = event.getLevel().m_8055_(event.getPos());
            if (!blockState.m_60795_()) {
                stamina.consume((float)Settings.getInteractCost("click", true), (float)Settings.getInteractCost("click", false), PlayerTickHandler.getArmorStaminaMultiplier(player, "action"), player);
            }
        });
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            miningPlayers.put(player.m_20148_(), event.getPos());
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        miningPlayers.remove(event.getPlayer().m_20148_());
        Player player = event.getPlayer();
        player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> stamina.consume((float)Settings.getMiningCost("break", true), (float)Settings.getMiningCost("break", false), PlayerTickHandler.getArmorStaminaMultiplier(player, "action"), player));
    }

    @SubscribeEvent
    public static void onPlayerStopSwing(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        if (!event.player.f_20911_) {
            miningPlayers.remove(event.player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerTrySleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_7500_() || player2.m_5833_()) {
            return;
        }
        double comfortThreshold = Settings.getComfortThresholdSleep();
        ComfortCalculator.ComfortResult comfortResult = ComfortCalculator.calculateComfort((ServerLevel)player2.m_9236_(), (Player)player2);
        double comfort = comfortResult.comfort;
        List<String> issues = comfortResult.issues;
        if (comfort < comfortThreshold) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player2.m_5661_(ComfortUtils.getComfortMessage((Player)player2, comfort, comfortThreshold, issues), true);
        } else {
            player2.m_5661_(ComfortUtils.formatComfort(comfort), true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float armDamage = 0.0f;
        player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> stamina.consume((float)(Settings.getInteractCost("place", true) - Settings.getInteractCost("click", true)), (float)(Settings.getInteractCost("place", false) - Settings.getInteractCost("click", false)), PlayerTickHandler.getArmorStaminaMultiplier(player, "action"), player));
    }

    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        FoodProperties food;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack stack = event.getItem();
        Item item = stack.m_41720_();
        if (item.m_41472_() && (food = item.m_41473_()) != null) {
            int nutrition = food.m_38744_();
            float saturation = food.m_38745_();
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> stamina.foodEaten(player, nutrition, saturation));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            UUID id = player.m_20148_();
            int counter = vehicleTickCounter.getOrDefault(id, 0) + 1;
            vehicleTickCounter.put(id, counter);
            if (counter < 5) continue;
            vehicleTickCounter.put(id, 0);
            Entity vehicle = player.m_20202_();
            if (vehicle == null) continue;
            if (vehicle instanceof SeatEntity) {
                return;
            }
            if (vehicle instanceof Boat || vehicle instanceof AbstractHorse) {
                Vec3 lastPos = lastPositions.get(vehicle);
                Vec3 currentPos = vehicle.m_20182_();
                if (lastPos == null || !lastPos.equals((Object)currentPos)) {
                    player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                        if (vehicle instanceof AbstractHorse) {
                            stamina.consume((float)Settings.getMovementCost("horseRide", true) * 5.0f, (float)Settings.getMovementCost("horseRide", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier((Player)player, "action"), (Player)player);
                        }
                        if (vehicle instanceof Boat) {
                            stamina.consume((float)Settings.getMovementCost("boatDrive", true) * 5.0f, (float)Settings.getMovementCost("boatDrive", false) * 5.0f, PlayerTickHandler.getArmorStaminaMultiplier((Player)player, "action"), (Player)player);
                        }
                    });
                }
                lastPositions.put(vehicle, currentPos);
                continue;
            }
            player.getCapability(ComfortProvider.COMFORT_CAP).ifPresent(cap -> {
                if (cap.getComfortLevel() >= (double)Settings.getComfortThresholdSit()) {
                    PlayerTickHandler.applyRest((Player)player);
                }
            });
        }
    }

    private static void applyRest(Player player) {
        player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> player.getCapability(ComfortProvider.COMFORT_CAP).ifPresent(cap -> {
            float comfort = (float)cap.getComfortLevel();
            double hardnessFactor = 2.0;
            stamina.rest(player, (float)((double)comfort * Settings.getRegenerationConfigs("comfortRegMultiplier")) * 5.0f, (float)(hardnessFactor / 1.5));
        }));
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (event.isMounting()) {
            Entity vehicle = event.getEntityBeingMounted();
            if (vehicle instanceof SeatEntity) {
                return;
            }
            if (vehicle instanceof Boat || vehicle instanceof AbstractMinecart || vehicle instanceof AbstractHorse) {
                return;
            }
            double comfortThreshold = Settings.getComfortThresholdSit();
            ComfortCalculator.ComfortResult comfortResult = ComfortCalculator.calculateComfort((ServerLevel)player.m_9236_(), player);
            double comfort = comfortResult.comfort;
            List<String> issues = comfortResult.issues;
            if (comfort < comfortThreshold) {
                player.m_5661_(ComfortUtils.getComfortMessage(player, comfort, comfortThreshold, issues), true);
            } else {
                player.m_5661_(ComfortUtils.formatComfort(comfort), true);
            }
            player.getCapability(ComfortProvider.COMFORT_CAP).ifPresent(cap -> {
                cap.setComfortLevel(comfort);
                cap.setSitting(true);
            });
        }
    }
}

