/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.networking.packet;

import com.fireblaze.exhausted.client.ClientStaminaData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class StaminaDataSyncS2CPacket {
    private final float shortStamina;
    private final float longStamina;
    private final float maxStamina;
    private final float staminaExp;
    private final int staminaLvl;

    public StaminaDataSyncS2CPacket(float shortStamina, float longStamina, float maxStamina, float staminaExp, int staminaLvl) {
        this.shortStamina = shortStamina;
        this.longStamina = longStamina;
        this.maxStamina = maxStamina;
        this.staminaExp = staminaExp;
        this.staminaLvl = staminaLvl;
    }

    public StaminaDataSyncS2CPacket(float maxStamina) {
        this.shortStamina = maxStamina;
        this.longStamina = maxStamina;
        this.maxStamina = maxStamina;
        this.staminaExp = 9990.0f;
        this.staminaLvl = 10;
        System.out.println("GOOD MORNING | " + maxStamina);
    }

    public StaminaDataSyncS2CPacket(FriendlyByteBuf buf) {
        this.shortStamina = buf.readFloat();
        this.longStamina = buf.readFloat();
        this.maxStamina = buf.readFloat();
        this.staminaExp = buf.readFloat();
        this.staminaLvl = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.shortStamina);
        buf.writeFloat(this.longStamina);
        buf.writeFloat(this.maxStamina);
        buf.writeFloat(this.staminaExp);
        buf.writeInt(this.staminaLvl);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientStaminaData.set(this.shortStamina, this.longStamina, this.maxStamina, this.staminaExp, this.staminaLvl));
        return true;
    }
}

