/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted;

import com.fireblaze.exhausted.capability.Stamina;
import com.fireblaze.exhausted.capability.StaminaProvider;
import com.fireblaze.exhausted.comfort.ComfortCalculator;
import com.fireblaze.exhausted.comfort.ComfortProvider;
import com.fireblaze.exhausted.comfort.ComfortUtils;
import com.fireblaze.exhausted.config.Settings;
import com.fireblaze.exhausted.config.StaminaConfig;
import com.fireblaze.exhausted.entity.ModEntities;
import com.fireblaze.exhausted.entity.SeatEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="exhausted")
public class ModEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(StaminaProvider.PLAYER_STAMINA).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"exhausted", (String)"properties"), (ICapabilityProvider)new StaminaProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(oldStore -> event.getEntity().getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(newStore -> {
            boolean keepLevel = (Boolean)StaminaConfig.KEEP_LEVEL_ON_DEATH.get();
            boolean keepStamina = (Boolean)StaminaConfig.KEEP_STAMINA_ON_DEATH.get();
            if (keepLevel && keepStamina) {
                newStore.copyFrom((Stamina)oldStore);
            } else if (keepLevel) {
                newStore.setStaminaLvl(oldStore.getStaminaLvl());
                newStore.setStaminaExp(oldStore.getStaminaExp());
            } else if (keepStamina) {
                newStore.setShortStamina(oldStore.getShortStamina());
                newStore.setLongStamina(oldStore.getLongStamina());
            }
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(Stamina.class);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.m_9236_();
        if (!level.f_46443_ && event.getHand() == InteractionHand.MAIN_HAND && player2.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            BlockPos clickedPos = event.getPos();
            BlockState clickedBlock = level.m_8055_(clickedPos);
            BlockPos blockUnderFeet = player2.m_20183_();
            if (!clickedPos.equals((Object)blockUnderFeet) && !clickedPos.equals((Object)blockUnderFeet.m_7495_())) {
                return;
            }
            VoxelShape shape = clickedBlock.m_60812_((BlockGetter)level, clickedPos);
            if (shape.m_83281_()) {
                return;
            }
            double blockHeight = clickedBlock.m_60734_() instanceof StairBlock ? 0.5 : clickedBlock.m_60808_((BlockGetter)level, clickedPos).m_83297_(Direction.Axis.Y);
            double sitHeight = (double)clickedPos.m_123342_() + blockHeight - 0.2;
            SeatEntity seat = new SeatEntity((EntityType)ModEntities.SEAT.get(), level);
            seat.m_6027_((double)clickedPos.m_123341_() + 0.5, sitHeight, (double)clickedPos.m_123343_() + 0.5);
            level.m_7967_((Entity)seat);
            double comfortThreshold = Settings.getComfortThresholdSit();
            ComfortCalculator.ComfortResult comfortResult = ComfortCalculator.calculateComfort(player2.m_284548_(), (Player)player2);
            double comfort = comfortResult.comfort;
            List<String> issues = comfortResult.issues;
            if (comfort < comfortThreshold) {
                player2.m_5661_(ComfortUtils.getComfortMessage((Player)player2, comfort, comfortThreshold, issues), true);
                seat.m_146870_();
                return;
            }
            player2.m_5661_(ComfortUtils.formatComfort(comfort), true);
            player2.m_20329_((Entity)seat);
            player2.getCapability(ComfortProvider.COMFORT_CAP).ifPresent(cap -> {
                cap.setComfortLevel(comfort);
                cap.setSitting(true);
            });
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

