/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.capability;

import com.fireblaze.exhausted.config.Settings;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class Stamina {
    private float shortStamina = 100.0f;
    private float longStamina = 100.0f;
    private static final float MIN_STAMINA = 0.0f;
    private static final float MAX_STAMINA = 100.0f;
    private float BASE_REGEN;
    private float AMPLIFIED_REGEN;
    private float armStrength;
    private float legStrength;
    private float staminaConsumption;
    private int staminaLvl = 0;
    private static final int MAX_STAMINA_LEVEL = 20;
    private float staminaExp = 0.0f;
    private int tickCounter = 0;

    public void tick(Player player, int tickMultiplier) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        this.regenerate(player, 1.0f, tickMultiplier);
    }

    public void rest(Player player, float restFactor, float hardnessFactor) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        float damageMultiplier = 1.0f;
        this.BASE_REGEN = (float)Settings.getRegenerationConfigs("baseRegenLong");
        this.AMPLIFIED_REGEN = (float)Math.min((double)(this.BASE_REGEN * damageMultiplier) * (1.0 + (double)this.staminaLvl * 0.03) * (double)restFactor * (double)hardnessFactor, 100.0);
        this.longStamina = Math.min(this.longStamina + this.AMPLIFIED_REGEN, 100.0f);
        this.regenerate(player, restFactor, hardnessFactor);
    }

    public void regenerate(Player player, float restFactor, float hardnessFactor) {
        float damageMultiplier = 1.0f;
        if (this.shortStamina < this.longStamina) {
            this.BASE_REGEN = (float)Settings.getRegenerationConfigs("baseRegenShort") * this.longStamina;
            this.AMPLIFIED_REGEN = (float)Math.min((double)(this.BASE_REGEN * damageMultiplier) * (1.0 + (double)this.staminaLvl * 0.05) * (double)restFactor * (double)hardnessFactor, (double)this.longStamina);
            this.shortStamina = Math.min(this.shortStamina + this.AMPLIFIED_REGEN, this.longStamina);
        }
    }

    public void consume(float shortStamina, float longStamina, float armorMultiplier, Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        this.shortStamina = (float)Math.max((double)this.shortStamina - (double)(shortStamina * armorMultiplier) * (1.0 - (double)this.staminaLvl * 0.015), 0.0);
        this.longStamina = (float)Math.max((double)this.longStamina - (double)(longStamina * armorMultiplier) * (1.0 - (double)this.staminaLvl * 0.03), 0.0);
        this.addExperience(shortStamina + longStamina, player);
    }

    public void consume(float shortStamina, float longStamina, float armorMultiplier, float blockHardness, Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        this.shortStamina = (float)Math.max(0.0, (double)this.shortStamina - (double)(shortStamina * armorMultiplier) * (1.0 - (double)this.staminaLvl * 0.0075));
        this.longStamina = (float)Math.max(0.0, (double)this.longStamina - (double)(longStamina * armorMultiplier) * (1.0 - (double)this.staminaLvl * 0.02));
        if (this.staminaLvl < 20) {
            this.addExperience(shortStamina + longStamina, player);
        }
    }

    public void foodEaten(Player player, int nutrition, float saturation) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        float longStaminaGain = (float)((double)((float)nutrition + saturation) * Settings.getRegenerationConfigs("foodFactor"));
        this.longStamina += longStaminaGain;
    }

    public void addExperience(float exp_gains, Player player) {
        this.staminaExp += exp_gains;
        while (this.staminaExp >= this.getExperienceToNextLevel() && this.staminaLvl < 20) {
            this.staminaExp -= this.getExperienceToNextLevel();
            ++this.staminaLvl;
            this.onLevelUp(player);
        }
        if (this.staminaLvl >= 20) {
            this.staminaExp = 0.0f;
        }
    }

    private float getExperienceToNextLevel() {
        return 100 * this.staminaLvl * this.staminaLvl;
    }

    private void onLevelUp(Player player) {
        player.m_5661_((Component)Component.m_237113_((String)("\u00a7aYou have reached Stamina Level " + this.staminaLvl)), true);
        player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void strength_add_exp(String bodyPart, float exp_gains) {
        if (Objects.equals(bodyPart, "leg") || Objects.equals(bodyPart, "arm")) {
            // empty if block
        }
    }

    public float resetStamina() {
        this.shortStamina = 100.0f;
        this.longStamina = 100.0f;
        return 100.0f;
    }

    public float getShortStamina() {
        return this.shortStamina;
    }

    public float getLongStamina() {
        return this.longStamina;
    }

    public float getLongStaminaCap() {
        return 100.0f;
    }

    public float getStaminaExp() {
        return this.staminaExp;
    }

    public int getStaminaLvl() {
        return this.staminaLvl;
    }

    public void setShortStamina(float shortStamina) {
        this.shortStamina = shortStamina;
    }

    public void setLongStamina(float longStamina) {
        this.longStamina = longStamina;
    }

    public void setStaminaLvl(int staminaLvl) {
        this.staminaLvl = staminaLvl;
    }

    public void setStaminaExp(float staminaExp) {
        this.staminaExp = staminaExp;
    }

    public void copyFrom(Stamina source) {
        this.shortStamina = source.shortStamina;
        this.longStamina = source.longStamina;
        this.staminaLvl = source.staminaLvl;
        this.staminaExp = source.staminaExp;
    }

    public void saveNBTData(CompoundTag tag) {
        tag.m_128350_("stamina", this.shortStamina);
        tag.m_128350_("longStamina", this.longStamina);
        tag.m_128405_("staminaLvl", this.staminaLvl);
        tag.m_128350_("staminaExp", this.staminaExp);
    }

    public void loadNBTData(CompoundTag tag) {
        this.shortStamina = tag.m_128457_("stamina");
        this.longStamina = tag.m_128457_("longStamina");
        this.staminaLvl = tag.m_128441_("staminaLvl") ? tag.m_128451_("staminaLvl") : 0;
        this.staminaExp = tag.m_128441_("staminaExp") ? tag.m_128457_("staminaExp") : 0.0f;
    }
}

