/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.comfort;

import com.fireblaze.exhausted.config.Settings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ComfortHelper {
    private static final Map<ServerLevel, Map<BlockPos, BlockState>> replacedBlocks = new HashMap<ServerLevel, Map<BlockPos, BlockState>>();
    private static final Map<Player, RoomScanResults> lastRoomScans = new HashMap<Player, RoomScanResults>();

    private static boolean isComfortBlock(Block block) {
        EntityBlock entityBlock;
        BlockEntity be;
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String registryName = id.toString();
        if (Settings.getComfortBlocks().contains(registryName)) {
            return true;
        }
        for (String keyword : Settings.getComfortBlockGroups()) {
            if (!registryName.contains(keyword)) continue;
            return true;
        }
        return Settings.isComfortStorageAllowed() && block instanceof EntityBlock && (be = (entityBlock = (EntityBlock)block).m_142194_(BlockPos.f_121853_, block.m_49966_())) instanceof Container;
    }

    public static boolean monstersNearby(ServerLevel level, Player player) {
        return !level.m_6249_((Entity)player, player.m_20191_().m_82400_(Settings.getComfortSettings("monsterRangeTolerance")), e -> e.m_6095_().m_20674_() == MobCategory.MONSTER).isEmpty();
    }

    public static boolean hasCeilingHeight(ServerLevel level, Player player, int minHeight) {
        BlockPos pos = player.m_20183_();
        for (int y = 1; y <= minHeight; ++y) {
            if (level.m_46859_(pos.m_6630_(y))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEnoughSpace(ServerLevel level, Player player, int minAirBlocks) {
        RoomScanResults result = lastRoomScans.get(player);
        if (result == null) {
            result = ComfortHelper.scanRoom(level, player);
        }
        return result.airBlocks >= minAirBlocks;
    }

    public static RoomScanResults getLastScan(Player player) {
        return lastRoomScans.get(player);
    }

    public static RoomScanResults scanRoom(ServerLevel level, Player player) {
        int lightSum = 0;
        int lightCount = 0;
        RoomScanResults result = new RoomScanResults();
        HashSet<BlockPos> badBlocksSet = new HashSet<BlockPos>();
        HashSet<BlockPos> goodBlocksSet = new HashSet<BlockPos>();
        int maxAirBlocks = 500;
        BlockPos start = player.m_20183_();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        visited.add(start);
        block0: while (!queue.isEmpty() && result.airBlocks < maxAirBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            for (BlockPos neighbor : List.of(current.m_122012_(), current.m_122019_(), current.m_122029_(), current.m_122024_(), current.m_7494_(), current.m_7495_())) {
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                BlockState state = level.m_8055_(neighbor);
                lightSum += level.m_45517_(LightLayer.BLOCK, neighbor);
                ++lightCount;
                if (state.m_60795_()) {
                    ++result.airBlocks;
                    queue.add(neighbor);
                    lightSum += level.m_45517_(LightLayer.BLOCK, neighbor);
                    ++lightCount;
                } else {
                    ++result.totalBlocks;
                    if (ComfortHelper.isCaveBlock(level, neighbor)) {
                        ++result.badBlocks;
                        badBlocksSet.add(neighbor);
                    } else {
                        ++result.goodBlocks;
                        goodBlocksSet.add(neighbor);
                    }
                    lightSum += level.m_45517_(LightLayer.BLOCK, neighbor);
                    ++lightCount;
                }
                if (result.airBlocks >= maxAirBlocks) continue block0;
                if (!(state.m_60734_() instanceof ChestBlock)) continue;
                result.chestPositions.add(neighbor);
            }
        }
        result.averageLight = lightCount > 0 ? (float)lightSum / (float)lightCount : 0.0f;
        result.visitedPositions = new HashSet<BlockPos>(visited);
        System.out.println(result.badBlocks + " | " + (result.totalBlocks - result.badBlocks));
        result.decorated = result.totalBlocks == 0 || (float)result.badBlocks / (float)result.totalBlocks <= 0.5f;
        lastRoomScans.put(player, result);
        return result;
    }

    public static boolean hasDecoratedWalls(ServerLevel level, Player player) {
        return ComfortHelper.scanRoom((ServerLevel)level, (Player)player).decorated;
    }

    public static boolean hasCeilingHeight(ServerLevel level, Player player) {
        BlockPos pos = player.m_20183_();
        for (int i = 1; i <= 3; ++i) {
            if (!level.m_8055_(pos.m_6630_(i)).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private static void highlightBlocks(ServerLevel level, Set<BlockPos> badBlocks, Set<BlockPos> goodBlocks) {
        replacedBlocks.putIfAbsent(level, new HashMap());
        Map<BlockPos, BlockState> levelReplacements = replacedBlocks.get(level);
        for (BlockPos pos : badBlocks) {
            levelReplacements.putIfAbsent(pos, level.m_8055_(pos));
            level.m_7731_(pos, Blocks.f_50108_.m_49966_(), 3);
        }
        for (BlockPos pos : goodBlocks) {
            if (level.m_8055_(pos).m_60734_() instanceof ChestBlock) continue;
            levelReplacements.putIfAbsent(pos, level.m_8055_(pos));
            level.m_7731_(pos, Blocks.f_50107_.m_49966_(), 3);
        }
    }

    public static void resetHighlightedBlocks(ServerLevel level) {
        if (!replacedBlocks.containsKey(level)) {
            return;
        }
        Map<BlockPos, BlockState> levelReplacements = replacedBlocks.get(level);
        for (Map.Entry<BlockPos, BlockState> entry : levelReplacements.entrySet()) {
            level.m_7731_(entry.getKey(), entry.getValue(), 3);
        }
        replacedBlocks.remove(level);
    }

    private static boolean isCaveBlock(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_(Blocks.f_50069_) || state.m_60713_(Blocks.f_152550_) || state.m_60713_(Blocks.f_49994_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_152496_) || state.m_60713_(Blocks.f_50134_) || state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_) || state.m_60713_(Blocks.f_50137_) || state.m_60713_(Blocks.f_50730_) || state.m_60713_(Blocks.f_50259_) || state.m_60734_().m_7705_().toLowerCase().contains("ore");
    }

    public static boolean hasGoodLighting(Player player) {
        RoomScanResults result = lastRoomScans.get(player);
        if (result != null && result.averageLight >= 3.5f) {
            return true;
        }
        Level level = player.m_9236_();
        BlockPos pos = player.m_20183_().m_7494_();
        if (level.m_46461_()) {
            while (pos.m_123342_() < level.m_151558_()) {
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60795_() || state.m_60713_(Blocks.f_50058_) || state.m_204336_(BlockTags.f_13035_) || state.m_60713_(Blocks.f_50081_))) {
                    return false;
                }
                pos = pos.m_7494_();
            }
            return true;
        }
        return false;
    }

    public static boolean chestWithFoodNearby(ServerLevel level, Player player) {
        RoomScanResults scan = lastRoomScans.get(player);
        if (scan == null) {
            return false;
        }
        for (BlockPos pos : scan.chestPositions) {
            BlockEntity be = level.m_7702_(pos);
            if (!(be instanceof ChestBlockEntity)) continue;
            ChestBlockEntity chest = (ChestBlockEntity)be;
            for (int i = 0; i < chest.m_6643_(); ++i) {
                ItemStack stack = chest.m_8020_(i);
                if (!stack.m_41614_()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasFriendlyAnimalNearby(ServerLevel level, Player player) {
        RoomScanResults scan = lastRoomScans.get(player);
        if (scan == null || scan.visitedPositions == null) {
            return false;
        }
        for (BlockPos pos : scan.visitedPositions) {
            AABB box = new AABB(pos);
            List entities = level.m_6249_((Entity)null, box, e -> e.m_6095_().m_20674_() == MobCategory.CREATURE || e.m_6095_() == EntityType.f_20499_ || e.m_6095_() == EntityType.f_20553_);
            if (entities.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static int countComfortBlocks(ServerLevel level, Player player) {
        RoomScanResults scan = lastRoomScans.get(player);
        if (scan == null || scan.visitedPositions == null) {
            return 0;
        }
        Settings.loadComfortSettings();
        int count = 0;
        for (BlockPos pos : scan.visitedPositions) {
            BlockState state = level.m_8055_(pos);
            if (!ComfortHelper.isComfortBlock(state.m_60734_())) continue;
            ++count;
        }
        return count;
    }

    public static boolean hasBoostBlock(ServerLevel level, Player player) {
        RoomScanResults scan = lastRoomScans.get(player);
        if (scan == null || scan.visitedPositions == null) {
            return false;
        }
        String dim = level.m_46472_().m_135782_().toString();
        Map<String, String> boostMap = Settings.getDimensionBoostBlocks();
        String blockId = boostMap.get(dim);
        if (blockId == null) {
            return false;
        }
        Block targetBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.parse((String)blockId));
        if (targetBlock == null) {
            return false;
        }
        for (BlockPos pos : scan.visitedPositions) {
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_(targetBlock)) continue;
            System.out.println("Boost block found: " + blockId);
            return true;
        }
        return false;
    }

    public static class RoomScanResults {
        public int airBlocks;
        public int totalBlocks;
        public int badBlocks;
        public int goodBlocks;
        public boolean decorated;
        public float averageLight;
        public List<BlockPos> chestPositions = new ArrayList<BlockPos>();
        public Set<BlockPos> visitedPositions;
    }
}

