/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.comfort;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ComfortUtils {
    public static Component formatComfort(double comfort) {
        String color = comfort >= 75.0 ? "\u00a7a" : (comfort >= 40.0 ? "\u00a7e" : "\u00a7c");
        DecimalFormat df = new DecimalFormat("0.##");
        String formatted = df.format(comfort);
        return Component.m_237113_((String)(color + "Comfort: " + formatted));
    }

    public static Component getComfortMessage(Player player, double comfort, double comfortThreshold, List<String> issues) {
        if (!player.m_6047_()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (String issue : issues) {
                messages.addAll(ComfortUtils.getMessagesForIssue(issue));
            }
            if (!messages.isEmpty()) {
                String random = (String)messages.get((int)(Math.random() * (double)messages.size()));
                DecimalFormat df = new DecimalFormat("0.##");
                String formattedComfort = df.format(comfort);
                String formattedThreshold = df.format(comfortThreshold);
                return Component.m_237113_((String)("\u00a7c" + random + " (" + formattedComfort + "/" + formattedThreshold + " comfort)"));
            }
        }
        return ComfortUtils.formatComfort(comfort);
    }

    public static List<String> getMessagesForIssue(String issue) {
        ArrayList<String> messages = new ArrayList<String>();
        switch (issue) {
            case "low_ceiling": {
                messages.add("I feel cramped here");
                break;
            }
            case "not_enough_space": {
                messages.add("Not enough space to sit comfortably");
                messages.add("I can hardly stretch my legs");
                break;
            }
            case "no_deco_walls": {
                messages.add("The walls give me a very cavy feeling");
                messages.add("The ground is hard and dirty");
                break;
            }
            case "dark": {
                messages.add("It's too dark to relax");
                messages.add("It's pitch black");
                break;
            }
            case "lonely": {
                messages.add("I wish I had a pet");
                messages.add("I feel lonely");
                break;
            }
            case "no_food_stuck": {
                messages.add("What should I eat tomorrow?");
                messages.add("I have no food stocked");
                break;
            }
            case "wet": {
                messages.add("I'm getting wet");
                messages.add("The rain is tedious");
                break;
            }
            case "hurt": {
                messages.add("I'm hurt and uneasy");
                break;
            }
            case "hungry": {
                messages.add("I'm hungry and can't relax");
                messages.add("My stomach is growling");
                break;
            }
            case "foreign_dimension": {
                messages.add("This dimension is scary");
                break;
            }
            case "monsters": {
                messages.add("The monsters are scary");
                messages.add("I can hear monsters");
            }
        }
        return messages;
    }
}

