/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.commands;

import com.fireblaze.exhausted.capability.StaminaProvider;
import com.fireblaze.exhausted.comfort.ComfortHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class StaminaCommands {
    private static final int MIN_LEVEL = 1;
    private static final int MAX_LEVEL = 20;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stamina").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"level").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(ctx -> StaminaCommands.setLevel(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"), (CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return StaminaCommands.setLevel(targets, value, (CommandSourceStack)ctx.getSource());
        })))))).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"level").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StaminaCommands.addLevel(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return StaminaCommands.addLevel(targets, amount, (CommandSourceStack)ctx.getSource());
        })))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82127_((String)"level").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StaminaCommands.removeLevel(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return StaminaCommands.removeLevel(targets, amount, (CommandSourceStack)ctx.getSource());
        })))))).then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"exp").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StaminaCommands.setExp(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"), (CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return StaminaCommands.setExp(targets, value, (CommandSourceStack)ctx.getSource());
        })))))).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"exp").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StaminaCommands.addExp(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return StaminaCommands.addExp(targets, amount, (CommandSourceStack)ctx.getSource());
        })))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82127_((String)"exp").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StaminaCommands.removeExp(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return StaminaCommands.removeExp(targets, amount, (CommandSourceStack)ctx.getSource());
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"comfort_reset").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            ComfortHelper.resetHighlightedBlocks(level);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Highlighted blocks reset!"), true);
            return 1;
        }));
    }

    private static int setLevel(ServerPlayer player, int value, CommandSourceStack source) {
        return StaminaCommands.setLevel(List.of(player), value, source);
    }

    private static int setLevel(Collection<ServerPlayer> players, int value, CommandSourceStack source) {
        for (ServerPlayer player : players) {
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                stamina.setStaminaLvl(value);
                stamina.setStaminaExp(0.0f);
                source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " Stamina Level set to " + value)), true);
            });
        }
        return 1;
    }

    private static int addLevel(ServerPlayer player, int amount, CommandSourceStack source) {
        return StaminaCommands.addLevel(List.of(player), amount, source);
    }

    private static int addLevel(Collection<ServerPlayer> players, int amount, CommandSourceStack source) {
        for (ServerPlayer player : players) {
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                int newLevel = Math.min(20, stamina.getStaminaLvl() + amount);
                stamina.setStaminaLvl(newLevel);
                source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " Stamina Level increased by " + amount + " (now: " + newLevel + ")")), true);
            });
        }
        return 1;
    }

    private static int removeLevel(ServerPlayer player, int amount, CommandSourceStack source) {
        return StaminaCommands.removeLevel(List.of(player), amount, source);
    }

    private static int removeLevel(Collection<ServerPlayer> players, int amount, CommandSourceStack source) {
        for (ServerPlayer player : players) {
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                int newLevel = Math.max(1, stamina.getStaminaLvl() - amount);
                stamina.setStaminaLvl(newLevel);
                source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " Stamina Level decreased by " + amount + " (now: " + newLevel + ")")), true);
            });
        }
        return 1;
    }

    private static int setExp(ServerPlayer player, int value, CommandSourceStack source) {
        return StaminaCommands.setExp(List.of(player), value, source);
    }

    private static int setExp(Collection<ServerPlayer> players, int value, CommandSourceStack source) {
        for (ServerPlayer player : players) {
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                stamina.setStaminaExp(value);
                source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " Stamina Experience set to " + value)), true);
            });
        }
        return 1;
    }

    private static int addExp(ServerPlayer player, int amount, CommandSourceStack source) {
        return StaminaCommands.addExp(List.of(player), amount, source);
    }

    private static int addExp(Collection<ServerPlayer> players, int amount, CommandSourceStack source) {
        for (ServerPlayer player : players) {
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                float newExp = stamina.getStaminaExp() + (float)amount;
                stamina.setStaminaExp(newExp);
                source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " Stamina Experience increased by " + amount + " (now: " + newExp + ")")), true);
            });
        }
        return 1;
    }

    private static int removeExp(ServerPlayer player, int amount, CommandSourceStack source) {
        return StaminaCommands.removeExp(List.of(player), amount, source);
    }

    private static int removeExp(Collection<ServerPlayer> players, int amount, CommandSourceStack source) {
        for (ServerPlayer player : players) {
            player.getCapability(StaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                float newExp = Math.max(0.0f, stamina.getStaminaExp() - (float)amount);
                stamina.setStaminaExp(newExp);
                source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " Stamina Experience decreased by " + amount + " (now: " + newExp + ")")), true);
            });
        }
        return 1;
    }
}

