/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.config;

import com.fireblaze.exhausted.config.StaminaConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Settings {
    private static Set<String> comfortBlocks = new HashSet<String>();
    private static Set<String> comfortBlockGroups = new HashSet<String>();
    private static boolean comfortAllowStorage = false;

    public static double getMiningCost(String tool, boolean isShort) {
        if (((Boolean)StaminaConfig.CUSTOM_SETTINGS.get()).booleanValue()) {
            return switch (tool.toLowerCase()) {
                case "hand" -> isShort ? (Double)StaminaConfig.MINING_HAND_SHORT.get() : (Double)StaminaConfig.MINING_HAND_LONG.get();
                case "pickaxe" -> isShort ? (Double)StaminaConfig.MINING_PICKAXE_SHORT.get() : (Double)StaminaConfig.MINING_PICKAXE_LONG.get();
                case "axe" -> isShort ? (Double)StaminaConfig.MINING_AXE_SHORT.get() : (Double)StaminaConfig.MINING_AXE_LONG.get();
                case "shovel" -> isShort ? (Double)StaminaConfig.MINING_SHOVEL_SHORT.get() : (Double)StaminaConfig.MINING_SHOVEL_LONG.get();
                case "hoe" -> isShort ? (Double)StaminaConfig.MINING_HOE_SHORT.get() : (Double)StaminaConfig.MINING_HOE_LONG.get();
                case "shears" -> isShort ? (Double)StaminaConfig.MINING_SHEARS_SHORT.get() : (Double)StaminaConfig.MINING_SHEARS_LONG.get();
                default -> isShort ? (Double)StaminaConfig.MINING_UNKNOWN_SHORT.get() : (Double)StaminaConfig.MINING_UNKNOWN_LONG.get();
            };
        }
        double m = Settings.getDifficultyMultiplier();
        return switch (tool.toLowerCase()) {
            case "hand" -> {
                if (isShort) {
                    yield 0.125 * m;
                }
                yield 0.0125 * m;
            }
            case "pickaxe" -> {
                if (isShort) {
                    yield 0.07 * m;
                }
                yield 0.005 * m;
            }
            case "axe" -> {
                if (isShort) {
                    yield 0.068 * m;
                }
                yield 0.0025 * m;
            }
            case "shovel" -> {
                if (isShort) {
                    yield 0.066 * m;
                }
                yield 1.0E-4 * m;
            }
            case "hoe" -> {
                if (isShort) {
                    yield 0.065 * m;
                }
                yield 8.0E-4 * m;
            }
            case "shears" -> {
                if (isShort) {
                    yield 1.0 * m;
                }
                yield 1.0 * m;
            }
            default -> isShort ? 0.07 * m : 0.007 * m;
        };
    }

    public static double getMovementCost(String type, boolean isShort) {
        if (((Boolean)StaminaConfig.CUSTOM_SETTINGS.get()).booleanValue()) {
            return switch (type.toLowerCase()) {
                case "sprint" -> isShort ? (Double)StaminaConfig.MOVEMENT_SPRINT_SHORT.get() : (Double)StaminaConfig.MOVEMENT_SPRINT_LONG.get();
                case "walk" -> isShort ? (Double)StaminaConfig.MOVEMENT_WALK_SHORT.get() : (Double)StaminaConfig.MOVEMENT_WALK_LONG.get();
                case "swim" -> isShort ? (Double)StaminaConfig.MOVEMENT_SWIM_SHORT.get() : (Double)StaminaConfig.MOVEMENT_SWIM_LONG.get();
                case "crouch" -> isShort ? (Double)StaminaConfig.MOVEMENT_CROUCH_SHORT.get() : (Double)StaminaConfig.MOVEMENT_CROUCH_LONG.get();
                case "jump" -> isShort ? (Double)StaminaConfig.MOVEMENT_JUMP_SHORT.get() : (Double)StaminaConfig.MOVEMENT_JUMP_LONG.get();
                case "horseride" -> isShort ? (Double)StaminaConfig.MOVEMENT_HORSE_RIDE_SHORT.get() : (Double)StaminaConfig.MOVEMENT_HORSE_RIDE_LONG.get();
                case "boatdrive" -> isShort ? (Double)StaminaConfig.MOVEMENT_BOAT_DRIVE_SHORT.get() : (Double)StaminaConfig.MOVEMENT_BOAT_DRIVE_LONG.get();
                default -> isShort ? 5.0E-5 : 0.0;
            };
        }
        double m = Settings.getDifficultyMultiplier();
        return switch (type.toLowerCase()) {
            case "sprint" -> {
                if (isShort) {
                    yield 0.05 * m;
                }
                yield 0.002 * m;
            }
            case "walk" -> {
                if (isShort) {
                    yield 0.0075 * m;
                }
                yield 0.001 * m;
            }
            case "swim" -> {
                if (isShort) {
                    yield 0.0075 * m;
                }
                yield 0.001 * m;
            }
            case "crouch" -> {
                if (isShort) {
                    yield 0.0075 * m;
                }
                yield 0.001 * m;
            }
            case "jump" -> {
                if (isShort) {
                    yield 0.15 * m;
                }
                yield 0.0075 * m;
            }
            default -> isShort ? 5.0E-5 * m : 0.0;
        };
    }

    public static double getCombatCost(String type, boolean isShort) {
        if (((Boolean)StaminaConfig.CUSTOM_SETTINGS.get()).booleanValue()) {
            return switch (type.toLowerCase()) {
                case "hit" -> isShort ? (Double)StaminaConfig.COMBAT_HITTING_SHORT.get() : (Double)StaminaConfig.COMBAT_HITTING_LONG.get();
                case "block" -> isShort ? (Double)StaminaConfig.COMBAT_BLOCKING_SHORT.get() : (Double)StaminaConfig.COMBAT_BLOCKING_LONG.get();
                case "damagetaken" -> isShort ? (Double)StaminaConfig.COMBAT_DAMAGE_TAKEN_SHORT.get() : (Double)StaminaConfig.COMBAT_DAMAGE_TAKEN_LONG.get();
                default -> isShort ? 5.0E-5 : 0.0;
            };
        }
        double m = Settings.getDifficultyMultiplier();
        return switch (type.toLowerCase()) {
            case "hit" -> {
                if (isShort) {
                    yield 0.5 * m;
                }
                yield 0.05 * m;
            }
            case "block" -> {
                if (isShort) {
                    yield 0.0075 * m;
                }
                yield 0.001 * m;
            }
            case "damagetaken" -> {
                if (isShort) {
                    yield 1.0 * m;
                }
                yield 0.1 * m;
            }
            default -> isShort ? 5.0E-5 * m : 0.0;
        };
    }

    public static double getArmorCost(String type) {
        if (((Boolean)StaminaConfig.CUSTOM_SETTINGS.get()).booleanValue()) {
            return switch (type.toLowerCase()) {
                case "leather" -> (Double)StaminaConfig.ARMOR_MATERIAL_LEATHER.get();
                case "chain" -> (Double)StaminaConfig.ARMOR_MATERIAL_CHAIN.get();
                case "iron" -> (Double)StaminaConfig.ARMOR_MATERIAL_IRON.get();
                case "gold" -> (Double)StaminaConfig.ARMOR_MATERIAL_GOLD.get();
                case "diamond" -> (Double)StaminaConfig.ARMOR_MATERIAL_DIAMOND.get();
                case "netherite" -> (Double)StaminaConfig.ARMOR_MATERIAL_NETHERITE.get();
                case "unknown" -> (Double)StaminaConfig.ARMOR_MATERIAL_UNKOWN.get();
                case "helmetaction" -> (Double)StaminaConfig.ARMOR_HELMET_MULTIPLIER_ACTION.get();
                case "chestplateaction" -> (Double)StaminaConfig.ARMOR_CHESTPLATE_MULTIPLIER_ACTION.get();
                case "leggingsaction" -> (Double)StaminaConfig.ARMOR_LEGGINGS_MULTIPLIER_ACTION.get();
                case "bootsaction" -> (Double)StaminaConfig.ARMOR_BOOTS_MULTIPLIER_ACTION.get();
                case "helmetmovement" -> (Double)StaminaConfig.ARMOR_HELMET_MULTIPLIER_MOVEMENT.get();
                case "chestplatemovement" -> (Double)StaminaConfig.ARMOR_CHESTPLATE_MULTIPLIER_MOVEMENT.get();
                case "leggingsmovement" -> (Double)StaminaConfig.ARMOR_LEGGINGS_MULTIPLIER_MOVEMENT.get();
                case "bootsmovement" -> (Double)StaminaConfig.ARMOR_BOOTS_MULTIPLIER_MOVEMENT.get();
                default -> 0.0;
            };
        }
        double m = Settings.getDifficultyMultiplier();
        return switch (type.toLowerCase()) {
            case "leather" -> 0.015 * m;
            case "chain" -> 0.025;
            case "iron" -> 0.05;
            case "gold" -> 0.05;
            case "diamond" -> 0.1;
            case "netherite" -> 0.125;
            case "unknown" -> 0.15;
            case "helmetaction" -> 0.0;
            case "chestplateaction" -> 1.0;
            case "leggingsaction" -> 0.5;
            case "bootsaction" -> 0.25;
            case "helmetmovement" -> 0.25;
            case "chestplatemovement" -> 0.5;
            case "leggingsmovement" -> 1.0;
            case "bootsmovement" -> 0.75;
            default -> 0.0;
        };
    }

    public static double getInteractCost(String type, boolean isShort) {
        if (((Boolean)StaminaConfig.CUSTOM_SETTINGS.get()).booleanValue()) {
            return switch (type.toLowerCase()) {
                case "place" -> isShort ? (Double)StaminaConfig.INTERACT_PLACE_SHORT.get() : (Double)StaminaConfig.INTERACT_PLACE_LONG.get();
                case "click" -> isShort ? (Double)StaminaConfig.INTERACT_CLICK_SHORT.get() : (Double)StaminaConfig.INTERACT_CLICK_LONG.get();
                default -> isShort ? 0.01 : 0.0;
            };
        }
        double m = Settings.getDifficultyMultiplier();
        return switch (type.toLowerCase()) {
            case "place" -> {
                if (isShort) {
                    yield 0.0025 * m;
                }
                yield 5.0E-4 * m;
            }
            case "click" -> {
                if (isShort) {
                    yield 0.175 * m;
                }
                yield 0.015 * m;
            }
            default -> isShort ? 0.01 * m : 0.0;
        };
    }

    public static double getRegenerationConfigs(String type) {
        if (((Boolean)StaminaConfig.CUSTOM_SETTINGS.get()).booleanValue()) {
            return switch (type.toLowerCase()) {
                case "baseregenshort" -> (Double)StaminaConfig.BASE_REGEN_SHORT.get();
                case "baseregenlong" -> (Double)StaminaConfig.BASE_REGEN_LONG.get();
                case "comfortregmultiplier" -> (Double)StaminaConfig.COMFORT_REG_MULTIPLIER.get();
                case "foodfactor" -> (Double)StaminaConfig.FOOD_FACTOR.get();
                default -> 0.0;
            };
        }
        double m = 2.0 - Settings.getDifficultyMultiplier();
        return switch (type.toLowerCase()) {
            case "baseregenshort" -> 2.0E-4 * m;
            case "baseregenlong" -> 0.0015 * m;
            case "comfortregmultiplier" -> 0.0325 * m;
            case "foodfactor" -> 0.075 * m;
            default -> 0.0;
        };
    }

    public static void loadComfortSettings() {
        comfortBlocks.clear();
        comfortBlocks.addAll((Collection)StaminaConfig.COMFORT_BLOCKS.get());
        comfortBlockGroups.clear();
        comfortBlockGroups.addAll((Collection)StaminaConfig.COMFORT_BLOCK_GROUPS.get());
        comfortAllowStorage = (Boolean)StaminaConfig.COMFORT_ALLOW_STORAGE_BLOCKS.get();
    }

    public static Set<String> getComfortBlocks() {
        return comfortBlocks;
    }

    public static Set<String> getComfortBlockGroups() {
        return comfortBlockGroups;
    }

    public static boolean isComfortStorageAllowed() {
        return comfortAllowStorage;
    }

    public static double getComfortBonus(String type) {
        return switch (type.toLowerCase()) {
            case "ceiling" -> ((Integer)StaminaConfig.COMFORT_BONUS_CEILING.get()).intValue();
            case "space" -> ((Integer)StaminaConfig.COMFORT_BONUS_SPACE.get()).intValue();
            case "walls" -> ((Integer)StaminaConfig.COMFORT_BONUS_WALLS.get()).intValue();
            case "light" -> ((Integer)StaminaConfig.COMFORT_BONUS_LIGHT.get()).intValue();
            case "animal" -> ((Integer)StaminaConfig.COMFORT_BONUS_ANIMAL.get()).intValue();
            case "food" -> ((Integer)StaminaConfig.COMFORT_BONUS_FOOD.get()).intValue();
            case "block_max" -> ((Integer)StaminaConfig.COMFORT_BONUS_BLOCK.get()).intValue();
            case "block_per" -> (Double)StaminaConfig.COMFORT_BONUS_PER_BLOCK.get();
            case "boost_block" -> ((Integer)StaminaConfig.COMFORT_BONUS_BOOST_BLOCK.get()).intValue();
            default -> 0.0;
        };
    }

    public static double getComfortMalus(String type) {
        return switch (type.toLowerCase()) {
            case "in_rain" -> ((Integer)StaminaConfig.COMFORT_MALUS_IN_RAIN.get()).intValue();
            case "hurt" -> ((Integer)StaminaConfig.COMFORT_MALUS_HURT.get()).intValue();
            case "hungry" -> ((Integer)StaminaConfig.COMFORT_MALUS_HUNGRY.get()).intValue();
            case "dimension" -> ((Integer)StaminaConfig.COMFORT_MALUS_FOREIGN_DIMENSION.get()).intValue();
            case "monsters" -> ((Integer)StaminaConfig.COMFORT_MALUS_MONSTERS.get()).intValue();
            default -> 0.0;
        };
    }

    public static double getComfortSettings(String type) {
        return switch (type.toLowerCase()) {
            case "monsterrangetolerance" -> ((Integer)StaminaConfig.MONSTER_RANGE_TOLERANCE.get()).intValue();
            default -> 0.0;
        };
    }

    public static int getComfortThresholdSit() {
        return (Integer)StaminaConfig.COMFORT_THRESHOLD_SIT.get();
    }

    public static int getComfortThresholdSleep() {
        return (Integer)StaminaConfig.COMFORT_THRESHOLD_SLEEP.get();
    }

    public static double getPositiveEffectThreshold() {
        return ((Integer)StaminaConfig.POSITIVE_EFFECT_THRESHOLD.get()).intValue();
    }

    public static double getNegativeEffect1Threshold() {
        return ((Integer)StaminaConfig.NEGATIVE_EFFECT_1_THRESHOLD.get()).intValue();
    }

    public static double getNegativeEffect2Threshold() {
        return ((Integer)StaminaConfig.NEGATIVE_EFFECT_2_THRESHOLD.get()).intValue();
    }

    public static double getNegativeEffect3Threshold() {
        return ((Integer)StaminaConfig.NEGATIVE_EFFECT_3_THRESHOLD.get()).intValue();
    }

    public static Map<String, String> getDimensionBoostBlocks() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : (List)StaminaConfig.DIMENSION_BOOST_BLOCKS.get()) {
            String[] parts = entry.split("=");
            if (parts.length != 2) continue;
            map.put(parts[0].trim(), parts[1].trim());
        }
        return map;
    }

    public static StaminaConfig.Difficulty getDifficulty() {
        return (StaminaConfig.Difficulty)((Object)StaminaConfig.DIFFICULTY.get());
    }

    private static double getDifficultyMultiplier() {
        return switch ((StaminaConfig.Difficulty)((Object)StaminaConfig.DIFFICULTY.get())) {
            case StaminaConfig.Difficulty.EASY -> 0.75;
            case StaminaConfig.Difficulty.MEDIUM -> 1.0;
            case StaminaConfig.Difficulty.HARD -> 1.25;
            default -> 1.0;
        };
    }
}

