/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.events;

import com.fireblaze.exhausted.client.ClientStaminaData;
import com.fireblaze.exhausted.entity.ModEntities;
import com.fireblaze.exhausted.entity.client.SeatRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="exhausted", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.SEAT.get(), SeatRenderer::new);
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        int hotbarWidth;
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_7500_() || mc.f_91074_.m_5833_()) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        int barWidth = hotbarWidth = 182;
        int barHeight = 3;
        int cornerRadius = 6;
        int x = (width - barWidth) / 2;
        int y = height - 54;
        float maxStamina = ClientStaminaData.getPlayerMaxStamina();
        float longStamina = ClientStaminaData.getPlayerLongStamina();
        float shortStamina = ClientStaminaData.getPlayerShortStamina();
        int longFill = (int)((float)barWidth * (longStamina / maxStamina));
        int shortFill = (int)((float)barWidth * (shortStamina / maxStamina));
        int debuffThreshold = 15;
        int debuffWidth = (int)((float)barWidth * ((float)debuffThreshold / maxStamina));
        ClientEvents.drawRoundedRectPartial(graphics, x, y, longFill, barHeight, cornerRadius, -1714631476);
        ClientEvents.drawRoundedRectPartialGradient(graphics, x, y, shortFill, barHeight, cornerRadius, -11890462, -13408513);
        if (shortStamina <= (float)debuffThreshold) {
            int redDrawWidth = Math.min(debuffWidth, shortFill);
            ClientEvents.drawRoundedRectPartial(graphics, x, y, redDrawWidth, barHeight, cornerRadius, -1711319723);
        }
        ClientEvents.drawBorder(graphics, x, y, barWidth, barHeight, 1, -16777216);
    }

    private static void drawBorder(GuiGraphics graphics, int x, int y, int width, int height, int thickness, int color) {
        graphics.m_280509_(x - thickness, y - thickness, x + width + thickness, y, color);
        graphics.m_280509_(x - thickness, y + height, x + width + thickness, y + height + thickness, color);
        graphics.m_280509_(x - thickness, y, x, y + height, color);
        graphics.m_280509_(x + width, y, x + width + thickness, y + height, color);
        graphics.m_280509_(x - thickness, y - thickness, x + thickness, y + thickness, color);
        graphics.m_280509_(x + width - thickness, y - thickness, x + width + thickness, y + thickness, color);
        graphics.m_280509_(x - thickness, y + height - thickness, x + thickness, y + height + thickness, color);
        graphics.m_280509_(x + width - thickness, y + height - thickness, x + width + thickness, y + height + thickness, color);
    }

    private static void drawRoundedRectPartial(GuiGraphics graphics, int x, int y, int fillWidth, int height, int radius, int color) {
        if (fillWidth <= 0) {
            return;
        }
        if (fillWidth < radius) {
            graphics.m_280509_(x, y, x + fillWidth, y + height, color);
            return;
        }
        if (fillWidth < radius * 2) {
            graphics.m_280509_(x + radius, y, x + fillWidth, y + height, color);
            graphics.m_280509_(x, y, x + radius, y + height, color);
            return;
        }
        graphics.m_280509_(x + radius, y, x + fillWidth, y + height, color);
        graphics.m_280509_(x, y, x + radius, y + height, color);
    }

    private static void drawRoundedRectPartialGradient(GuiGraphics graphics, int x, int y, int fillWidth, int height, int radius, int topColor, int bottomColor) {
        if (fillWidth <= 0) {
            return;
        }
        if (fillWidth < radius) {
            graphics.m_280024_(x, y, x + fillWidth, y + height, topColor, bottomColor);
            return;
        }
        if (fillWidth < radius * 2) {
            graphics.m_280024_(x + radius, y, x + fillWidth, y + height, topColor, bottomColor);
            graphics.m_280024_(x, y, x + radius, y + height, topColor, bottomColor);
            return;
        }
        graphics.m_280024_(x + radius, y, x + fillWidth, y + height, topColor, bottomColor);
        graphics.m_280024_(x, y, x + radius, y + height, topColor, bottomColor);
    }

    @Mod.EventBusSubscriber(modid="exhausted", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        }
    }
}

