/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.chathighlightnsound;

import com.mojang.logging.LogUtils;
import io.github.catomon.chathighlightnsound.ClientConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"chat_highlight_n_sound");
    public static final DeferredHolder<SoundEvent, SoundEvent> SOUND_1 = SOUNDS.register("sound1", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chat_highlight_n_sound", (String)"sound1")));
    public static final DeferredHolder<SoundEvent, SoundEvent> SOUND_2 = SOUNDS.register("sound2", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chat_highlight_n_sound", (String)"sound2")));
    public static final SoundEvent SOUND_NOTE_BLOCK = (SoundEvent)SoundEvents.NOTE_BLOCK_HARP.value();

    public static void register(IEventBus eventBus) {
        SOUNDS.register(eventBus);
    }

    @SubscribeEvent
    public static void onChatReceived(ClientChatReceivedEvent event) {
        int highlightsCount;
        String processedPlayerName;
        String playerName;
        TranslatableContents translatable;
        String key;
        ComponentContents componentContents = event.getMessage().getContents();
        if (componentContents instanceof TranslatableContents && ((key = (translatable = (TranslatableContents)componentContents).getKey()).startsWith("death.") || key.equals("sleeping.player"))) {
            return;
        }
        String chat = event.getMessage().getString();
        List keywords = (List)ClientConfig.keywords.get();
        ChatFormatting color = (ChatFormatting)ClientConfig.highlightColor.get();
        boolean playSound = (Boolean)ClientConfig.soundOnHighlight.get();
        boolean caseSensitive = (Boolean)ClientConfig.caseSensitive.get();
        boolean highlightPlayerName = (Boolean)ClientConfig.highlightPlayerName.get();
        Minecraft mc = Minecraft.getInstance();
        String string = playerName = mc.player != null ? mc.player.getName().getString() : "";
        if (chat.startsWith("<" + playerName + ">")) {
            return;
        }
        MutableComponent highlightedMessage = Component.empty();
        int lastIndex = 0;
        int maxHighlights = 3;
        String processedChat = caseSensitive ? chat : chat.toLowerCase();
        String string2 = processedPlayerName = caseSensitive ? playerName : playerName.toLowerCase();
        for (highlightsCount = 0; highlightsCount < 3; ++highlightsCount) {
            int playerIdx;
            int nextHighlightIndex = -1;
            int detectedLength = 0;
            for (String keyword : keywords) {
                String processedKeyword = caseSensitive ? keyword : keyword.toLowerCase();
                int idx = processedChat.indexOf(processedKeyword, lastIndex);
                if (idx < 0 || nextHighlightIndex != -1 && idx >= nextHighlightIndex) continue;
                if (highlightPlayerName && !playerName.isEmpty()) {
                    String processedPlayerNameCheck;
                    String string3 = processedPlayerNameCheck = caseSensitive ? playerName : playerName.toLowerCase();
                    if (processedPlayerNameCheck.startsWith(processedKeyword) && processedChat.startsWith(processedPlayerNameCheck, idx)) {
                        nextHighlightIndex = idx;
                        detectedLength = playerName.length();
                        break;
                    }
                }
                nextHighlightIndex = idx;
                detectedLength = keyword.length();
            }
            if (highlightPlayerName && !playerName.isEmpty() && (playerIdx = processedChat.indexOf(processedPlayerName, lastIndex)) >= 0 && (nextHighlightIndex == -1 || playerIdx < nextHighlightIndex)) {
                nextHighlightIndex = playerIdx;
                detectedLength = playerName.length();
            }
            if (nextHighlightIndex == -1) break;
            highlightedMessage.append((Component)Component.literal((String)chat.substring(lastIndex, nextHighlightIndex)));
            highlightedMessage.append((Component)Component.literal((String)chat.substring(nextHighlightIndex, nextHighlightIndex + detectedLength)).withStyle(color));
            lastIndex = nextHighlightIndex + detectedLength;
        }
        if (lastIndex < chat.length()) {
            highlightedMessage.append((Component)Component.literal((String)chat.substring(lastIndex)));
        }
        if (highlightsCount > 0) {
            event.setMessage((Component)highlightedMessage);
            if (playSound) {
                int soundId = (Integer)ClientConfig.soundSelection.get();
                SoundEvent soundToPlay = switch (soundId) {
                    case 1 -> (SoundEvent)SOUND_1.get();
                    case 2 -> (SoundEvent)SOUND_2.get();
                    default -> SOUND_NOTE_BLOCK;
                };
                mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundToPlay, (float)1.0f, (float)0.4f));
            }
        }
    }
}

