/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.chathighlightnsound;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        CLIENT = new Client(builder);
        CLIENT_SPEC = builder.build();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> keywords;
        public final ForgeConfigSpec.EnumValue<ChatFormatting> highlightColor;
        public final ForgeConfigSpec.BooleanValue soundOnHighlight;
        public final ForgeConfigSpec.IntValue soundSelection;
        public final ForgeConfigSpec.BooleanValue caseSensitive;
        public final ForgeConfigSpec.BooleanValue highlightPlayerName;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("chatHighlighter");
            this.keywords = builder.comment("List of keywords to highlight in chat").defineList("keywords", List.of("TagExample123", "TagExample124"), o -> o instanceof String);
            this.highlightColor = builder.comment("Color to use for keyword highlighting").defineEnum("highlightColor", (Enum)ChatFormatting.YELLOW);
            this.soundOnHighlight = builder.comment("Play sound when a keyword is detected").define("soundOnHighlight", true);
            this.soundSelection = builder.comment("Sound selection for chat highlight: 1, 2 or 3").defineInRange("soundSelection", 1, 1, 3);
            this.caseSensitive = builder.comment("Should keyword matching be case sensitive").define("caseSensitive", false);
            this.highlightPlayerName = builder.comment("Should the player name be highlighted in chat").define("highlightPlayerName", true);
            builder.pop();
        }
    }
}

