/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.chathighlightnsound;

import com.mojang.logging.LogUtils;
import io.github.catomon.chathighlightnsound.ClientConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"chat_highlight_n_sound");
    public static final RegistryObject<SoundEvent> SOUND_1 = SOUNDS.register("sound1", () -> SoundEvent.m_262824_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chat_highlight_n_sound", (String)"sound1")));
    public static final RegistryObject<SoundEvent> SOUND_2 = SOUNDS.register("sound2", () -> SoundEvent.m_262824_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chat_highlight_n_sound", (String)"sound2")));
    public static final SoundEvent SOUND_NOTE_BLOCK = (SoundEvent)SoundEvents.f_12214_.get();

    public static void register(IEventBus eventBus) {
        SOUNDS.register(eventBus);
    }

    @SubscribeEvent
    public static void onChatReceived(ClientChatReceivedEvent event) {
        int highlightsCount;
        String processedPlayerName;
        String playerName;
        TranslatableContents translatable;
        String key;
        ComponentContents componentContents = event.getMessage().m_214077_();
        if (componentContents instanceof TranslatableContents && ((key = (translatable = (TranslatableContents)componentContents).m_237508_()).startsWith("death.") || key.equals("sleeping.player"))) {
            return;
        }
        String chat = event.getMessage().getString();
        List keywords = (List)ClientConfig.CLIENT.keywords.get();
        ChatFormatting color = (ChatFormatting)ClientConfig.CLIENT.highlightColor.get();
        boolean playSound = (Boolean)ClientConfig.CLIENT.soundOnHighlight.get();
        boolean caseSensitive = (Boolean)ClientConfig.CLIENT.caseSensitive.get();
        boolean highlightPlayerName = (Boolean)ClientConfig.CLIENT.highlightPlayerName.get();
        Minecraft mc = Minecraft.m_91087_();
        String string = playerName = mc.f_91074_ != null ? mc.f_91074_.m_7755_().getString() : "";
        if (chat.startsWith("<" + playerName + ">")) {
            return;
        }
        MutableComponent highlightedMessage = Component.m_237119_();
        int lastIndex = 0;
        int maxHighlights = 3;
        String processedChat = caseSensitive ? chat : chat.toLowerCase();
        String string2 = processedPlayerName = caseSensitive ? playerName : playerName.toLowerCase();
        for (highlightsCount = 0; highlightsCount < 3; ++highlightsCount) {
            int playerIdx;
            int nextHighlightIndex = -1;
            int detectedLength = 0;
            for (String keyword : keywords) {
                String processedKeyword = caseSensitive ? keyword : keyword.toLowerCase();
                int idx = processedChat.indexOf(processedKeyword, lastIndex);
                if (idx < 0 || nextHighlightIndex != -1 && idx >= nextHighlightIndex) continue;
                if (highlightPlayerName && !playerName.isEmpty()) {
                    String processedPlayerNameCheck;
                    String string3 = processedPlayerNameCheck = caseSensitive ? playerName : playerName.toLowerCase();
                    if (processedPlayerNameCheck.startsWith(processedKeyword) && processedChat.startsWith(processedPlayerNameCheck, idx)) {
                        nextHighlightIndex = idx;
                        detectedLength = playerName.length();
                        break;
                    }
                }
                nextHighlightIndex = idx;
                detectedLength = keyword.length();
            }
            if (highlightPlayerName && !playerName.isEmpty() && (playerIdx = processedChat.indexOf(processedPlayerName, lastIndex)) >= 0 && (nextHighlightIndex == -1 || playerIdx < nextHighlightIndex)) {
                nextHighlightIndex = playerIdx;
                detectedLength = playerName.length();
            }
            if (nextHighlightIndex == -1) break;
            highlightedMessage.m_7220_((Component)Component.m_237113_((String)chat.substring(lastIndex, nextHighlightIndex)));
            highlightedMessage.m_7220_((Component)Component.m_237113_((String)chat.substring(nextHighlightIndex, nextHighlightIndex + detectedLength)).m_130940_(color));
            lastIndex = nextHighlightIndex + detectedLength;
        }
        if (lastIndex < chat.length()) {
            highlightedMessage.m_7220_((Component)Component.m_237113_((String)chat.substring(lastIndex)));
        }
        if (highlightsCount > 0) {
            event.setMessage((Component)highlightedMessage);
            if (playSound) {
                int soundId = (Integer)ClientConfig.CLIENT.soundSelection.get();
                SoundEvent soundToPlay = switch (soundId) {
                    case 1 -> (SoundEvent)SOUND_1.get();
                    case 2 -> (SoundEvent)SOUND_2.get();
                    default -> SOUND_NOTE_BLOCK;
                };
                mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundToPlay, (float)1.0f, (float)0.4f));
            }
        }
    }
}

