/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.chathighlightnsound;

import io.github.catomon.chathighlightnsound.ClientConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"screen.chat_highlight_n_sound.config");
    private EditBox keywordsInput;
    private Button colorButton;
    private Checkbox soundCheckbox;
    private Button soundSelectButton;
    private int currentColorIndex = 0;
    private int currentSoundId = 3;
    private static final ChatFormatting[] COLORS = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.YELLOW, ChatFormatting.AQUA, ChatFormatting.GREEN, ChatFormatting.RED, ChatFormatting.BLUE, ChatFormatting.LIGHT_PURPLE};

    public ConfigScreen() {
        super(TITLE);
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        this.keywordsInput = new EditBox(this.f_96547_, centerX - 150, 50, 300, 20, (Component)Component.m_237113_((String)"Keywords"));
        List currentKeywords = (List)ClientConfig.CLIENT.keywords.get();
        this.keywordsInput.m_94144_(String.join((CharSequence)",", currentKeywords));
        this.m_142416_((GuiEventListener)this.keywordsInput);
        ChatFormatting currentColor = (ChatFormatting)ClientConfig.CLIENT.highlightColor.get();
        for (int i = 0; i < COLORS.length; ++i) {
            if (COLORS[i] != currentColor) continue;
            this.currentColorIndex = i;
            break;
        }
        this.colorButton = Button.m_253074_((Component)Component.m_237113_((String)("Highlight Color: " + currentColor.m_126666_())), button -> {
            this.currentColorIndex = (this.currentColorIndex + 1) % COLORS.length;
            ChatFormatting newColor = COLORS[this.currentColorIndex];
            button.m_93666_((Component)Component.m_237113_((String)("Highlight Color: " + newColor.m_126666_())));
        }).m_252987_(centerX - 150, 90, 300, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.colorButton);
        this.soundCheckbox = new Checkbox(centerX - 150, 130, 300, 20, (Component)Component.m_237113_((String)"Play Sound on Highlight"), ((Boolean)ClientConfig.CLIENT.soundOnHighlight.get()).booleanValue());
        this.m_142416_((GuiEventListener)this.soundCheckbox);
        this.currentSoundId = (Integer)ClientConfig.CLIENT.soundSelection.get();
        this.soundSelectButton = Button.m_253074_((Component)Component.m_237113_((String)("Sound Selection: " + this.currentSoundId)), button -> {
            this.currentSoundId = this.currentSoundId % 3 + 1;
            button.m_93666_((Component)Component.m_237113_((String)("Sound Selection: " + this.currentSoundId)));
        }).m_252987_(centerX - 150, 170, 300, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.soundSelectButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            this.saveConfig();
            this.m_7379_();
        }).m_252987_(centerX - 50, this.f_96544_ - 40, 100, 20).m_253136_());
    }

    private void saveConfig() {
        String text = this.keywordsInput.m_94155_();
        List keywords = Arrays.stream(text.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        ClientConfig.CLIENT.keywords.set(keywords);
        ClientConfig.CLIENT.highlightColor.set((Object)COLORS[this.currentColorIndex]);
        ClientConfig.CLIENT.soundOnHighlight.set((Object)this.soundCheckbox.m_93840_());
        ClientConfig.CLIENT.soundSelection.set((Object)this.currentSoundId);
        ClientConfig.CLIENT_SPEC.save();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

