/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.chathighlightnsound;

import com.mojang.authlib.GameProfile;
import io.github.catomon.chathighlightnsound.ClientConfig;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModClient.class);
    public static final class_2960 SOUND1_ID = class_2960.method_60655((String)"chat_highlight_n_sound", (String)"sound1");
    public static final class_2960 SOUND2_ID = class_2960.method_60655((String)"chat_highlight_n_sound", (String)"sound2");
    public static final class_3414 SOUND_1 = class_3414.method_47908((class_2960)SOUND1_ID);
    public static final class_3414 SOUND_2 = class_3414.method_47908((class_2960)SOUND2_ID);

    public void onInitializeClient() {
        ClientConfig.load();
        LOGGER.info("Initializing Chat Highlight & Sound mod client...");
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)SOUND1_ID, (Object)SOUND_1);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)SOUND2_ID, (Object)SOUND_2);
        ClientReceiveMessageEvents.CHAT.register((message, signedMessage, sender, params, receptionTimestamp) -> {
            LOGGER.info("Received chat message: '{}', sender: {}", (Object)message.getString(), (Object)(sender != null ? sender.name() : "null"));
            this.onChatReceived(message, sender);
        });
        LOGGER.info("Chat message listener registered.");
    }

    private void onChatReceived(class_2561 message, GameProfile sender) {
        int highlightsCount;
        String processedPlayerName;
        String chat = message.getString();
        List<String> keywords = ClientConfig.getKeywords();
        class_124 color = ClientConfig.getHighlightColor();
        boolean playSound = ClientConfig.isSoundOnHighlight();
        boolean caseSensitive = ClientConfig.isCaseSensitive();
        boolean highlightPlayerName = ClientConfig.isHighlightPlayerName();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            LOGGER.warn("Minecraft player instance is null, skipping chat processing.");
            return;
        }
        String playerName = mc.field_1724.method_5477().getString();
        if (sender != null && sender.name().equals(playerName)) {
            LOGGER.info("Skipping chat message from local player: {}", (Object)playerName);
            return;
        }
        class_5250 highlightedMessage = class_2561.method_43473();
        int lastIndex = 0;
        int maxHighlights = 3;
        String processedChat = caseSensitive ? chat : chat.toLowerCase();
        String string = processedPlayerName = caseSensitive ? playerName : playerName.toLowerCase();
        for (highlightsCount = 0; highlightsCount < 3; ++highlightsCount) {
            int playerIdx;
            int nextHighlightIndex = -1;
            int detectedLength = 0;
            for (String keyword : keywords) {
                String processedKeyword = caseSensitive ? keyword : keyword.toLowerCase();
                int idx = processedChat.indexOf(processedKeyword, lastIndex);
                if (idx < 0 || nextHighlightIndex != -1 && idx >= nextHighlightIndex) continue;
                if (highlightPlayerName && !playerName.isEmpty()) {
                    String processedPlayerNameCheck;
                    String string2 = processedPlayerNameCheck = caseSensitive ? playerName : playerName.toLowerCase();
                    if (processedPlayerNameCheck.startsWith(processedKeyword) && processedChat.startsWith(processedPlayerNameCheck, idx)) {
                        nextHighlightIndex = idx;
                        detectedLength = playerName.length();
                        break;
                    }
                }
                nextHighlightIndex = idx;
                detectedLength = keyword.length();
            }
            if (highlightPlayerName && !playerName.isEmpty() && (playerIdx = processedChat.indexOf(processedPlayerName, lastIndex)) >= 0 && (nextHighlightIndex == -1 || playerIdx < nextHighlightIndex)) {
                nextHighlightIndex = playerIdx;
                detectedLength = playerName.length();
            }
            if (nextHighlightIndex == -1) break;
            highlightedMessage.method_10852((class_2561)class_2561.method_43470((String)chat.substring(lastIndex, nextHighlightIndex)));
            highlightedMessage.method_10852((class_2561)class_2561.method_43470((String)chat.substring(nextHighlightIndex, nextHighlightIndex + detectedLength)).method_27692(color));
            lastIndex = nextHighlightIndex + detectedLength;
        }
        if (lastIndex < chat.length()) {
            highlightedMessage.method_10852((class_2561)class_2561.method_43470((String)chat.substring(lastIndex)));
        }
        if (highlightsCount > 0) {
            LOGGER.info("Highlighting {} occurrences in message: '{}'", (Object)highlightsCount, (Object)chat);
            mc.field_1705.method_1743().method_1812((class_2561)highlightedMessage);
            if (playSound) {
                int soundId = ClientConfig.getSoundSelection();
                class_3414 soundToPlay = switch (soundId) {
                    case 1 -> SOUND_1;
                    case 2 -> SOUND_2;
                    default -> (class_3414)class_3417.field_15114.comp_349();
                };
                LOGGER.info("Playing sound id {}: {}", (Object)soundId, (Object)soundToPlay.comp_3319());
                mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundToPlay, (float)1.0f, (float)0.4f));
            }
        } else {
            LOGGER.info("No highlights found in message: '{}'", (Object)chat);
        }
    }
}

