/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.progressivebosses.setup.PBLoot;
import insane96mcp.progressivebosses.utils.LvlHelper;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class RandomChanceWithLvlCondition
implements LootItemCondition {
    final float chance;
    final int lvlModifier;

    RandomChanceWithLvlCondition(float chance, int lvlModifier) {
        this.chance = chance;
        this.lvlModifier = lvlModifier;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)PBLoot.RANDOM_CHANCE_WITH_LVL.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)entity;
        if (!mob.getPersistentData().m_128441_("progressivebosses:difficulty")) {
            return false;
        }
        float lvl = LvlHelper.getLvl((LivingEntity)mob);
        return lootContext.m_230907_().m_188501_() < this.chance * (lvl + (float)this.lvlModifier);
    }

    public static LootItemCondition.Builder randomChargeWithLvl(float chance, int lvlModifier) {
        return () -> new RandomChanceWithLvlCondition(chance, lvlModifier);
    }

    public static LootItemCondition.Builder randomChanceWithLvl(float chance) {
        return () -> new RandomChanceWithLvlCondition(chance, 0);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<RandomChanceWithLvlCondition> {
        public void serialize(JsonObject jsonObject, RandomChanceWithLvlCondition randomChanceWithLvlCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("chance", (Number)Float.valueOf(randomChanceWithLvlCondition.chance));
            jsonObject.addProperty("lvl_modifier", (Number)randomChanceWithLvlCondition.lvlModifier);
        }

        public RandomChanceWithLvlCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new RandomChanceWithLvlCondition(GsonHelper.m_13915_((JsonObject)jsonObject, (String)"chance"), GsonHelper.m_13824_((JsonObject)jsonObject, (String)"lvl_modifier", (int)0));
        }
    }
}

