/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.entity.AreaEffectCloud3DEntity;
import insane96mcp.progressivebosses.mixin.ProjectileInvoker;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class AcidballComponent
implements DragonComponent {
    public DragonValue acidAmplifier;
    @Nullable
    public DragonValue speedMultiplier;
    @Nullable
    public DragonValue impactRange;
    public DragonValue impactDamage;
    public boolean is3DCloud;
    static ResourceKey<DamageType> DRAGON_FIREBALL_DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("progressivebosses", "dragon_fireball"));

    public boolean onAcidBallImpact(DragonFireball fireball, EnderDragon dragon, HitResult result) {
        this.onImpactExplosion(fireball, dragon, result);
        return this.onImpact3DCloud(fireball, dragon, result);
    }

    private void onImpactExplosion(DragonFireball fireball, EnderDragon dragon, HitResult result) {
        if (this.impactDamage == null || this.impactRange == null) {
            return;
        }
        float impactRange = this.impactRange.getValue(dragon);
        float sqrImpactRange = impactRange * impactRange;
        AABB axisAlignedBB = new AABB(result.m_82450_(), result.m_82450_()).m_82400_((double)impactRange);
        List livingEntities = fireball.m_9236_().m_45976_(LivingEntity.class, axisAlignedBB);
        for (LivingEntity livingEntity : livingEntities) {
            if (!(livingEntity.m_20238_(fireball.m_20182_()) < (double)sqrImpactRange)) continue;
            livingEntity.m_6469_(livingEntity.m_269291_().m_268998_(DRAGON_FIREBALL_DAMAGE_TYPE, (Entity)fireball, (Entity)dragon), this.impactDamage.getValue(dragon));
        }
    }

    private boolean onImpact3DCloud(DragonFireball fireball, EnderDragon dragon, HitResult result) {
        if (!this.is3DCloud) {
            return false;
        }
        HitResult.Type hitResult$type = result.m_6662_();
        if (hitResult$type == HitResult.Type.ENTITY) {
            ((ProjectileInvoker)fireball).invokeOnHitEntity((EntityHitResult)result);
        } else if (hitResult$type == HitResult.Type.BLOCK) {
            ((ProjectileInvoker)fireball).invokeOnHitBlock((BlockHitResult)result);
        }
        if (!(result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_().m_7306_((Entity)dragon) || fireball.m_9236_().f_46443_)) {
            List list = fireball.m_9236_().m_45976_(LivingEntity.class, fireball.m_20191_().m_82377_(4.0, 2.0, 4.0));
            AreaEffectCloud3DEntity areaEffectCloud = new AreaEffectCloud3DEntity(fireball.m_9236_(), fireball.m_20185_(), fireball.m_20186_(), fireball.m_20189_());
            areaEffectCloud.m_19718_((LivingEntity)dragon);
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
            areaEffectCloud.m_19712_(3.0f);
            areaEffectCloud.m_19734_(300);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19738_((7.0f - areaEffectCloud.m_19743_()) / (float)areaEffectCloud.m_19748_());
            areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, this.acidAmplifier.getIntValue(dragon)));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = fireball.m_20280_((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaEffectCloud.m_6034_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                    break;
                }
            }
            fireball.m_9236_().m_46796_(2006, fireball.m_20183_(), fireball.m_20067_() ? -1 : 1);
            fireball.m_9236_().m_7967_((Entity)areaEffectCloud);
            fireball.m_146870_();
        }
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<AcidballComponent> {
        public AcidballComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            AcidballComponent component = new AcidballComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.acidAmplifier = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"acid_amplifier", (JsonDeserializationContext)context, DragonValue.class);
            component.speedMultiplier = (DragonValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"speed_multiplier", null, (JsonDeserializationContext)context, DragonValue.class);
            component.impactRange = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"impact_range", (JsonDeserializationContext)context, DragonValue.class);
            component.impactDamage = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"impact_damage", (JsonDeserializationContext)context, DragonValue.class);
            component.is3DCloud = GsonHelper.m_13855_((JsonObject)jObject, (String)"is_3d_cloud", (boolean)false);
            return component;
        }
    }
}

