/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import insane96mcp.progressivebosses.module.dragon.phase.DragonCrystalRespawnPhase;
import insane96mcp.progressivebosses.utils.Utils;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

@JsonAdapter(value=Serializer.class)
public class CrystalRespawnComponent
implements DragonComponent,
PhaseChanger {
    public static final String DRAGON_PHANTOM = "progressivebosses:dragon_phantom";
    public static final String PHANTOM_CRYSTAL = "progressivebosses:crystal";
    public static final String LAST_RESPAWN_TAG = "progressivebosses:last_respawn";
    public DragonValue minRespawnChance;
    public DragonValue minRespawnChanceAtHealth;
    public DragonValue maxRespawnChance;
    public DragonValue maxRespawnChanceAtHealth;
    public DragonValue respawned;
    @Nullable
    public DragonValue phantomCount;
    public DragonValue phantomSize;
    @Nullable
    public DragonValue cagedChance;
    @Nullable
    public DragonValue corruptedChance;
    @Nullable
    public DragonValue cooldown;

    public static void onPhantomHurt(LivingHurtEvent event) {
        if (!event.getEntity().getPersistentData().m_128441_(DRAGON_PHANTOM) || !(event.getSource().m_7639_() instanceof EnderDragon)) {
            return;
        }
        event.setAmount(event.getAmount() * 0.1f);
    }

    public static void tickCrystalPhantom(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_ || event.getEntity().f_19797_ % 30 != 0 || !event.getEntity().getPersistentData().m_128441_(PHANTOM_CRYSTAL)) {
            return;
        }
        Entity crystal = ((ServerLevel)event.getEntity().m_9236_()).m_8791_(event.getEntity().getPersistentData().m_128342_(PHANTOM_CRYSTAL));
        if (crystal == null || crystal.m_213877_()) {
            if (!event.getEntity().getPersistentData().m_128441_("crystal_death")) {
                event.getEntity().getPersistentData().m_128356_("crystal_death", event.getEntity().m_9236_().m_46467_());
            } else if (event.getEntity().m_9236_().m_46467_() - event.getEntity().getPersistentData().m_128454_("crystal_death") > 600L) {
                event.getEntity().m_6074_();
            }
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public EnderDragonPhase<?> getPhase() {
        return DragonCrystalRespawnPhase.getPhaseType();
    }

    @Override
    public boolean shouldExecute(EnderDragon dragon) {
        if (DragonCrystalRespawnPhase.isInCooldown(dragon, dragon.m_9236_(), this)) {
            return false;
        }
        float healthRatio = dragon.m_21223_() / dragon.m_21233_();
        float chance = Utils.getChanceAtValue(healthRatio, this.minRespawnChanceAtHealth.getValue(dragon), this.maxRespawnChanceAtHealth.getValue(dragon), this.minRespawnChance.getValue(dragon), this.maxRespawnChance.getValue(dragon));
        return dragon.m_217043_().m_188501_() < chance;
    }

    @Override
    public void execute(EnderDragon dragon, boolean forceBegin) {
        dragon.m_31157_().m_31416_(DragonCrystalRespawnPhase.getPhaseType());
        if (forceBegin) {
            ((DragonCrystalRespawnPhase)dragon.m_31157_().m_31418_(DragonCrystalRespawnPhase.getPhaseType())).m_7083_();
        }
    }

    public static class Serializer
    implements JsonDeserializer<CrystalRespawnComponent> {
        public CrystalRespawnComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CrystalRespawnComponent component = new CrystalRespawnComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.minRespawnChance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"min_respawn_chance", (JsonDeserializationContext)context, DragonValue.class);
            component.minRespawnChanceAtHealth = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"min_respawn_chance_at_health", (JsonDeserializationContext)context, DragonValue.class);
            component.maxRespawnChance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"max_respawn_chance", (JsonDeserializationContext)context, DragonValue.class);
            component.maxRespawnChanceAtHealth = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"max_respawn_chance_at_health", (JsonDeserializationContext)context, DragonValue.class);
            component.respawned = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"respawned", (JsonDeserializationContext)context, DragonValue.class);
            component.phantomCount = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"phantom_count", (JsonDeserializationContext)context, DragonValue.class);
            component.phantomSize = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"phantom_size", (JsonDeserializationContext)context, DragonValue.class);
            component.cagedChance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"caged_chance", (JsonDeserializationContext)context, DragonValue.class);
            component.corruptedChance = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"corrupted_chance", (JsonDeserializationContext)context, DragonValue.class);
            component.cooldown = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"cooldown", (JsonDeserializationContext)context, DragonValue.class);
            return component;
        }
    }
}

