/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonMinion;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

@JsonAdapter(value=Serializer.class)
public class DragonDefinition {
    public byte level;
    public List<DragonComponent> components = new ArrayList<DragonComponent>();
    @Nullable
    public DragonMinion minion;

    DragonDefinition(byte level, List<DragonComponent> components) {
        this.level = level;
        this.components = components;
    }

    public <T extends DragonComponent> Optional<T> getComponent(Class<T> componentClass) {
        return this.components.stream().filter(component -> component.getClass() == componentClass).findFirst().map(componentClass::cast);
    }

    public void apply(EnderDragon dragon) {
        this.components.forEach(component -> component.apply(dragon));
    }

    public void tick(EnderDragon dragon) {
        this.components.forEach(component -> component.tick(dragon));
    }

    public void onEntityJoinLevel(EntityJoinLevelEvent event, EnderDragon dragon) {
        this.components.forEach(component -> component.onEntityJoinLevel(event, dragon));
    }

    public void onLivingHurt(LivingHurtEvent event, EnderDragon dragon) {
        this.components.forEach(component -> component.onLivingHurt(event, dragon));
    }

    public void onLivingDeath(LivingDeathEvent event, EnderDragon dragon) {
        this.components.forEach(component -> component.onLivingDeath(event, dragon));
    }

    public DragonDefinition(byte level, @Nullable DragonMinion minion) {
        this.level = level;
        this.minion = minion;
    }

    public static class Serializer
    implements JsonDeserializer<DragonDefinition> {
        public DragonDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            byte level = GsonHelper.m_144790_((JsonObject)json.getAsJsonObject(), (String)"level");
            List<DragonComponent> components = DragonComponent.deserializeList(json.getAsJsonObject(), "components", context);
            return new DragonDefinition(level, components);
        }
    }
}

