/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.module.dragon.corruptedendcrystal.CorruptedEndCrystal;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class HealthComponent
implements DragonComponent {
    @Nullable
    public Integer health;
    @Nullable
    public DragonValue passiveRegeneration;
    @Nullable
    public DragonValue crystalRegeneration;
    @Nullable
    public DragonValue corruptedCrystalRegeneration;
    @Nullable
    public DragonValue regenWhenHitRatio;
    @Nullable
    public DragonValue regenWhenHitDuration;

    public float reducedRegen(float regen, EnderDragon dragon) {
        return this.regenWhenHitDuration != null && this.regenWhenHitRatio != null && dragon.m_21213_() < dragon.f_19797_ && (float)(dragon.f_19797_ - dragon.m_21213_()) <= this.regenWhenHitDuration.getValue(dragon) ? regen * this.regenWhenHitRatio.getValue(dragon) : regen;
    }

    @Override
    public void tick(EnderDragon dragon) {
        if (!dragon.m_6084_() || dragon.m_31157_().m_31415_().m_7309_() == EnderDragonPhase.f_31386_ || dragon.f_19797_ % 10 != 5) {
            return;
        }
        if (this.passiveRegeneration == null) {
            return;
        }
        float passiveRegen = this.passiveRegeneration.getValue(dragon);
        if (passiveRegen == 0.0f) {
            return;
        }
        passiveRegen /= 2.0f;
        passiveRegen = this.reducedRegen(passiveRegen, dragon);
        dragon.m_5634_(passiveRegen);
    }

    @Override
    public void apply(EnderDragon dragon) {
        if (this.health != null) {
            dragon.m_21051_(Attributes.f_22276_).m_22100_((double)this.health.intValue());
            dragon.m_21153_((float)this.health.intValue());
        }
    }

    public float getHealingFromCrystal(EnderDragon dragon, EndCrystal crystal, float original) {
        if (this.crystalRegeneration == null && this.corruptedCrystalRegeneration == null) {
            return original;
        }
        boolean isCorrupted = crystal instanceof CorruptedEndCrystal;
        if (this.corruptedCrystalRegeneration == null && isCorrupted) {
            return original;
        }
        if (this.crystalRegeneration == null && !isCorrupted) {
            return original;
        }
        float heal = isCorrupted ? this.corruptedCrystalRegeneration.getValue(dragon) : this.crystalRegeneration.getValue(dragon);
        heal /= 2.0f;
        heal = this.reducedRegen(heal, dragon);
        return heal;
    }

    public static class Serializer
    implements JsonDeserializer<HealthComponent> {
        public HealthComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HealthComponent sittingComponent = new HealthComponent();
            JsonObject jObject = json.getAsJsonObject();
            sittingComponent.health = GsonHelper.m_13927_((JsonObject)jObject, (String)"health");
            sittingComponent.passiveRegeneration = (DragonValue)context.deserialize(jObject.get("passive_regeneration"), DragonValue.class);
            sittingComponent.crystalRegeneration = (DragonValue)context.deserialize(jObject.get("crystal_regeneration"), DragonValue.class);
            sittingComponent.corruptedCrystalRegeneration = (DragonValue)context.deserialize(jObject.get("corrupted_crystal_regeneration"), DragonValue.class);
            sittingComponent.regenWhenHitRatio = (DragonValue)context.deserialize(jObject.get("regen_when_hit_ratio"), DragonValue.class);
            sittingComponent.regenWhenHitDuration = (DragonValue)context.deserialize(jObject.get("regen_when_hit_duration"), DragonValue.class);
            return sittingComponent;
        }
    }
}

