/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.ai.ILNearestAttackableTargetGoal;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.module.dragon.ai.DragonMinionAttackGoal;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

@JsonAdapter(value=Serializer.class)
public class MinionComponent
implements DragonComponent {
    public DragonValue health;
    public DragonValue spawned;
    public DragonValue averageCooldown;
    public DragonValue deltaCooldown;
    public static final String DRAGON_MINION = "progressivebosses:dragon_minion";
    public static final String DRAGON_MINION_COOLDOWN = "progressivebosses:dragon_minion_cooldown";

    public static void onMinionHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)livingEntity;
        CompoundTag compoundNBT = shulker.getPersistentData();
        if (!compoundNBT.m_128441_(DRAGON_MINION)) {
            return;
        }
        if (event.getSource().m_7639_() instanceof EnderDragon) {
            event.setCanceled(true);
        }
    }

    public void summonMinion(EnderDragon dragon, Level world, Vec3 pos) {
        Shulker shulker = (Shulker)EntityType.f_20521_.m_20615_(world);
        if (shulker == null) {
            LogHelper.warn("Failed to summon Dragon Minion", new Object[0]);
            return;
        }
        CompoundTag minionTags = shulker.getPersistentData();
        minionTags.m_128379_(DRAGON_MINION, true);
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        shulker.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        shulker.m_6593_((Component)Component.m_237115_((String)DRAGON_MINION));
        shulker.f_21355_ = BuiltInLootTables.f_78712_;
        shulker.m_21530_();
        shulker.m_28464_(Optional.of(DyeColor.PURPLE));
        shulker.m_21051_(Attributes.f_22276_).m_22100_((double)this.health.getValue(dragon));
        MCUtils.applyModifier((LivingEntity)shulker, (Attribute)Attributes.f_22277_, (UUID)Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, (String)"progressivebosses:follow_range_bonus", (double)96.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        world.m_7967_((Entity)shulker);
        MinionComponent.setMinionAI(shulker);
    }

    public static void setMinionAI(Shulker shulker) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        shulker.f_21345_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof Shulker.ShulkerAttackGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.f_21345_).m_25363_(arg_0));
        shulker.f_21345_.m_25352_(4, (Goal)new DragonMinionAttackGoal(shulker, 200));
        toRemove.clear();
        shulker.f_21346_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof NearestAttackableTargetGoal) {
                toRemove.add(goal.m_26015_());
            }
            if (goal.m_26015_() instanceof HurtByTargetGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.f_21346_).m_25363_(arg_0));
        shulker.f_21346_.m_25352_(2, (Goal)new ILNearestAttackableTargetGoal((Mob)shulker, Player.class, false).setIgnoreLineOfSight());
        shulker.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)shulker, new Class[]{Shulker.class, EnderDragon.class}));
    }

    @Override
    public void tick(EnderDragon dragon) {
        Level level = dragon.m_9236_();
        CompoundTag dragonTags = dragon.getPersistentData();
        int cooldown = dragonTags.m_128451_(DRAGON_MINION_COOLDOWN);
        if (--cooldown > 0) {
            dragonTags.m_128405_(DRAGON_MINION_COOLDOWN, cooldown);
            return;
        }
        BlockPos centerPodium = dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(96.0);
        List players = level.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        cooldown = (int)level.f_46441_.m_216328_((double)this.averageCooldown.getIntValue(dragon), (double)this.deltaCooldown.getIntValue(dragon));
        dragonTags.m_128405_(DRAGON_MINION_COOLDOWN, cooldown);
        int spawned = this.spawned.getIntValue(dragon);
        for (int i = 0; i < spawned; ++i) {
            float angle = level.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
            float x = (float)(Math.cos(angle) * (double)Mth.m_216267_((RandomSource)dragon.m_217043_(), (float)1.0f, (float)4.0f));
            float z = (float)(Math.sin(angle) * (double)Mth.m_216267_((RandomSource)dragon.m_217043_(), (float)1.0f, (float)4.0f));
            float y = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, BlockPos.m_274561_((double)x, (double)255.0, (double)z)).m_123342_();
            this.summonMinion(dragon, level, new Vec3((double)x, (double)y, (double)z));
        }
    }

    @Override
    public void apply(EnderDragon dragon) {
        int cooldown = (int)dragon.m_217043_().m_216328_((double)this.averageCooldown.getIntValue(dragon), (double)this.deltaCooldown.getIntValue(dragon));
        dragon.getPersistentData().m_128405_(DRAGON_MINION_COOLDOWN, cooldown);
    }

    public static class Serializer
    implements JsonDeserializer<MinionComponent> {
        public MinionComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            MinionComponent component = new MinionComponent();
            JsonObject jObject = json.getAsJsonObject();
            component.health = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"health", (JsonDeserializationContext)context, DragonValue.class);
            component.spawned = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"spawned", (JsonDeserializationContext)context, DragonValue.class);
            component.averageCooldown = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"average_cooldown", (JsonDeserializationContext)context, DragonValue.class);
            component.deltaCooldown = (DragonValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"delta_cooldown", (JsonDeserializationContext)context, DragonValue.class);
            return component;
        }
    }
}

