/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.progressivebosses.module.dragon.corruptedendcrystal.CorruptedEndCrystal;
import insane96mcp.progressivebosses.module.dragon.data.DragonComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonValue;
import insane96mcp.progressivebosses.module.dragon.phase.DragonBlastAttackPhase;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class VulnerabilitiesComponent
implements DragonComponent {
    @Nullable
    public DragonValue meleeDamageMultiplierWhenSitting;
    @Nullable
    public DragonValue meleeDamageMultiplierWhenFlying;
    @Nullable
    public DragonValue explosionDamageMultiplier;
    @Nullable
    public DragonValue rangedDamageMultiplier;
    @Nullable
    public DragonValue respawningCrystalDamageMultiplier;
    public float attachedCrystalDamage;
    public AttachedCrystalDamageType attachedCrystalDamageType;
    public float attachedCorruptedCrystalDamage;
    public AttachedCrystalDamageType attachedCorruptedCrystalDamageType;
    private static final List<EnderDragonPhase<? extends DragonPhaseInstance>> CENTER_PODIUM_PHASES = Arrays.asList(EnderDragonPhase.f_31383_, EnderDragonPhase.f_31384_, EnderDragonPhase.f_31382_, DragonBlastAttackPhase.getPhaseType());

    public float getAttachedCrystalDamage(EndCrystal endCrystal, EnderDragon dragon) {
        AttachedCrystalDamageType type;
        boolean isCorrupted = endCrystal instanceof CorruptedEndCrystal;
        float damage = isCorrupted ? this.attachedCorruptedCrystalDamage : this.attachedCrystalDamage;
        AttachedCrystalDamageType attachedCrystalDamageType = type = isCorrupted ? this.attachedCorruptedCrystalDamageType : this.attachedCrystalDamageType;
        return damage >= 1.0f ? damage : (type == AttachedCrystalDamageType.CURRENT_HEALTH ? dragon.m_21223_() : dragon.m_21233_()) * damage;
    }

    @Override
    public void onLivingHurt(LivingHurtEvent event, EnderDragon dragon) {
        this.meleeDamageMultiplier(event, dragon);
        this.rangedDamageMultiplier(event, dragon);
        this.explosionDamageMultiplier(event, dragon);
    }

    private void meleeDamageMultiplier(LivingHurtEvent event, EnderDragon dragon) {
        DragonValue multiplier;
        if (!(event.getSource().m_7640_() instanceof LivingEntity)) {
            return;
        }
        DragonValue dragonValue = multiplier = CENTER_PODIUM_PHASES.contains(dragon.m_31157_().m_31415_().m_7309_()) ? this.meleeDamageMultiplierWhenSitting : this.meleeDamageMultiplierWhenFlying;
        if (multiplier != null) {
            event.setAmount(event.getAmount() * multiplier.getValue(dragon));
        }
    }

    private void rangedDamageMultiplier(LivingHurtEvent event, EnderDragon dragon) {
        if (!(event.getSource().m_7640_() instanceof Projectile) || this.rangedDamageMultiplier == null) {
            return;
        }
        event.setAmount(event.getAmount() * this.rangedDamageMultiplier.getValue(dragon));
    }

    private void explosionDamageMultiplier(LivingHurtEvent event, EnderDragon dragon) {
        if (!event.getSource().m_269533_(DamageTypeTags.f_268415_) || event.getSource().m_276093_(DamageTypes.f_268428_) || this.explosionDamageMultiplier == null) {
            return;
        }
        event.setAmount(event.getAmount() * this.explosionDamageMultiplier.getValue(dragon));
    }

    public static enum AttachedCrystalDamageType {
        CURRENT_HEALTH,
        MAX_HEALTH;

    }

    public static class Serializer
    implements JsonDeserializer<VulnerabilitiesComponent> {
        public VulnerabilitiesComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            VulnerabilitiesComponent sittingComponent = new VulnerabilitiesComponent();
            JsonObject jObject = json.getAsJsonObject();
            sittingComponent.meleeDamageMultiplierWhenSitting = (DragonValue)context.deserialize(jObject.get("melee_damage_multiplier_when_sitting"), DragonValue.class);
            sittingComponent.meleeDamageMultiplierWhenFlying = (DragonValue)context.deserialize(jObject.get("melee_damage_multiplier_when_flying"), DragonValue.class);
            sittingComponent.rangedDamageMultiplier = (DragonValue)context.deserialize(jObject.get("ranged_damage_multiplier"), DragonValue.class);
            sittingComponent.explosionDamageMultiplier = (DragonValue)context.deserialize(jObject.get("explosion_damage_multiplier"), DragonValue.class);
            sittingComponent.respawningCrystalDamageMultiplier = (DragonValue)context.deserialize(jObject.get("respawning_crystal_damage_multiplier"), DragonValue.class);
            sittingComponent.attachedCrystalDamage = GsonHelper.m_13915_((JsonObject)jObject, (String)"attached_crystal_damage");
            sittingComponent.attachedCrystalDamageType = (AttachedCrystalDamageType)((Object)context.deserialize(jObject.get("attached_crystal_damage_type"), AttachedCrystalDamageType.class));
            sittingComponent.attachedCorruptedCrystalDamage = GsonHelper.m_13915_((JsonObject)jObject, (String)"attached_corrupted_crystal_damage");
            sittingComponent.attachedCorruptedCrystalDamageType = (AttachedCrystalDamageType)((Object)context.deserialize(jObject.get("attached_corrupted_crystal_damage_type"), AttachedCrystalDamageType.class));
            return sittingComponent;
        }
    }
}

