/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.phase;

import com.google.common.collect.ImmutableList;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.corruptedendcrystal.CorruptedEndCrystal;
import insane96mcp.progressivebosses.module.dragon.data.CrystalRespawnComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonDefinition;
import insane96mcp.progressivebosses.module.dragon.data.VulnerabilitiesComponent;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

public class DragonCrystalRespawnPhase
extends AbstractDragonPhaseInstance {
    private static EnderDragonPhase<DragonCrystalRespawnPhase> CRYSTAL_RESPAWN;
    public Vec3 targetLocation;
    private final ArrayList<SpikeFeature.EndSpike> spikesToRespawn = new ArrayList();

    public DragonCrystalRespawnPhase(EnderDragon dragonIn) {
        super(dragonIn);
    }

    public void m_6989_() {
        double distanceToTarget;
        DragonDefinition definition = DragonFeature.getDragonDefinition(this.f_31176_).orElse(null);
        if (definition == null) {
            this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31381_);
            return;
        }
        CrystalRespawnComponent component = definition.getComponent(CrystalRespawnComponent.class).orElse(null);
        if (component == null) {
            this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31381_);
            return;
        }
        if (this.targetLocation == null) {
            if (this.spikesToRespawn.isEmpty()) {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31380_);
                this.f_31176_.f_31076_ = 0.0f;
                return;
            }
            this.targetLocation = new Vec3((double)this.spikesToRespawn.get(0).m_66886_() + 0.5, (double)(this.spikesToRespawn.get(0).m_66899_() + 1), (double)this.spikesToRespawn.get(0).m_66893_() + 0.5);
        }
        if ((distanceToTarget = this.targetLocation.m_82531_(this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_())) < 9.0) {
            SpikeFeature.EndSpike spike = this.spikesToRespawn.get(0);
            boolean shouldBeGuarded = component.cagedChance != null && this.f_31176_.m_217043_().m_188501_() < component.cagedChance.getValue(this.f_31176_);
            boolean wasGuarded = spike.f_66877_;
            spike.f_66877_ = shouldBeGuarded;
            this.f_31176_.m_9236_().m_254849_(null, (double)((float)spike.m_66886_() + 0.5f), (double)spike.m_66899_(), (double)((float)spike.m_66893_() + 0.5f), 5.0f, Level.ExplosionInteraction.BLOCK);
            RandomSource yungRandom = RandomSource.m_216335_((long)-1157087832721040245L);
            Feature.f_65732_.m_225028_((FeatureConfiguration)new SpikeConfiguration(true, (List)ImmutableList.of((Object)spike), null), (WorldGenLevel)((ServerLevel)this.f_31176_.m_9236_()), ((ServerLevel)this.f_31176_.m_9236_()).m_7726_().m_8481_(), shouldBeGuarded ? yungRandom : this.f_31176_.m_217043_(), new BlockPos(spike.m_66886_(), 45, spike.m_66893_()));
            spike.f_66877_ = wasGuarded;
            EndCrystal crystal = this.f_31176_.m_9236_().m_45976_(EndCrystal.class, spike.m_66905_()).stream().filter(c -> !(c instanceof CorruptedEndCrystal)).findFirst().orElse(null);
            if (crystal != null) {
                if (component.corruptedChance != null && this.f_31176_.m_217043_().m_188501_() < component.corruptedChance.getValue(this.f_31176_)) {
                    CorruptedEndCrystal corruptedEndCrystal = (CorruptedEndCrystal)((EntityType)PBEntities.CORRUPTED_END_CRYSTAL.get()).m_20615_(this.f_31176_.m_9236_());
                    corruptedEndCrystal.m_6034_(crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_());
                    corruptedEndCrystal.m_31056_(true);
                    crystal.m_146870_();
                    this.f_31176_.m_9236_().m_7967_((Entity)corruptedEndCrystal);
                }
                int phantomCount = component.phantomCount != null ? component.phantomCount.getIntValue(this.f_31176_) : 0;
                for (int i = 0; i < phantomCount; ++i) {
                    this.summonPhantom(spike, crystal, component);
                }
            }
            this.spikesToRespawn.remove(0);
            if (this.spikesToRespawn.isEmpty()) {
                LogHelper.info("No more crystals to respawn left", new Object[0]);
                this.f_31176_.getPersistentData().m_128356_("progressivebosses:last_respawn", this.f_31176_.m_9236_().m_46467_());
            }
            this.targetLocation = null;
        }
    }

    private void summonPhantom(SpikeFeature.EndSpike spike, EndCrystal crystal, CrystalRespawnComponent component) {
        Phantom phantom = (Phantom)EntityType.f_20509_.m_20615_(this.f_31176_.m_9236_());
        if (phantom == null) {
            return;
        }
        float angle = phantom.m_217043_().m_188501_() * (float)Math.PI * 2.0f;
        float x = (float)((double)spike.m_66886_() + Math.floor(Math.cos(angle) * 6.0)) + 0.5f;
        float z = (float)((double)spike.m_66893_() + Math.floor(Math.sin(angle) * 6.0)) + 0.5f;
        phantom.m_6034_((double)x, (double)(spike.m_66899_() + 10), (double)z);
        phantom.m_33108_(component.phantomSize.getIntValue(this.f_31176_));
        if (phantom.m_21051_(Attributes.f_22282_) != null) {
            phantom.m_21051_(Attributes.f_22282_).m_22100_(10.0);
        }
        phantom.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        phantom.m_21051_(Attributes.f_22276_).m_22100_(phantom.m_21172_(Attributes.f_22276_) * 0.5);
        phantom.m_21153_((float)phantom.m_21133_(Attributes.f_22276_));
        phantom.getPersistentData().m_128362_("progressivebosses:crystal", crystal.m_20148_());
        phantom.f_21355_ = BuiltInLootTables.f_78712_;
        ArrayList<WrappedGoal> toRemoveList = new ArrayList<WrappedGoal>();
        for (WrappedGoal wrappedGoal : phantom.f_21346_.f_25345_) {
            if (!(wrappedGoal.m_26015_() instanceof PhantomAttackPlayerTargetGoal)) continue;
            toRemoveList.add(wrappedGoal);
            phantom.f_21346_.m_25352_(1, (Goal)new PhantomAttackPlayerTargetGoal(phantom));
        }
        for (WrappedGoal toRemove : toRemoveList) {
            phantom.f_21346_.m_25363_((Goal)toRemove);
        }
        phantom.getPersistentData().m_128379_("progressivebosses:dragon_phantom", true);
        this.f_31176_.m_9236_().m_7967_((Entity)phantom);
    }

    public void m_7083_() {
        this.targetLocation = null;
        this.spikesToRespawn.clear();
        if (this.f_31176_.m_9236_().f_46443_) {
            return;
        }
        DragonDefinition definition = DragonFeature.getDragonDefinition(this.f_31176_).orElse(null);
        if (definition == null) {
            return;
        }
        CrystalRespawnComponent component = definition.getComponent(CrystalRespawnComponent.class).orElse(null);
        if (component == null) {
            return;
        }
        double crystalsToRespawn = component.respawned.getIntValue(this.f_31176_);
        crystalsToRespawn = MathHelper.getAmountWithDecimalChance((RandomSource)this.f_31176_.m_217043_(), (double)crystalsToRespawn);
        if (crystalsToRespawn == 0.0) {
            return;
        }
        ArrayList spikes = new ArrayList(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)this.f_31176_.m_9236_())));
        Collections.shuffle(spikes);
        int spawned = 0;
        for (SpikeFeature.EndSpike spike : spikes) {
            if (!this.f_31176_.m_9236_().m_45976_(EndCrystal.class, spike.m_66905_()).isEmpty()) continue;
            this.addCrystalRespawn(spike);
            if (!((double)(++spawned) >= crystalsToRespawn)) continue;
            break;
        }
    }

    public float m_7072_() {
        return 2.0f;
    }

    @Nullable
    public Vec3 m_5535_() {
        return this.targetLocation;
    }

    public void addCrystalRespawn(SpikeFeature.EndSpike spike) {
        if (!this.spikesToRespawn.contains(spike)) {
            this.spikesToRespawn.add(spike);
        }
    }

    public float m_7584_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268415_) && !source.m_19385_().equals("fireworks")) {
            return amount;
        }
        return amount * DragonFeature.getDragonDefinition(this.f_31176_).flatMap(stats -> stats.getComponent(VulnerabilitiesComponent.class)).flatMap(component -> Optional.ofNullable(component.respawningCrystalDamageMultiplier)).map(respawningCrystalDamageMultiplier -> Float.valueOf(respawningCrystalDamageMultiplier.getValue(this.f_31176_))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static boolean isInCooldown(EnderDragon dragon, Level level, CrystalRespawnComponent component) {
        if (component.cooldown == null) {
            return true;
        }
        return level.m_46467_() - dragon.getPersistentData().m_128454_("progressivebosses:last_respawn") < (long)component.cooldown.getIntValue(dragon);
    }

    public EnderDragonPhase<DragonCrystalRespawnPhase> m_7309_() {
        return CRYSTAL_RESPAWN;
    }

    public static EnderDragonPhase<DragonCrystalRespawnPhase> getPhaseType() {
        return CRYSTAL_RESPAWN;
    }

    public static void init() {
        CRYSTAL_RESPAWN = EnderDragonPhase.m_31402_(DragonCrystalRespawnPhase.class, (String)"CrystalRespawn");
    }

    static class PhantomAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = PhantomAttackPlayerTargetGoal.m_186073_((int)20);
        private final Phantom phantom;

        PhantomAttackPlayerTargetGoal(Phantom phantom) {
            this.phantom = phantom;
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = PhantomAttackPlayerTargetGoal.m_186073_((int)30);
            List list = this.phantom.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)this.phantom, this.phantom.m_20191_().m_82377_(this.phantom.m_21133_(Attributes.f_22277_), this.phantom.m_21133_(Attributes.f_22277_) * 2.0, this.phantom.m_21133_(Attributes.f_22277_)));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!this.phantom.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    this.phantom.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.phantom.m_5448_();
            return livingentity != null && this.phantom.m_21040_(livingentity, TargetingConditions.f_26872_);
        }
    }
}

