/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.phase;

import com.mojang.logging.LogUtils;
import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.AcidballComponent;
import insane96mcp.progressivebosses.module.dragon.data.DragonDefinition;
import insane96mcp.progressivebosses.module.dragon.data.PhaseChanger;
import insane96mcp.progressivebosses.module.dragon.data.StrafePlayerComponent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PBDragonStrafePlayerPhase
extends AbstractDragonPhaseInstance {
    private static EnderDragonPhase<PBDragonStrafePlayerPhase> PHASE;
    public static final Logger LOGGER;
    public int fireballsToShoot = 0;
    public int fireballCharge;
    @Nullable
    public Path currentPath;
    @Nullable
    public Vec3 targetLocation;
    @Nullable
    public LivingEntity attackTarget;
    private boolean holdingPatternClockwise;

    public PBDragonStrafePlayerPhase(EnderDragon pDragon) {
        super(pDragon);
    }

    public void m_6989_() {
        double d12;
        DragonDefinition definition = DragonFeature.getDragonDefinition(this.f_31176_).orElse(null);
        if (definition == null) {
            return;
        }
        StrafePlayerComponent component = definition.getComponent(StrafePlayerComponent.class).orElse(null);
        if (component == null) {
            return;
        }
        if (this.attackTarget == null) {
            LOGGER.warn("Skipping player strafe phase because no player was found");
            if (!PhaseChanger.trySetNewPhase(this.f_31176_, definition, this.m_7309_())) {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            }
            return;
        }
        if (this.currentPath != null && this.currentPath.m_77392_()) {
            double x = this.attackTarget.m_20185_();
            double z = this.attackTarget.m_20189_();
            double dX = x - this.f_31176_.m_20185_();
            double dZ = z - this.f_31176_.m_20189_();
            double dSqrt = Math.sqrt(dX * dX + dZ * dZ);
            this.targetLocation = new Vec3(x, this.attackTarget.m_20186_() + 15.0, z);
        }
        double d = d12 = this.targetLocation == null ? 0.0 : this.targetLocation.m_82531_(this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_());
        if (d12 < 225.0 || d12 > 22500.0) {
            this.findNewTarget();
        }
        if (this.attackTarget.m_20280_((Entity)this.f_31176_) >= 9216.0 || !this.f_31176_.m_142582_((Entity)this.attackTarget)) {
            if (this.fireballCharge > 0) {
                --this.fireballCharge;
            }
            return;
        }
        ++this.fireballCharge;
        Vec3 targetDirection = new Vec3(this.attackTarget.m_20185_() - this.f_31176_.m_20185_(), 0.0, this.attackTarget.m_20189_() - this.f_31176_.m_20189_()).m_82541_();
        Vec3 dragonViewDirection = new Vec3((double)Mth.m_14031_((float)(this.f_31176_.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)(-Mth.m_14089_((float)(this.f_31176_.m_146908_() * ((float)Math.PI / 180))))).m_82541_();
        float dot = (float)dragonViewDirection.m_82526_(targetDirection);
        float angleToTarget = (float)(Math.acos(dot) * 57.2957763671875);
        angleToTarget += 0.5f;
        if (this.fireballCharge >= 5 && angleToTarget >= 0.0f && angleToTarget < 12.5f) {
            int fired = component.acidballPerShot.getIntValue(this.f_31176_);
            AcidballComponent acidballComponent = definition.getComponent(AcidballComponent.class).orElse(null);
            for (int i = 0; i < fired; ++i) {
                this.summonAcidball(acidballComponent);
            }
            this.fireballCharge = 5 - component.cooldownBetweenShots.getIntValue(this.f_31176_);
            if (--this.fireballsToShoot <= 0) {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            }
        }
    }

    private void summonAcidball(@Nullable AcidballComponent component) {
        Vec3 vec32 = this.f_31176_.m_20252_(1.0f);
        double headXOffset = this.f_31176_.f_31080_.m_20185_() - vec32.f_82479_;
        double headYOffset = this.f_31176_.f_31080_.m_20227_(0.5) + 0.5;
        double headZOffset = this.f_31176_.f_31080_.m_20189_() - vec32.f_82481_;
        double targetXOffset = this.attackTarget.m_20185_() + (double)Mth.m_216283_((RandomSource)this.f_31176_.m_217043_(), (float)-3.0f, (float)3.0f) - headXOffset;
        double targetYOffset = this.attackTarget.m_20186_() - headYOffset;
        double targetZOffset = this.attackTarget.m_20189_() + (double)Mth.m_216283_((RandomSource)this.f_31176_.m_217043_(), (float)-3.0f, (float)3.0f) - headZOffset;
        if (!this.f_31176_.m_20067_()) {
            this.f_31176_.m_9236_().m_5898_(null, 1017, this.f_31176_.m_20183_(), 0);
        }
        DragonFireball dragonfireball = new DragonFireball(this.f_31176_.m_9236_(), (LivingEntity)this.f_31176_, targetXOffset, targetYOffset, targetZOffset);
        if (component != null && component.speedMultiplier != null) {
            float speedMultiplier = component.speedMultiplier.getValue(this.f_31176_);
            dragonfireball.f_36813_ *= (double)speedMultiplier;
            dragonfireball.f_36814_ *= (double)speedMultiplier;
            dragonfireball.f_36815_ *= (double)speedMultiplier;
        }
        dragonfireball.m_7678_(headXOffset, headYOffset, headZOffset, 0.0f, 0.0f);
        this.f_31176_.m_9236_().m_7967_((Entity)dragonfireball);
    }

    public void findNewTarget() {
        if (this.currentPath == null || this.currentPath.m_77392_()) {
            int closestNode;
            int newNode = closestNode = this.f_31176_.m_31155_();
            if (this.f_31176_.m_217043_().m_188503_(8) == 0) {
                this.holdingPatternClockwise = !this.holdingPatternClockwise;
                newNode = closestNode + 6;
            }
            newNode = this.holdingPatternClockwise ? ++newNode : --newNode;
            if (this.f_31176_.m_31158_() != null && this.f_31176_.m_31158_().m_64098_() > 0) {
                if ((newNode %= 12) < 0) {
                    newNode += 12;
                }
            } else {
                newNode -= 12;
                newNode &= 7;
                newNode += 12;
            }
            Node andThen = this.attackTarget != null ? new Node(this.attackTarget.m_146903_(), this.attackTarget.m_146904_(), this.attackTarget.m_146907_()) : null;
            this.currentPath = this.f_31176_.m_31104_(closestNode, newNode, andThen);
            if (this.currentPath != null) {
                this.currentPath.m_77374_();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.m_77392_()) {
            double y;
            BlockPos nextNodePos = this.currentPath.m_77400_();
            this.currentPath.m_77374_();
            double x = nextNodePos.m_123341_();
            double z = nextNodePos.m_123343_();
            while ((y = (double)((float)nextNodePos.m_123342_() + this.f_31176_.m_217043_().m_188501_() * 20.0f)) < (double)nextNodePos.m_123342_()) {
            }
            this.targetLocation = new Vec3(x, y, z);
        }
    }

    public void m_7083_() {
        this.fireballCharge = 0;
        this.targetLocation = null;
        this.currentPath = null;
        this.attackTarget = null;
        DragonDefinition definition = DragonFeature.getDragonDefinition(this.f_31176_).orElse(null);
        if (definition == null) {
            return;
        }
        StrafePlayerComponent component = definition.getComponent(StrafePlayerComponent.class).orElse(null);
        if (component == null) {
            return;
        }
        this.fireballsToShoot = component.getAcidballShot(this.f_31176_, this.f_31176_.m_217043_());
        Player player = DragonFeature.getRandomPlayer(this.f_31176_, this.f_31176_.m_9236_(), 96);
        if (player == null) {
            return;
        }
        this.setTarget((LivingEntity)player);
    }

    public void setTarget(@NotNull LivingEntity pAttackTarget) {
        this.attackTarget = pAttackTarget;
        int closestNode = this.f_31176_.m_31155_();
        int closestTargetNode = this.f_31176_.m_31170_(this.attackTarget.m_20185_(), this.attackTarget.m_20186_(), this.attackTarget.m_20189_());
        int x = this.attackTarget.m_146903_();
        int z = this.attackTarget.m_146907_();
        double dX = (double)x - this.f_31176_.m_20185_();
        double dZ = (double)z - this.f_31176_.m_20189_();
        double dSqr = Math.sqrt(dX * dX + dZ * dZ);
        double offsetY = Math.min((double)0.4f + dSqr / 80.0 - 1.0, 10.5);
        int y = Mth.m_14107_((double)(this.attackTarget.m_20186_() + offsetY));
        Node node = new Node(x, y, z);
        this.currentPath = this.f_31176_.m_31104_(closestNode, closestTargetNode, node);
        if (this.currentPath != null) {
            this.currentPath.m_77374_();
            this.navigateToNextPathNode();
        }
    }

    @Nullable
    public Vec3 m_5535_() {
        return this.targetLocation;
    }

    public EnderDragonPhase<PBDragonStrafePlayerPhase> m_7309_() {
        return PHASE;
    }

    public static EnderDragonPhase<PBDragonStrafePlayerPhase> getPhaseType() {
        return PHASE;
    }

    public static void init() {
        PHASE = EnderDragonPhase.m_31402_(PBDragonStrafePlayerPhase.class, (String)"PBStrafePlayer");
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

