/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.ai;

import com.mojang.datafixers.util.Pair;
import insane96mcp.progressivebosses.module.wither.data.WitherAttack;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class WitherChargeAttackGoal
extends Goal {
    private static float DEFAULT_DAMAGE = 8.0f;
    private static int DEFAULT_TIME_TO_CHARGE = 50;
    public static ResourceKey<DamageType> WITHER_CHARGE_DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("progressivebosses", "wither_charge"));
    private final PBWither wither;
    private Vec3 targetPos;
    private double lastDistanceFromTarget = 0.0;
    private boolean blowUp = false;
    ObjectArrayList<Pair<ItemStack, BlockPos>> blocksToDrop = new ObjectArrayList();

    public WitherChargeAttackGoal(PBWither wither) {
        this.wither = wither;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        return this.wither.isCharging();
    }

    public void m_8056_() {
        this.wither.m_21573_().m_26573_();
        for (int h = 0; h < 3; ++h) {
            this.wither.setAlternativeTarget(h, 0);
        }
        this.wither.m_9236_().m_5594_(null, this.wither.m_20183_(), SoundEvents.f_12556_, SoundSource.HOSTILE, 5.0f, 2.0f);
        this.blocksToDrop.clear();
        if (this.wither.chargeType == ChargeType.STUCK) {
            this.targetPos = this.wither.m_20182_().m_82520_(0.0, -5.0, 0.0);
            return;
        }
        List playersNearby = this.wither.m_9236_().m_45976_(Player.class, this.wither.m_20191_().m_82400_(3.0));
        if (!playersNearby.isEmpty()) {
            if (this.wither.needsHealing()) {
                this.targetPos = this.wither.m_20182_().m_82520_((double)((this.wither.m_217043_().m_188503_(5) - 2) * 10), (double)((this.wither.m_217043_().m_188503_(5) - 2) * 10), (double)((this.wither.m_217043_().m_188503_(5) - 2) * 10));
            } else {
                this.blowUp = true;
                this.targetPos = this.wither.m_20182_();
            }
        } else {
            LivingEntity target = this.wither.m_5448_();
            if (target == null) {
                playersNearby = this.wither.m_9236_().m_45976_(Player.class, this.wither.m_20191_().m_82400_(64.0));
                if (!playersNearby.isEmpty()) {
                    target = (LivingEntity)playersNearby.get(this.wither.m_217043_().m_188503_(playersNearby.size()));
                }
            } else if (target != null) {
                this.wither.m_21391_((Entity)target, 30.0f, 30.0f);
                this.targetPos = target.m_20182_().m_82520_(0.0, -1.5, 0.0);
                Vec3 forward = this.targetPos.m_82546_(this.wither.m_20182_()).m_82541_();
                this.targetPos = this.targetPos.m_82549_(forward.m_82542_(4.0, 4.0, 4.0));
                this.lastDistanceFromTarget = this.targetPos.m_82557_(this.wither.m_20182_());
            } else {
                this.wither.stopCharging();
            }
        }
    }

    public void m_8041_() {
        this.wither.m_20256_(this.wither.m_20184_().m_82542_(0.02, 0.02, 0.02));
        this.wither.f_19864_ = true;
        this.lastDistanceFromTarget = 0.0;
        this.targetPos = null;
        this.blowUp = false;
        for (Pair pair : this.blocksToDrop) {
            Block.m_49840_((Level)this.wither.m_9236_(), (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    public void m_8037_() {
        if (!this.wither.isCharging()) {
            return;
        }
        int chargeTicks = this.wither.getChargingTicks();
        if (chargeTicks > 30) {
            this.wither.m_20256_(Vec3.f_82478_);
            if (this.targetPos != null) {
                this.wither.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPos);
            }
        } else if (chargeTicks == 30) {
            if (this.targetPos == null) {
                this.wither.stopCharging();
                return;
            }
            this.wither.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.targetPos), SoundEvents.f_12563_, SoundSource.HOSTILE, 4.0f, 2.0f);
            this.lastDistanceFromTarget = this.targetPos.m_82557_(this.wither.m_20182_());
        } else if (this.blowUp) {
            this.wither.m_9236_().m_247517_(null, this.wither.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE);
            ((ServerLevel)this.wither.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.wither.m_20185_(), this.wither.m_20186_(), this.wither.m_20189_(), 2, 0.0, 0.0, 0.0, 1.0);
            AABB axisAlignedBB = this.wither.m_20191_().m_82377_(2.0, 1.0, 2.0);
            Stream blocks = BlockPos.m_121921_((AABB)axisAlignedBB);
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.wither.m_9236_(), (Entity)this.wither)) {
                blocks.forEach(blockPos -> {
                    BlockState state = this.wither.m_9236_().m_8055_(blockPos);
                    if (this.wither.canDestroyBlock((BlockPos)blockPos, state) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this.wither, (BlockPos)blockPos, (BlockState)state) && !state.m_60734_().equals(Blocks.f_50016_)) {
                        BlockEntity tileentity = state.m_155947_() ? this.wither.m_9236_().m_7702_(blockPos) : null;
                        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.wither.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)tileentity);
                        state.m_287290_(lootcontext$builder).forEach(itemStack -> WitherChargeAttackGoal.addBlockDrops(this.blocksToDrop, itemStack, blockPos));
                        this.wither.m_9236_().m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                    }
                });
            }
            this.wither.m_9236_().m_45976_(LivingEntity.class, this.wither.m_20191_().m_82400_(4.0)).forEach(this::damageAndPush);
            this.wither.stopCharging();
            if (this.wither.stats.attack.barrage != null) {
                this.wither.initBarrage();
            }
        } else if (this.targetPos == null) {
            this.wither.stopCharging();
        } else {
            double mult = 60.0 / (double)chargeTicks;
            Vec3 diff = this.targetPos.m_82546_(this.wither.m_20182_()).m_82541_().m_82542_(mult, mult, mult);
            this.wither.m_20334_(diff.f_82479_, diff.f_82480_ * 0.5, diff.f_82481_);
            this.wither.m_21563_().m_24964_(this.targetPos);
            AABB axisAlignedBB = this.wither.m_20191_().m_82377_(2.0, 1.5, 2.0);
            Stream blocks = BlockPos.m_121921_((AABB)axisAlignedBB);
            AtomicBoolean hasBrokenBlocks = new AtomicBoolean(false);
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.wither.m_9236_(), (Entity)this.wither)) {
                blocks.forEach(blockPos -> {
                    BlockState state = this.wither.m_9236_().m_8055_(blockPos);
                    if (this.wither.canDestroyBlock((BlockPos)blockPos, state) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this.wither, (BlockPos)blockPos, (BlockState)state) && !state.m_60734_().equals(Blocks.f_50016_)) {
                        BlockEntity tileentity = state.m_155947_() ? this.wither.m_9236_().m_7702_(blockPos) : null;
                        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.wither.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)tileentity);
                        state.m_287290_(lootcontext$builder).forEach(itemStack -> WitherChargeAttackGoal.addBlockDrops(this.blocksToDrop, itemStack, blockPos));
                        this.wither.m_9236_().m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        hasBrokenBlocks.set(true);
                    }
                });
            }
            if (hasBrokenBlocks.get() && this.wither.f_19797_ % 3 == 0) {
                this.wither.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.targetPos), SoundEvents.f_12555_, SoundSource.HOSTILE, 1.0f, 0.75f);
            }
            axisAlignedBB = axisAlignedBB.m_82400_(1.5);
            this.wither.m_9236_().m_45976_(LivingEntity.class, axisAlignedBB).forEach(this::damageAndPush);
            double distance = this.targetPos.m_82557_(this.wither.m_20182_());
            if (distance - this.lastDistanceFromTarget >= 0.0 && chargeTicks < 29 || distance < 10.0 || chargeTicks == 1) {
                this.wither.stopCharging();
            }
            this.lastDistanceFromTarget = distance;
        }
    }

    private void damageAndPush(LivingEntity entity) {
        ServerPlayer player;
        if (entity == this.wither) {
            return;
        }
        entity.m_6469_(entity.m_269291_().m_269298_(WITHER_CHARGE_DAMAGE_TYPE, (Entity)this.wither), this.wither.stats.attack.charge == null ? 12.0f : WitherAttack.WitherCharge.getDamage(this.wither));
        float d2 = (float)(entity.m_20185_() - this.wither.m_20185_());
        float d3 = (float)(entity.m_20189_() - this.wither.m_20189_());
        float d4 = Math.max(d2 * d2 + d3 * d3, 0.1f);
        float horizontalPush = (float)(5.0 * (1.0 - entity.m_21133_(Attributes.f_22278_)));
        float verticalPush = (float)((double)0.65f * (1.0 - entity.m_21133_(Attributes.f_22278_)));
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        entity.m_5997_((double)(d2 / d4 * horizontalPush), (double)verticalPush, (double)(d3 / d4 * horizontalPush));
        if (entity instanceof Player) {
            player = (Player)entity;
            player.f_19864_ = true;
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_46068_, ItemStack p_46069_, BlockPos p_46070_) {
        int i = p_46068_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_46068_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_46069_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_46069_, (int)16);
            p_46068_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_46069_.m_41619_()) continue;
            return;
        }
        p_46068_.add((Object)Pair.of((Object)p_46069_, (Object)p_46070_));
    }

    public static enum ChargeType {
        ON_HIT(wither -> Float.valueOf(wither.stats.attack.charge.onHit == null ? DEFAULT_DAMAGE : wither.stats.attack.charge.onHit.damage), wither -> wither.stats.attack.charge.onHit == null ? DEFAULT_TIME_TO_CHARGE : wither.stats.attack.charge.onHit.timeToCharge),
        SECOND_PHASE(wither -> Float.valueOf(wither.stats.attack.charge.secondPhase == null ? DEFAULT_DAMAGE : wither.stats.attack.charge.secondPhase.damage), wither -> wither.stats.attack.charge.secondPhase == null ? DEFAULT_TIME_TO_CHARGE : wither.stats.attack.charge.secondPhase.timeToCharge),
        TARGET_UNSEEN(wither -> Float.valueOf(wither.stats.attack.charge.targetUnseen == null ? DEFAULT_DAMAGE : wither.stats.attack.charge.targetUnseen.damage), wither -> wither.stats.attack.charge.targetUnseen == null ? DEFAULT_TIME_TO_CHARGE : wither.stats.attack.charge.targetUnseen.timeToCharge),
        STUCK(wither -> Float.valueOf(DEFAULT_DAMAGE), wither -> DEFAULT_TIME_TO_CHARGE);

        public final Function<PBWither, Float> getDamage;
        public final Function<PBWither, Integer> getTimeToCharge;

        private ChargeType(Function<PBWither, Float> damage, Function<PBWither, Integer> timeToCharge) {
            this.getDamage = damage;
            this.getTimeToCharge = timeToCharge;
        }

        public float getDamage(PBWither wither) {
            return this.getDamage.apply(wither).floatValue();
        }

        public int getTimeToCharge(PBWither wither) {
            return this.getTimeToCharge.apply(wither);
        }
    }
}

