/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import insane96mcp.progressivebosses.data.Difficulty;
import insane96mcp.progressivebosses.module.wither.data.PoweredValue;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;

public class WitherAttack {
    @SerializedName(value="skull_damage")
    public float skullDamage = 8.0f;
    @SerializedName(value="skull_speed_multiplier")
    public float skullSpeedMultiplier = 1.0f;
    @SerializedName(value="dangerous_skull_chance")
    public PoweredValue dangerousSkullChance = PoweredValue.of(0.05f);
    @SerializedName(value="attack_speed_near")
    public int attackSpeedNear = 40;
    @SerializedName(value="attack_speed_far")
    public int attackSpeedFar = 40;
    @SerializedName(value="side_heads_attack_speed_multiplier")
    public float sideHeadsAttackSpeedMultiplier = 1.0f;
    @SerializedName(value="effect_amplifier")
    public int effectAmplifier = 0;
    @SerializedName(value="effect_duration")
    public Difficulty effectDuration = Difficulty.of(10.0f, 10.0f, 20.0f);
    @SerializedName(value="attack_to_heal_threshold")
    public float attackToHealThreshold;
    @SerializedName(value="heal_on_skull_kill")
    public float healOnSkullKill = 5.0f;
    @SerializedName(value="charge")
    @Nullable
    public WitherCharge charge;
    @SerializedName(value="barrage")
    @Nullable
    public WitherBarrage barrage;

    public static class WitherBarrage {
        @SerializedName(value="chance_on_hit")
        public PoweredValue chanceOnHit = PoweredValue.of(0.05f);
        @SerializedName(value="min_duration")
        public int minDuration = 40;
        @SerializedName(value="max_duration")
        public int maxDuration = 60;
        @SerializedName(value="attack_speed")
        public int attackSpeed = 5;
        @SerializedName(value="attack_cooldown_on_end")
        public int attackCooldownOnEnd = 0;
        @SerializedName(value="inaccuracy")
        public PoweredValue inaccuracy = PoweredValue.ZERO;
    }

    public static class WitherCharge {
        @SerializedName(value="on_hit")
        public OnHit onHit;
        @SerializedName(value="second_phase")
        public SecondPhase secondPhase;
        @SerializedName(value="target_unseen")
        public TargetUnseen targetUnseen;

        public static float getDamage(PBWither wither) {
            return wither.chargeType.getDamage(wither);
        }

        public static int getTimeToCharge(PBWither wither) {
            return wither.chargeType.getTimeToCharge(wither);
        }

        @JsonAdapter(value=Serializer.class)
        public static class TargetUnseen
        extends BaseCharge {
            @SerializedName(value="seconds_unseen")
            public int secondsUnseen;
            @SerializedName(value="chance_per_second")
            public float chancePerSecond;
            @SerializedName(value="max_chance")
            public float maxChance;

            public static class Serializer
            implements JsonSerializer<TargetUnseen>,
            JsonDeserializer<TargetUnseen> {
                public TargetUnseen deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject jObject = json.getAsJsonObject();
                    TargetUnseen targetUnseen = new TargetUnseen();
                    targetUnseen.secondsUnseen = GsonHelper.m_13927_((JsonObject)jObject, (String)"seconds_unseen");
                    targetUnseen.chancePerSecond = GsonHelper.m_13915_((JsonObject)jObject, (String)"chance_per_second");
                    targetUnseen.maxChance = GsonHelper.m_13820_((JsonObject)jObject, (String)"max_chance", (float)1.0f);
                    targetUnseen.damage = GsonHelper.m_13915_((JsonObject)jObject, (String)"damage");
                    targetUnseen.timeToCharge = GsonHelper.m_13927_((JsonObject)jObject, (String)"time_to_charge");
                    return targetUnseen;
                }

                public JsonElement serialize(TargetUnseen src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("seconds_unseen", (Number)src.secondsUnseen);
                    jsonObject.addProperty("chance_per_second", (Number)Float.valueOf(src.chancePerSecond));
                    jsonObject.addProperty("max_chance", (Number)Float.valueOf(src.maxChance));
                    jsonObject.addProperty("damage", (Number)Float.valueOf(src.damage));
                    jsonObject.addProperty("time_to_charge", (Number)src.timeToCharge);
                    return jsonObject;
                }
            }
        }

        @JsonAdapter(value=Serializer.class)
        public static class SecondPhase
        extends BaseCharge {
            @SerializedName(value="times")
            public int times;
            @SerializedName(value="tick_reduction")
            public int tickReduction;
            @SerializedName(value="max_reduction")
            public int maxReduction;
            @SerializedName(value="barrage")
            public boolean barrage;
            @SerializedName(value="minion")
            public boolean minion;

            public static class Serializer
            implements JsonSerializer<SecondPhase>,
            JsonDeserializer<SecondPhase> {
                public SecondPhase deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject jObject = json.getAsJsonObject();
                    SecondPhase secondPhase = new SecondPhase();
                    secondPhase.times = GsonHelper.m_13927_((JsonObject)jObject, (String)"times");
                    secondPhase.tickReduction = GsonHelper.m_13824_((JsonObject)jObject, (String)"tick_reduction", (int)0);
                    secondPhase.maxReduction = GsonHelper.m_13824_((JsonObject)jObject, (String)"max_reduction", (int)Integer.MAX_VALUE);
                    secondPhase.barrage = GsonHelper.m_13855_((JsonObject)jObject, (String)"barrage", (boolean)false);
                    secondPhase.minion = GsonHelper.m_13855_((JsonObject)jObject, (String)"minion", (boolean)false);
                    secondPhase.damage = GsonHelper.m_13915_((JsonObject)jObject, (String)"damage");
                    secondPhase.timeToCharge = GsonHelper.m_13927_((JsonObject)jObject, (String)"time_to_charge");
                    return secondPhase;
                }

                public JsonElement serialize(SecondPhase src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("times", (Number)src.times);
                    jsonObject.addProperty("tick_reduction", (Number)src.tickReduction);
                    jsonObject.addProperty("max_reduction", (Number)src.maxReduction);
                    jsonObject.addProperty("barrage", Boolean.valueOf(src.barrage));
                    jsonObject.addProperty("minion", Boolean.valueOf(src.minion));
                    jsonObject.addProperty("damage", (Number)Float.valueOf(src.damage));
                    jsonObject.addProperty("time_to_charge", (Number)src.timeToCharge);
                    return jsonObject;
                }
            }
        }

        @JsonAdapter(value=Serializer.class)
        public static class OnHit
        extends BaseCharge {
            @SerializedName(value="chance")
            public PoweredValue chance;

            public static class Serializer
            implements JsonSerializer<OnHit>,
            JsonDeserializer<OnHit> {
                public OnHit deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject jObject = json.getAsJsonObject();
                    OnHit onHit = new OnHit();
                    onHit.chance = (PoweredValue)context.deserialize(jObject.get("chance"), PoweredValue.class);
                    onHit.damage = GsonHelper.m_13915_((JsonObject)jObject, (String)"damage");
                    onHit.timeToCharge = GsonHelper.m_13927_((JsonObject)jObject, (String)"time_to_charge");
                    return onHit;
                }

                public JsonElement serialize(OnHit src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add("chance", context.serialize((Object)src.chance));
                    jsonObject.addProperty("damage", (Number)Float.valueOf(src.damage));
                    jsonObject.addProperty("time_to_charge", (Number)src.timeToCharge);
                    return jsonObject;
                }
            }
        }

        public static abstract class BaseCharge {
            @SerializedName(value="damage")
            public float damage;
            @SerializedName(value="time_to_charge")
            public int timeToCharge;
        }
    }

    public static class Builder {
        private WitherAttack instance = new WitherAttack();

        public Builder skullDamage(float skullDamage) {
            this.instance.skullDamage = skullDamage;
            return this;
        }

        public Builder skullSpeedMultiplier(float skullSpeedMultiplier) {
            this.instance.skullSpeedMultiplier = skullSpeedMultiplier;
            return this;
        }

        public Builder dangerousSkullChance(PoweredValue dangerousSkullChance) {
            this.instance.dangerousSkullChance = dangerousSkullChance;
            return this;
        }

        public Builder attackSpeedNear(int attackSpeedNear) {
            this.instance.attackSpeedNear = attackSpeedNear;
            return this;
        }

        public Builder attackSpeedFar(int attackSpeedFar) {
            this.instance.attackSpeedFar = attackSpeedFar;
            return this;
        }

        public Builder sideHeadsAttackSpeedMultiplier(float sideHeadsAttackSpeedMultiplier) {
            this.instance.sideHeadsAttackSpeedMultiplier = sideHeadsAttackSpeedMultiplier;
            return this;
        }

        public Builder effectAmplifier(int effectAmplifier) {
            this.instance.effectAmplifier = effectAmplifier;
            return this;
        }

        public Builder effectDuration(Difficulty effectDuration) {
            this.instance.effectDuration = effectDuration;
            return this;
        }

        public Builder attackToHealThreshold(float attackToHealThreshold) {
            this.instance.attackToHealThreshold = attackToHealThreshold;
            return this;
        }

        public Builder healOnSkullKill(float healOnSkullKill) {
            this.instance.healOnSkullKill = healOnSkullKill;
            return this;
        }

        public Builder charge(@Nullable WitherCharge charge) {
            this.instance.charge = charge;
            return this;
        }

        public Builder barrage(@Nullable WitherBarrage barrage) {
            this.instance.barrage = barrage;
            return this;
        }

        public WitherAttack build() {
            return this.instance;
        }
    }
}

