/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.entity;

import com.google.common.collect.ImmutableList;
import insane96mcp.insanelib.data.SerializableAttributeModifier;
import insane96mcp.progressivebosses.module.ILvl;
import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherInvulnerableGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherRangedAttackGoal;
import insane96mcp.progressivebosses.module.wither.data.WitherAttack;
import insane96mcp.progressivebosses.module.wither.data.WitherStats;
import insane96mcp.progressivebosses.module.wither.data.WitherStatsReloadListener;
import insane96mcp.progressivebosses.module.wither.entity.WitherNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.module.wither.entity.skull.PBWitherSkull;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PBWither
extends Monster
implements PowerableMob,
RangedAttackMob,
ILvl {
    public static final int CHARGE_ATTACK_TICK_CHARGE = 30;
    public static final int BARRAGE_CHARGE_UP_TICKS = 30;
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_DYING = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LVL = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHARGING = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BARRAGE_CHARGE_UP = SynchedEntityData.m_135353_(PBWither.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int INVULNERABLE_TICKS = 220;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    public int destroyBlocksTick;
    public final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    public static final Predicate<LivingEntity> NO_UNDEAD_SELECTOR = livingEntity -> livingEntity.m_6336_() != MobType.f_21641_ && livingEntity.m_5789_();
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(48.0).m_26888_(NO_UNDEAD_SELECTOR);
    private static final TargetingConditions TARGETING_CONDITIONS_NEEDS_HEALING = TargetingConditions.m_148352_().m_26883_(48.0).m_26888_(LivingEntity::m_5789_);
    public int barrageTicks;
    public WitherStats stats;
    public int minionCooldown;
    public int shotSkulls;
    private int secondPhaseCharge;
    public WitherRangedAttackGoal rangedAttackGoal;
    public WitherChargeAttackGoal.ChargeType chargeType;
    public DamageSource deathDamageSource = null;

    public PBWither(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21153_(this.m_21233_());
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_8099_() {
        this.rangedAttackGoal = new WitherRangedAttackGoal(this, 32.0f);
        this.f_21345_.m_25352_(0, (Goal)new WitherInvulnerableGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WitherChargeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)this.rangedAttackGoal);
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new WitherNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, new WitherNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, false));
    }

    public Component m_7755_() {
        Component component = this.m_7770_();
        if (component != null) {
            return super.m_7755_();
        }
        return Component.m_237115_((String)(Util.m_137492_((String)"entity", (ResourceLocation)ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_())) + "." + this.getLvl()));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.stats.finalizeSpawn(this);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected boolean m_6124_() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Invul", this.getInvulnerableTicks());
        tag.m_128405_("lvl", this.getLvl());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setInvulnerableTicks(tag.m_128451_("Invul"));
        this.setLvl(tag.m_128451_("lvl"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TARGET_A, (Object)0);
        this.f_19804_.m_135372_(DATA_TARGET_B, (Object)0);
        this.f_19804_.m_135372_(DATA_TARGET_C, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DYING, (Object)0);
        this.f_19804_.m_135372_(LVL, (Object)0);
        this.f_19804_.m_135372_(CHARGING, (Object)0);
        this.f_19804_.m_135372_(BARRAGE_CHARGE_UP, (Object)0);
    }

    private void updateStats(boolean wasPowered) {
        if (this.stats.attributeModifiers == null) {
            return;
        }
        if (wasPowered != this.m_7090_()) {
            List<SerializableAttributeModifier> listToRemove = wasPowered ? this.stats.attributeModifiers.belowHalfHealth : this.stats.attributeModifiers.aboveHalfHealth;
            List<SerializableAttributeModifier> listToAdd = wasPowered ? this.stats.attributeModifiers.aboveHalfHealth : this.stats.attributeModifiers.belowHalfHealth;
            for (SerializableAttributeModifier modifier : listToRemove) {
                this.m_21051_((Attribute)modifier.attribute().get()).m_22120_(modifier.uuid());
            }
            for (SerializableAttributeModifier modifier : listToAdd) {
                this.m_21051_((Attribute)modifier.attribute().get()).m_22125_(modifier.getModifier());
            }
        }
    }

    public int getChargingTicks() {
        return (Integer)this.f_19804_.m_135370_(CHARGING);
    }

    private void setChargingTicks(int ticks) {
        this.f_19804_.m_135381_(CHARGING, (Object)Math.max(ticks, 30));
    }

    private void setChargingCooldown(int cooldown) {
        this.f_19804_.m_135381_(CHARGING, (Object)(-cooldown));
    }

    public boolean isCharging() {
        return this.getChargingTicks() > 0;
    }

    public boolean isChargingInCooldown() {
        return this.getChargingTicks() < 0;
    }

    public boolean canCharge() {
        return !this.isCharging() && !this.isChargingInCooldown() && this.stats.attack.charge != null && this.getBarrageChargeUpTicks() == 0;
    }

    public void tickCharging() {
        int ticks = this.getChargingTicks();
        if (ticks > 0) {
            --ticks;
        } else if (ticks < 0) {
            ++ticks;
        }
        this.f_19804_.m_135381_(CHARGING, (Object)ticks);
    }

    public boolean initCharging(WitherChargeAttackGoal.ChargeType chargeType) {
        if (this.isCharging()) {
            return false;
        }
        this.chargeType = chargeType;
        int chargeTime = WitherAttack.WitherCharge.getTimeToCharge(this);
        double missingHealthPercentage = 1.0 - (double)(this.m_21223_() / this.m_21233_());
        this.setChargingTicks((chargeTime -= (int)(20.0 * missingHealthPercentage)) + 30);
        return true;
    }

    public void stopCharging() {
        int cooldown = 40;
        if (this.secondPhaseCharge > 0) {
            cooldown = this.f_19796_.m_188503_(6) + 3;
        } else if (this.needsHealing()) {
            cooldown = 120;
        }
        this.setChargingCooldown(cooldown);
    }

    public void tryChargeOnHit(float damageAmount) {
        if (!this.canCharge() || this.stats.attack.charge.onHit == null) {
            return;
        }
        float chance = this.stats.attack.charge.onHit.chance.getValue(this) * (damageAmount / 10.0f);
        if (!this.m_7090_() && !this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(5.0)).isEmpty()) {
            chance = 0.25f;
        }
        this.tryCharge(chance, WitherChargeAttackGoal.ChargeType.ON_HIT);
    }

    public void tryCharge(float chance, WitherChargeAttackGoal.ChargeType chargeType) {
        if (!this.canCharge()) {
            return;
        }
        if (this.m_217043_().m_188500_() < (double)chance) {
            this.initCharging(chargeType);
        }
    }

    private void tickBarrage() {
        int barrage = this.getBarrageChargeUpTicks();
        if (barrage > 0) {
            if (--barrage % 5 == 0 && barrage > 10) {
                this.m_5496_(SoundEvents.f_12554_, 4.0f, 0.75f);
            }
            if (barrage == 5) {
                this.initBarrage();
            }
            this.setBarrageChargeUpTicks(barrage);
        }
        if (this.barrageTicks > 0) {
            --this.barrageTicks;
            if (this.barrageTicks == 0 && this.stats.attack.barrage.attackCooldownOnEnd > 0) {
                int i = 0;
                while (i < 3) {
                    int n = i++;
                    this.rangedAttackGoal.headAttackTimes[n] = this.rangedAttackGoal.headAttackTimes[n] + this.stats.attack.barrage.attackCooldownOnEnd;
                }
            }
        }
    }

    public int getBarrageChargeUpTicks() {
        return (Integer)this.f_19804_.m_135370_(BARRAGE_CHARGE_UP);
    }

    public void setBarrageChargeUpTicks(int ticks) {
        this.f_19804_.m_135381_(BARRAGE_CHARGE_UP, (Object)ticks);
    }

    public void tryBarrageOnHit(float damageAmount) {
        if (this.stats.attack.barrage == null || this.getBarrageChargeUpTicks() > 0 || this.barrageTicks > 0 || this.isCharging()) {
            return;
        }
        double chance = this.stats.attack.barrage.chanceOnHit.getValue(this) * (damageAmount / 10.0f);
        if (this.m_217043_().m_188500_() < chance) {
            this.initBarrageChargeUp();
        }
    }

    public boolean initBarrageChargeUp() {
        this.setBarrageChargeUpTicks(30);
        return true;
    }

    public void initBarrage() {
        double missingHealthPercentage = 1.0 - (double)(this.m_21223_() / this.m_21233_());
        this.barrageTicks = (int)((double)(this.stats.attack.barrage.maxDuration - this.stats.attack.barrage.minDuration) * missingHealthPercentage + (double)this.stats.attack.barrage.minDuration);
    }

    private void tickMinion() {
        if (this.stats.minion != null && --this.minionCooldown <= 0 && !this.isCharging()) {
            this.stats.minion.trySpawnMinion(this, false);
        }
    }

    @Override
    public void setLvl(int lvl) {
        if (!WitherStatsReloadListener.STATS_MAP.containsKey(lvl) && !WitherStatsReloadListener.STATS_MAP.containsKey(lvl = 0)) {
            this.m_146870_();
            LogHelper.warn("Failed to load wither stats, wither discarded", new Object[0]);
            return;
        }
        this.f_19804_.m_135381_(LVL, (Object)lvl);
        this.stats = WitherStatsReloadListener.STATS_MAP.get(lvl);
        this.stats.apply(this);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    public int getLvl() {
        return (Integer)this.f_19804_.m_135370_(LVL);
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12557_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12556_;
    }

    public void m_8107_() {
        block25: {
            int dyingAnimationTicks;
            block26: {
                block27: {
                    if (this.getInvulnerableTicks() > 0 || this.getBarrageChargeUpTicks() > 5) {
                        this.m_20256_(Vec3.f_82478_);
                    } else if (!this.isCharging()) {
                        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0);
                        if (!this.m_9236_().f_46443_) {
                            if (this.m_5448_() != null) {
                                if (this.m_5448_() != null) {
                                    float f;
                                    double d0 = 0.0;
                                    float f2 = f = !this.m_7090_() ? 5.0f : 0.0f;
                                    if (this.m_20186_() >= this.m_5448_().m_20186_() + (double)f + 1.0) {
                                        d0 = -0.15;
                                    }
                                    if (this.m_20186_() < this.m_5448_().m_20186_() || this.m_20186_() < this.m_5448_().m_20186_() + (double)f) {
                                        d0 = 0.3;
                                    }
                                    vec3 = new Vec3(vec3.f_82479_, d0, vec3.f_82481_);
                                    Vec3 vec31 = new Vec3(this.m_5448_().m_20185_() - this.m_20185_(), 0.0, this.m_5448_().m_20189_() - this.m_20189_());
                                    if (vec31.m_165925_() > 9.0) {
                                        Vec3 vec32 = vec31.m_82541_();
                                        vec3 = vec3.m_82520_(vec32.f_82479_ * 0.3 - vec3.f_82479_ * 0.6, 0.0, vec32.f_82481_ * 0.3 - vec3.f_82481_ * 0.6);
                                    }
                                }
                            } else if (this.m_5830_()) {
                                this.initCharging(WitherChargeAttackGoal.ChargeType.STUCK);
                            }
                        }
                        this.m_20256_(vec3);
                    }
                    super.m_8107_();
                    for (int head = 0; head < 2; ++head) {
                        int targetId = this.getAlternativeTarget(head + 1);
                        Entity target = null;
                        if (targetId > 0) {
                            target = this.m_9236_().m_6815_(targetId);
                        }
                        if (target != null) {
                            double headX = this.getHeadX(head + 1);
                            double headY = this.getHeadY(head + 1);
                            double headZ = this.getHeadZ(head + 1);
                            double diffX = target.m_20185_() - headX;
                            double diffY = target.m_20188_() - headY;
                            double diffZ = target.m_20189_() - headZ;
                            double distance = Math.sqrt(diffX * diffX + diffZ * diffZ);
                            float xRot = (float)(Mth.m_14136_((double)diffZ, (double)diffX) * 57.2957763671875) - 90.0f;
                            float yRot = (float)(-(Mth.m_14136_((double)diffY, (double)distance) * 57.2957763671875));
                            this.xRotHeads[head] = this.rotLerp(this.xRotHeads[head], yRot, 40.0f);
                            this.yRotHeads[head] = this.rotLerp(this.yRotHeads[head], xRot, 10.0f);
                            continue;
                        }
                        this.yRotHeads[head] = this.rotLerp(this.yRotHeads[head], this.f_20883_, 10.0f);
                    }
                    boolean isPowered = this.m_7090_();
                    for (int l = 0; l < 3; ++l) {
                        double headX = this.getHeadX(l);
                        double headY = this.getHeadY(l);
                        double headZ = this.getHeadZ(l);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, headX + this.f_19796_.m_188583_() * (double)0.3f, headY + this.f_19796_.m_188583_() * (double)0.3f, headZ + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
                        if (!isPowered || this.m_9236_().f_46441_.m_188503_(4) != 0) continue;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, headX + this.f_19796_.m_188583_() * (double)0.3f, headY + this.f_19796_.m_188583_() * (double)0.3f, headZ + this.f_19796_.m_188583_() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
                    }
                    if (this.getInvulnerableTicks() > 0) {
                        for (int i = 0; i < 3; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * 3.3f), this.m_20189_() + this.f_19796_.m_188583_(), (double)0.7f, (double)0.7f, (double)0.9f);
                        }
                    }
                    if ((dyingAnimationTicks = this.getDyingAnimationTicks()) <= 0) break block25;
                    if (this.m_9236_().f_46443_) break block26;
                    this.setDyingAnimationTicks(--dyingAnimationTicks);
                    if (dyingAnimationTicks > 3) break block27;
                    float explosionRadius = this.stats.death.explosionPower;
                    if (dyingAnimationTicks == 3 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                        BlockPos.m_121921_((AABB)this.m_20191_().m_82400_(4.0)).forEach(blockPos -> {
                            BlockState state = this.m_9236_().m_8055_(blockPos);
                            if (this.canDestroyBlock((BlockPos)blockPos, state) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockPos, (BlockState)state) && !state.m_60734_().equals(Blocks.f_50016_)) {
                                BlockEntity blockEntity = state.m_155947_() ? this.m_9236_().m_7702_(blockPos) : null;
                                LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(explosionRadius));
                                this.m_9236_().m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                            }
                        });
                    }
                    this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), explosionRadius, this.stats.death.explosionCausesFire, Level.ExplosionInteraction.MOB);
                    if (dyingAnimationTicks == 0) {
                        this.m_6667_(this.deathDamageSource);
                        this.m_146870_();
                    }
                    break block25;
                }
                if (dyingAnimationTicks % 20 != 0) break block25;
                this.m_5496_(SoundEvents.f_12557_, 4.0f, 1.0f - (float)(100 - dyingAnimationTicks) * 0.005f);
                break block25;
            }
            int speed = 20;
            speed += (100 - dyingAnimationTicks) / 2;
            if (dyingAnimationTicks <= 5) {
                speed -= (5 - dyingAnimationTicks) * 10;
            }
            float rotation = this.f_20885_ + (float)speed;
            this.m_146922_(rotation);
            this.m_5618_(rotation);
            this.m_5616_(rotation);
            for (int i = 0; i < 2; ++i) {
                this.yRotHeads[i] = rotation;
            }
            if (dyingAnimationTicks < 3) {
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            double x1 = this.m_20185_() + (this.f_19796_.m_188500_() * 3.0 - 1.5) + (double)(x * 3);
                            double y1 = this.m_20188_() + (this.f_19796_.m_188500_() * 3.0 - 1.5) + (double)(y * 3);
                            double z1 = this.m_20189_() + (this.f_19796_.m_188500_() * 3.0 - 1.5) + (double)(z * 3);
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, x1, y1, z1, (double)this.f_19796_.m_188501_(), 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    protected int findNewTarget() {
        List livingsNearby;
        if (!this.needsHealing()) {
            List playersNearby = this.m_9236_().m_45971_(Player.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(32.0, 24.0, 32.0));
            if (!playersNearby.isEmpty()) {
                if (playersNearby.size() == 1) {
                    return ((Player)playersNearby.get(0)).m_19879_();
                }
                Player player = (Player)playersNearby.get(this.f_19796_.m_188503_(playersNearby.size()));
                return player.m_19879_();
            }
            if (this.m_5448_() != null) {
                return this.m_5448_().m_19879_();
            }
        }
        if (!(livingsNearby = this.m_9236_().m_45971_(LivingEntity.class, this.needsHealing() ? TARGETING_CONDITIONS_NEEDS_HEALING : TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(32.0, 24.0, 32.0))).isEmpty()) {
            LivingEntity livingEntity = (LivingEntity)livingsNearby.get(this.f_19796_.m_188503_(livingsNearby.size()));
            return livingEntity.m_19879_();
        }
        return 0;
    }

    protected void m_8024_() {
        if (this.getInvulnerableTicks() > 0) {
            int newInvulTicks = this.getInvulnerableTicks() - 1;
            this.bossEvent.m_142711_(1.0f - (float)newInvulTicks / 220.0f);
            if (newInvulTicks <= 0) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.stats.misc.explosionPower, this.stats.misc.explosionCausesFire, Level.ExplosionInteraction.MOB);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
                }
                this.m_21153_(this.m_21233_());
            }
            this.setInvulnerableTicks(newInvulTicks);
        } else if (this.getDyingAnimationTicks() <= 0) {
            super.m_8024_();
            for (int i = 0; i < 2; ++i) {
                if (this.f_19797_ < this.nextHeadUpdate[i]) continue;
                this.nextHeadUpdate[i] = this.f_19797_ + 15 + this.f_19796_.m_188503_(15);
                int targetId = this.getAlternativeTarget(i + 1);
                if (targetId > 0) {
                    LivingEntity targetEntity = (LivingEntity)this.m_9236_().m_6815_(targetId);
                    if (targetEntity != null && !targetEntity.m_21224_() && this.m_6779_(targetEntity) && this.m_21574_().m_148306_((Entity)targetEntity) && targetId != this.getAlternativeTarget(0) && !(targetEntity.m_20280_((Entity)this) > 625.0)) continue;
                    this.setAlternativeTarget(i + 1, this.findNewTarget());
                    continue;
                }
                this.setAlternativeTarget(i + 1, this.findNewTarget());
            }
            if (this.m_5448_() != null) {
                this.setAlternativeTarget(0, this.m_5448_().m_19879_());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                    int y = Mth.m_14107_((double)this.m_20186_());
                    int x = Mth.m_14107_((double)this.m_20185_());
                    int z = Mth.m_14107_((double)this.m_20189_());
                    boolean hasDestroyedBlock = false;
                    for (int x1 = -1; x1 <= 1; ++x1) {
                        for (int z1 = -1; z1 <= 1; ++z1) {
                            int y1;
                            int n = y1 = this.m_7090_() ? 0 : -1;
                            while (y1 <= 4) {
                                int xToBreak = x + x1;
                                int yToBreak = y + y1;
                                int zToBreak = z + z1;
                                BlockPos blockPos = new BlockPos(xToBreak, yToBreak, zToBreak);
                                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                                if (this.canDestroyBlock(blockPos, blockState) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockPos, (BlockState)blockState)) {
                                    hasDestroyedBlock = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || hasDestroyedBlock;
                                }
                                ++y1;
                            }
                        }
                    }
                    if (hasDestroyedBlock) {
                        this.m_9236_().m_5898_(null, 1022, this.m_20183_(), 0);
                    }
                }
            }
            float regen = this.stats.health.regeneration / 20.0f;
            if (this.stats.health.regenWhenHit != this.stats.health.regeneration && this.f_19797_ > this.m_21213_() && this.f_19797_ - this.m_21213_() < this.stats.health.regenWhenHitDuration) {
                regen = this.stats.health.regenWhenHit / 20.0f;
            }
            this.m_5634_(regen);
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
            if (!this.isCharging() && !this.isChargingInCooldown() && this.secondPhaseCharge > 0) {
                --this.secondPhaseCharge;
                if (this.secondPhaseCharge == 0) {
                    if (this.stats.attack.charge.secondPhase.minion) {
                        this.minionCooldown = 10;
                    }
                    if (this.stats.attack.charge.secondPhase.barrage) {
                        this.initBarrageChargeUp();
                    }
                } else {
                    this.initCharging(WitherChargeAttackGoal.ChargeType.SECOND_PHASE);
                    this.setChargingTicks(this.getChargingTicks() - Math.min(this.stats.attack.charge.secondPhase.maxReduction, (this.stats.attack.charge.secondPhase.times - this.secondPhaseCharge) * this.stats.attack.charge.secondPhase.tickReduction));
                }
            }
            if (!this.isCharging()) {
                this.tickMinion();
            }
            this.tickCharging();
            this.tickBarrage();
        }
    }

    public boolean needsHealing() {
        return this.m_21223_() / this.m_21233_() < this.stats.attack.attackToHealThreshold;
    }

    public boolean canDestroyBlock(BlockPos pos, BlockState state) {
        if (this.stats.misc.ignoreWitherProofBlocks) {
            return !state.m_60795_() && state.m_60800_((BlockGetter)this.m_9236_(), pos) >= 0.0f;
        }
        return !state.m_60795_() && !state.m_204336_(BlockTags.f_13070_);
    }

    @Deprecated
    public static boolean canDestroy(BlockState pState) {
        return !pState.m_60795_() && !pState.m_204336_(BlockTags.f_13070_);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.m_142711_(0.0f);
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    public double getHeadX(int pHead) {
        if (pHead <= 0) {
            return this.m_20185_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1 * 1.3;
    }

    public double getHeadY(int pHead) {
        return pHead <= 0 ? this.m_20186_() + 3.0 : this.m_20186_() + 2.2;
    }

    public double getHeadZ(int pHead) {
        if (pHead <= 0) {
            return this.m_20189_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1 * 1.3;
    }

    private float rotLerp(float pAngle, float p_31444_, float p_31445_) {
        float f = Mth.m_14177_((float)(p_31444_ - pAngle));
        if (f > p_31445_) {
            f = p_31445_;
        }
        if (f < -p_31445_) {
            f = -p_31445_;
        }
        return pAngle + f;
    }

    public void performRangedAttack(int head, LivingEntity target) {
        this.performRangedAttack(head, target.m_20185_(), target.m_20186_() + (double)target.m_20192_() * 0.5, target.m_20189_(), head == 0 && this.f_19796_.m_188501_() < this.stats.attack.dangerousSkullChance.getValue(this) * ((float)this.shotSkulls / 10.0f));
    }

    public void performRangedAttack(int head, double pX, double pY, double pZ, boolean pIsDangerous) {
        if (head == 0) {
            ++this.shotSkulls;
        }
        if (!this.m_20067_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12558_, SoundSource.HOSTILE, 4.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
        double d0 = this.getHeadX(head);
        double d1 = this.getHeadY(head);
        double d2 = this.getHeadZ(head);
        double d3 = pX - d0;
        double d4 = pY - d1;
        double d5 = pZ - d2;
        PBWitherSkull witherskull = new PBWitherSkull(this.m_9236_(), (LivingEntity)this, d3, d4, d5);
        witherskull.m_5602_((Entity)this);
        if (pIsDangerous) {
            witherskull.setDangerous(true);
            this.shotSkulls = 0;
        }
        witherskull.m_20343_(d0, d1, d2);
        this.m_9236_().m_7967_((Entity)witherskull);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        this.performRangedAttack(0, pTarget);
    }

    public void m_5634_(float healAmount) {
        if (this.m_7090_() && this.m_21223_() + healAmount > this.m_21233_() / 2.0f) {
            healAmount = this.m_21233_() / 2.0f - this.m_21223_();
        }
        boolean wasPowered = this.m_7090_();
        super.m_5634_(healAmount);
        this.updateStats(wasPowered);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        PBWitherSkull skull;
        Entity entity2;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_269533_(DamageTypeTags.f_268484_) || pSource.m_7639_() instanceof PBWither && (entity2 = pSource.m_7640_()) instanceof PBWitherSkull && !(skull = (PBWitherSkull)entity2).isDangerous()) {
            return false;
        }
        if (this.getInvulnerableTicks() > 0 && !pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (this.getDyingAnimationTicks() > 0) {
            return false;
        }
        if (this.m_7090_() && (entity = pSource.m_7640_()) instanceof AbstractArrow) {
            return false;
        }
        Entity damagingEntity = pSource.m_7639_();
        if (!(damagingEntity instanceof Player) && damagingEntity instanceof LivingEntity && ((LivingEntity)damagingEntity).m_6336_() == this.m_6336_()) {
            return false;
        }
        if (this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 10;
        }
        int n = this.f_19796_.m_188503_(2);
        this.nextHeadUpdate[n] = this.nextHeadUpdate[n] - 8;
        boolean wasPowered = this.m_7090_();
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && !wasPowered && this.m_7090_() && this.stats.attack.charge != null && this.stats.attack.charge.secondPhase != null) {
            this.initCharging(WitherChargeAttackGoal.ChargeType.SECOND_PHASE);
            this.secondPhaseCharge = this.stats.attack.charge.secondPhase.times;
        }
        return hurt;
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        PBWitherSkull witherSkull;
        Entity entity;
        if (damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_276093_(DamageTypes.f_268530_)) {
            damageAmount *= 1.5f;
        }
        if ((entity = damageSource.m_7640_()) instanceof PBWitherSkull && (witherSkull = (PBWitherSkull)entity).isDangerous()) {
            damageAmount *= this.m_21233_() * 0.01f;
        }
        boolean wasPowered = this.m_7090_();
        super.m_6475_(damageSource, damageAmount);
        this.updateStats(wasPowered);
        if (!this.m_21224_()) {
            this.tryChargeOnHit(damageAmount);
            this.tryBarrageOnHit(damageAmount);
        } else if (this.stats.death != null) {
            this.m_21153_(0.01f);
            this.setDyingAnimationTicks(100);
            this.m_5496_(SoundEvents.f_12563_, 4.0f, 0.75f);
            this.deathDamageSource = damageSource;
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_() || this.m_20186_() < (double)(this.m_9236_().m_141937_() - 32)) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_().m_8093_() && super.m_7301_(pPotioneffect);
    }

    public float getHeadYRot(int pHead) {
        return this.yRotHeads[pHead];
    }

    public float getHeadXRot(int pHead) {
        return this.xRotHeads[pHead];
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int pInvulnerableTicks) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)pInvulnerableTicks);
    }

    public int getDyingAnimationTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_DYING);
    }

    public void setDyingAnimationTicks(int dyingAnimationTicks) {
        this.f_19804_.m_135381_(DATA_ID_DYING, (Object)dyingAnimationTicks);
    }

    public int getAlternativeTarget(int pHead) {
        return (Integer)this.f_19804_.m_135370_(DATA_TARGETS.get(pHead));
    }

    public void setAlternativeTarget(int pTargetOffset, int pNewId) {
        this.f_19804_.m_135381_(DATA_TARGETS.get(pTargetOffset), (Object)pNewId);
    }

    public boolean m_7090_() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22280_, 0.6);
    }

    public static class WaterAvoidingRandomFlyingGoal
    extends RandomStrollGoal {
        public WaterAvoidingRandomFlyingGoal(PathfinderMob pathfinderMob) {
            super(pathfinderMob, 2.0, 7);
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = this.f_25725_.m_20252_(0.0f);
            Vec3 vec31 = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)16, (int)14, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)6, (int)2);
            return vec31 != null ? vec31 : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.f_25725_, (int)16, (int)8, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }
}

