/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import insane96mcp.progressivebosses.module.wither.entity.PBWitherArmorLayer;
import insane96mcp.progressivebosses.module.wither.entity.PBWitherModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class PBWitherRenderer
extends MobRenderer<PBWither, PBWitherModel<PBWither>> {
    private static final ResourceLocation WITHER_CHARGING_LOCATION = new ResourceLocation("progressivebosses", "textures/entity/wither/wither_charge.png");
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_DYING_LOCATION = new ResourceLocation("textures/entity/wither/wither_dying.png");
    private static final ResourceLocation WITHER_LOCATION = new ResourceLocation("textures/entity/wither/wither.png");

    public PBWitherRenderer(EntityRendererProvider.Context context) {
        super(context, new PBWitherModel(context.m_174023_(ModelLayers.f_171214_)), 1.0f);
        this.m_115326_((RenderLayer)new PBWitherArmorLayer((RenderLayerParent<PBWither, PBWitherModel<PBWither>>)this, context.m_174027_()));
    }

    protected int getBlockLightLevel(PBWither pEntity, BlockPos pPos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(PBWither pEntity) {
        int d = pEntity.getDyingAnimationTicks();
        if (d > 0) {
            return WITHER_LOCATION;
        }
        int c = pEntity.getChargingTicks();
        if (c > 0) {
            return c < 30 || c > 50 && c % 10 < 5 || c < 50 && c % 4 >= 2 ? WITHER_CHARGING_LOCATION : WITHER_LOCATION;
        }
        int i = pEntity.getInvulnerableTicks();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? WITHER_INVULNERABLE_LOCATION : WITHER_LOCATION;
    }

    protected float getWhiteOverlayProgress(PBWither pLivingEntity, float pPartialTicks) {
        int d = pLivingEntity.getDyingAnimationTicks();
        if (d > 0) {
            return (float)(95 - pLivingEntity.getDyingAnimationTicks()) / 100.0f;
        }
        return super.m_6931_((LivingEntity)pLivingEntity, pPartialTicks);
    }

    protected boolean isShaking(PBWither pEntity) {
        return pEntity.getDyingAnimationTicks() > 0;
    }

    protected void scale(PBWither wither, PoseStack poseStack, float partialTick) {
        int dyingAnimationTicks;
        float scale;
        int barragingChargingTicks = wither.getBarrageChargeUpTicks();
        if (barragingChargingTicks > 0) {
            scale = 1.0f;
            scale += (30.0f - ((float)barragingChargingTicks - partialTick)) * 0.01f;
            if (barragingChargingTicks <= 5) {
                scale -= 0.059999995f * (5.0f - ((float)barragingChargingTicks - partialTick));
            }
            poseStack.m_85841_(scale, scale, scale);
        }
        scale = 2.0f;
        int invulnerableTicks = wither.getInvulnerableTicks();
        if (invulnerableTicks > 0) {
            scale -= ((float)invulnerableTicks - partialTick) / 220.0f * 0.5f;
        }
        if ((dyingAnimationTicks = wither.getDyingAnimationTicks()) > 0) {
            scale += (100.0f - ((float)dyingAnimationTicks - partialTick)) * 0.01f;
            if (dyingAnimationTicks <= 5) {
                scale -= (5.0f - ((float)dyingAnimationTicks - partialTick + 0.5f)) * 0.45f;
            }
        }
        poseStack.m_85841_(scale, scale, scale);
    }
}

