/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.network;

import insane96mcp.progressivebosses.module.dragon.DragonFeature;
import insane96mcp.progressivebosses.module.dragon.data.AngerComponent;
import insane96mcp.progressivebosses.network.ClientNetworkHandler;
import insane96mcp.progressivebosses.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SyncDragonAnger {
    int entityId;
    boolean isAngry;

    public SyncDragonAnger(int entityId, boolean isAngry) {
        this.entityId = entityId;
        this.isAngry = isAngry;
    }

    public static void encode(SyncDragonAnger pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.entityId);
        buf.writeBoolean(pkt.isAngry);
    }

    public static SyncDragonAnger decode(FriendlyByteBuf buf) {
        return new SyncDragonAnger(buf.readInt(), buf.readBoolean());
    }

    public static void handle(SyncDragonAnger message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.applyDragonAnger(message.entityId, message.isAngry));
        ctx.get().setPacketHandled(true);
    }

    public static void sync(ServerPlayer player, EnderDragon enderDragon) {
        boolean isAngry = DragonFeature.getDragonDefinition(enderDragon).flatMap(definition -> definition.getComponent(AngerComponent.class)).map(angerComponent -> AngerComponent.isAngered(enderDragon)).orElse(false);
        SyncDragonAnger msg = new SyncDragonAnger(enderDragon.m_19879_(), isAngry);
        NetworkHandler.CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

