package net.hederamc.gcd.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.hederamc.gr.registry.Registries;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_8828;
import net.hederamc.gcd.effect.CustomStatusEffect;
import net.hederamc.gcd.effect.CustomStatusEffectIdentifier;
import net.hederamc.gcd.effect.ServerCustomStatusEffectManager;
import net.hederamc.gcd.suggestion.CustomStatusEffectSuggestionProvider;

public class CustomCommand {
    private static final SimpleCommandExceptionType UNREGISTED_EXCEPTION =
        new SimpleCommandExceptionType(class_2561.method_43470("The effect is not registed."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247("custom")
            .then(
                class_2170.method_9247("effect")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9247("list")
                    .executes(context -> executeListEffect(context.getSource()))
                    .then(
                        class_2170.method_9244("entities", class_2186.method_9309())
                        .executes(context -> executeListEffect(context.getSource(), class_2186.method_9313(context, "entities")))
                    )
                )
                .then(
                    class_2170.method_9247("add")
                    .then(
                        class_2170.method_9244("entities", class_2186.method_9306())
                        .then(
                            class_2170.method_9244("effect", StringArgumentType.string())
                            .suggests(new CustomStatusEffectSuggestionProvider())
                            .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect")))
                            .then(
                                class_2170.method_9244("duration", IntegerArgumentType.integer(1))
                                .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), IntegerArgumentType.getInteger(context, "duration")))
                                .then(
                                    class_2170.method_9244("amplifier", IntegerArgumentType.integer(0))
                                    .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), IntegerArgumentType.getInteger(context, "duration"), IntegerArgumentType.getInteger(context, "amplifier")))
                                )
                            )
                            .then(
                                class_2170.method_9247("infinite")
                                .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), -1))
                                .then(
                                    class_2170.method_9244("amplifier", IntegerArgumentType.integer(0))
                                    .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), -1, IntegerArgumentType.getInteger(context, "amplifier")))
                                )
                            )
                        )
                    )
                )
                .then(
                    class_2170.method_9247("clear")
                    .executes(context -> executeClearEffect(context.getSource()))
                    .then(
                        class_2170.method_9244("entities", class_2186.method_9306())
                        .executes(context -> executeClearEffect(context.getSource(), class_2186.method_9317(context, "entities")))
                        .then(
                            class_2170.method_9244("effect", StringArgumentType.string())
                            .suggests(new CustomStatusEffectSuggestionProvider())
                            .executes(context -> executeClearEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect")))
                        )
                    )
                )
            )
            .then(
                class_2170.method_9247("reset")
                .executes(context -> executeReset(context.getSource()))
                .then(
                    class_2170.method_9247("effect")
                    .executes(context -> executeResetEffect(context.getSource()))
                )
            )
        );
    }

    public static int executeListEffect(class_2168 source) throws CommandSyntaxException {
        return executeListEffect(source, source.method_9229());
    }

    public static int executeListEffect(class_2168 source, class_1297 target) {
        if (!(target instanceof class_1309)) {
            return 0;
        }

        ServerCustomStatusEffectManager manager = ((class_1309)target).getCustomStatusEffectManager();

        if (manager.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470("The target does not have any custom status effect."), false);
        }

        class_5250 feedback = class_5250.method_43477(class_8828.field_46625);
        feedback.method_10852(class_2561.method_43470("The target has " + manager.size() + " status effects:"));

        ((class_1309)target).getCustomStatusEffectManager().values().forEach(playlist -> {
            feedback.method_10852(class_2561.method_43470("\n" + playlist.getId().getId().toString()).method_27692(class_124.field_1054));
            feedback.method_10852(class_2561.method_43470(" " + playlist.getActiveDuration()).method_27692(class_124.field_1060));
            feedback.method_10852(class_2561.method_43470(" " + playlist.getActiveAmplifier()).method_27692(class_124.field_1076));
            feedback.method_10852(class_2561.method_43470(" " + playlist.getId().getColor()).method_27692(class_124.field_1080));
        });

        source.method_9226(() -> feedback, false);
        return 0;
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect) throws CommandSyntaxException {
        return executeGiveEffect(source, targets, effect, 1, 0);
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect, int duration) throws CommandSyntaxException {
        return executeGiveEffect(source, targets, effect, duration, 0);
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect, int duration, int amplifier) throws CommandSyntaxException {
        CustomStatusEffectIdentifier effectId = Registries.get(CustomStatusEffectIdentifier.class, class_2960.method_60654(effect.replace('.', ':')));
        if (effectId == null) {
            UNREGISTED_EXCEPTION.create();
        }

        Iterator<? extends class_1297> iterator = targets.iterator();

        while (iterator.hasNext()) {
            class_1297 target = iterator.next();

            if (!(target instanceof class_1309)) {
                continue;
            }

            ((class_1309)target).addCustomStatusEffect(new CustomStatusEffect(effectId, duration, amplifier));
        }

        int count = targets.size();
        if (count == 1) {
            source.method_9226(() -> class_2561.method_43470("Applied effect " + effectId.getName() + " to ").method_10852(targets.iterator().next().method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470("Applied effect " + effectId.getName() + " to " + count + " targets."), true);
        }

        return 1;
    }

    public static int executeClearEffect(class_2168 source) throws CommandSyntaxException {
        return executeClearEffect(source, source.method_9229());
    }

    public static int executeClearEffect(class_2168 source, class_1297 target) {
        return executeClearEffect(source, List.of(target));
    }

    public static int executeClearEffect(class_2168 source, Collection<? extends class_1297> targets) {
        Iterator<? extends class_1297> iterator = targets.iterator();

        while (iterator.hasNext()) {
            class_1297 target = iterator.next();

            if (!(target instanceof class_1309)) {
                continue;
            }

            ((class_1309)target).clearCustomStatusEffect();
        }

        int count = targets.size();
        if (count == 1) {
            source.method_9226(() -> class_2561.method_43470("Removed every effect from ").method_10852(targets.iterator().next().method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470("Removed every effect from " + count + " targets."), true);
        }

        return 1;
    }

    public static int executeClearEffect(class_2168 source, Collection<? extends class_1297> targets, String effect) {
        CustomStatusEffectIdentifier effectId = Registries.get(CustomStatusEffectIdentifier.class, class_2960.method_60654(effect.replace('.', ':')));
        if (effectId == null) {
            UNREGISTED_EXCEPTION.create();
        }

        Iterator<? extends class_1297> iterator = targets.iterator();

        while (iterator.hasNext()) {
            class_1297 target = iterator.next();

            if (!(target instanceof class_1309)) {
                continue;
            }

            ((class_1309)target).removeCustomStatusEffect(effectId);
        }

        int count = targets.size();
        if (count == 1) {
            source.method_9226(() -> class_2561.method_43470("Removed effect " + effectId.getName() + " from ").method_10852(targets.iterator().next().method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470("Removed effect " + effectId.getName() + " from " + count + " targets."), true);
        }

        return 1;
    }

    public static int executeReset(class_2168 source) throws CommandSyntaxException {
        executeResetEffect(source);
        return 1;
    }

    public static int executeResetEffect(class_2168 source) throws CommandSyntaxException {
        source.method_9207().setCustomStatusEffects(new class_2487());
        return 1;
    }
}
