package net.hederamc.gcd.effect;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class CustomStatusEffectIdentifier {
    private class_2960 id;
    private String name;
    private int color;

    public CustomStatusEffectIdentifier(class_2960 id, String name, int color) {
        this.id = id;
        this.name = name;
        this.color = color;
    }

    public CustomStatusEffectPlaylist removeFrom(CustomStatusEffectManager manager) {
        return manager.remove(this);
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setId(class_2960 id) {
        this.id = id;
    }

    public CustomStatusEffectIdentifier withId(class_2960 id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomStatusEffectIdentifier withName(String name) {
        this.name = name;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int incrementColor() {
        return this.incrementColor(1);
    }

    public int incrementColor(int value) {
        this.setColor(this.color + value);
        return this.color;
    }

    public CustomStatusEffectIdentifier withColor(int color) {
        this.color = color;
        return this;
    }

    public boolean equals(CustomStatusEffectIdentifier id) {
        return this.id.equals(id.id) && this.color == id.color;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaStatusEffectIdentifier
     * 
     * @see #deepCopy()
     */
    public CustomStatusEffectIdentifier copy() {
        return new CustomStatusEffectIdentifier(this.id, this.name, this.color);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaStatusEffectIdentifier
     * 
     * @see #copy()
     */
    public CustomStatusEffectIdentifier deepCopy() {
        return new CustomStatusEffectIdentifier(class_2960.method_60655(this.id.method_12836(), this.id.method_12832()), this.name, this.color);
    }

    public static CustomStatusEffectIdentifier fromNbt(class_2487 nbtCompound) {
        return new CustomStatusEffectIdentifier(
            class_2960.method_60654(nbtCompound.method_68564("id", "")),
            nbtCompound.method_68564("name", ""),
            nbtCompound.method_68083("color", 0)
        );
    }

    public class_2487 toNbt() {
        return new class_2487(
            new HashMap<>(
                Map.<String, class_2520>of(
                    "id",
                    class_2519.method_23256(this.id.toString()),
                    "name",
                    class_2519.method_23256(this.name),
                    "color",
                    class_2497.method_23247(this.color)
                )
            )
        );
    }
}
