package net.hederamc.gcd.effect;

import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_2487;

/**
 * Tickable multi-id status effect container, with owner living entity.
 */
public final class ServerCustomStatusEffectManager extends CustomStatusEffectManager {
    private class_1309 entity;

    public ServerCustomStatusEffectManager(class_1309 entity, Map<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist> statusEffects) {
        super(statusEffects);
        this.entity = entity;
    }

    public ServerCustomStatusEffectManager(class_1309 entity, CustomStatusEffectManager manager) {
        this(entity, manager.statusEffects);
    }

    public ServerCustomStatusEffectManager(class_1309 entity, class_2487 nbtCompound) {
        this(entity, CustomStatusEffectManager.fromNbt(nbtCompound));
    }

    public ServerCustomStatusEffectManager(class_1309 entity) {
        this(entity, entity.getCustomStatusEffects());
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    public void setEntity(class_1309 entity) {
        this.entity = entity;
    }

    public ServerCustomStatusEffectManager withEntity(class_1309 entity) {
        this.setEntity(entity);
        return this;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ServerCustomStatusEffectManager
     * 
     * @see #deepCopy()
     */
    @Override
    public ServerCustomStatusEffectManager copy() {
        return new ServerCustomStatusEffectManager(this.entity, super.copy());
    }

    /**
     * A deep copy.
     * 
     * @return a new ServerCustomStatusEffectManager
     * 
     * @see #copy()
     */
    @Override
    public ServerCustomStatusEffectManager deepCopy() {
        return new ServerCustomStatusEffectManager(this.entity, super.deepCopy());
    }
}
