/*
 * Decompiled with CFR 0.152.
 */
package net.hederamc.gcd.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.List;
import net.hederamc.gcd.effect.CustomStatusEffect;
import net.hederamc.gcd.effect.CustomStatusEffectIdentifier;
import net.hederamc.gcd.effect.ServerCustomStatusEffectManager;
import net.hederamc.gcd.suggestion.CustomStatusEffectSuggestionProvider;
import net.hederamc.gr.registry.Registries;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class CustomCommand {
    private static final SimpleCommandExceptionType UNREGISTED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"The effect is not registed."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"custom").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"effect").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(context -> CustomCommand.executeListEffect((class_2168)context.getSource()))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9309()).executes(context -> CustomCommand.executeListEffect((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entities")))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"effect", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CustomStatusEffectSuggestionProvider()).executes(context -> CustomCommand.executeGiveEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), StringArgumentType.getString((CommandContext)context, (String)"effect")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CustomCommand.executeGiveEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), StringArgumentType.getString((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration")))).then(class_2170.method_9244((String)"amplifier", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CustomCommand.executeGiveEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), StringArgumentType.getString((CommandContext)context, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amplifier")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"infinite").executes(context -> CustomCommand.executeGiveEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), StringArgumentType.getString((CommandContext)context, (String)"effect"), -1))).then(class_2170.method_9244((String)"amplifier", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CustomCommand.executeGiveEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), StringArgumentType.getString((CommandContext)context, (String)"effect"), -1, IntegerArgumentType.getInteger((CommandContext)context, (String)"amplifier"))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(context -> CustomCommand.executeClearEffect((class_2168)context.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> CustomCommand.executeClearEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities")))).then(class_2170.method_9244((String)"effect", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CustomStatusEffectSuggestionProvider()).executes(context -> CustomCommand.executeClearEffect((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), StringArgumentType.getString((CommandContext)context, (String)"effect")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(context -> CustomCommand.executeReset((class_2168)context.getSource()))).then(class_2170.method_9247((String)"effect").executes(context -> CustomCommand.executeResetEffect((class_2168)context.getSource())))));
    }

    public static int executeListEffect(class_2168 source) throws CommandSyntaxException {
        return CustomCommand.executeListEffect(source, source.method_9229());
    }

    public static int executeListEffect(class_2168 source, class_1297 target) {
        if (!(target instanceof class_1309)) {
            return 0;
        }
        ServerCustomStatusEffectManager manager = ((class_1309)target).getCustomStatusEffectManager();
        if (manager.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"The target does not have any custom status effect."), false);
        }
        class_5250 feedback = class_5250.method_43477((class_7417)class_8828.field_46625);
        feedback.method_10852((class_2561)class_2561.method_43470((String)("The target has " + manager.size() + " status effects:")));
        ((class_1309)target).getCustomStatusEffectManager().values().forEach(playlist -> {
            feedback.method_10852((class_2561)class_2561.method_43470((String)("\n" + playlist.getId().getId().toString())).method_27692(class_124.field_1054));
            feedback.method_10852((class_2561)class_2561.method_43470((String)(" " + playlist.getActiveDuration())).method_27692(class_124.field_1060));
            feedback.method_10852((class_2561)class_2561.method_43470((String)(" " + playlist.getActiveAmplifier())).method_27692(class_124.field_1076));
            feedback.method_10852((class_2561)class_2561.method_43470((String)(" " + playlist.getId().getColor())).method_27692(class_124.field_1080));
        });
        source.method_9226(() -> feedback, false);
        return 0;
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect) throws CommandSyntaxException {
        return CustomCommand.executeGiveEffect(source, targets, effect, 1, 0);
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect, int duration) throws CommandSyntaxException {
        return CustomCommand.executeGiveEffect(source, targets, effect, duration, 0);
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect, int duration, int amplifier) throws CommandSyntaxException {
        CustomStatusEffectIdentifier effectId = (CustomStatusEffectIdentifier)Registries.get(CustomStatusEffectIdentifier.class, (class_2960)class_2960.method_60654((String)effect.replace('.', ':')));
        if (effectId == null) {
            UNREGISTED_EXCEPTION.create();
        }
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            ((class_1309)class_12972).addCustomStatusEffect(new CustomStatusEffect(effectId, duration, amplifier));
        }
        int n = targets.size();
        if (n == 1) {
            source.method_9226(() -> class_2561.method_43470((String)("Applied effect " + effectId.getName() + " to ")).method_10852(((class_1297)targets.iterator().next()).method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Applied effect " + effectId.getName() + " to " + count + " targets.")), true);
        }
        return 1;
    }

    public static int executeClearEffect(class_2168 source) throws CommandSyntaxException {
        return CustomCommand.executeClearEffect(source, source.method_9229());
    }

    public static int executeClearEffect(class_2168 source, class_1297 target) {
        return CustomCommand.executeClearEffect(source, List.of(target));
    }

    public static int executeClearEffect(class_2168 source, Collection<? extends class_1297> targets) {
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            ((class_1309)class_12972).clearCustomStatusEffect();
        }
        int n = targets.size();
        if (n == 1) {
            source.method_9226(() -> class_2561.method_43470((String)"Removed every effect from ").method_10852(((class_1297)targets.iterator().next()).method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Removed every effect from " + count + " targets.")), true);
        }
        return 1;
    }

    public static int executeClearEffect(class_2168 source, Collection<? extends class_1297> targets, String effect) {
        CustomStatusEffectIdentifier effectId = (CustomStatusEffectIdentifier)Registries.get(CustomStatusEffectIdentifier.class, (class_2960)class_2960.method_60654((String)effect.replace('.', ':')));
        if (effectId == null) {
            UNREGISTED_EXCEPTION.create();
        }
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            ((class_1309)class_12972).removeCustomStatusEffect(effectId);
        }
        int n = targets.size();
        if (n == 1) {
            source.method_9226(() -> class_2561.method_43470((String)("Removed effect " + effectId.getName() + " from ")).method_10852(((class_1297)targets.iterator().next()).method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Removed effect " + effectId.getName() + " from " + count + " targets.")), true);
        }
        return 1;
    }

    public static int executeReset(class_2168 source) throws CommandSyntaxException {
        CustomCommand.executeResetEffect(source);
        return 1;
    }

    public static int executeResetEffect(class_2168 source) throws CommandSyntaxException {
        source.method_9207().setCustomStatusEffects(new class_2487());
        return 1;
    }
}

