/*
 * Decompiled with CFR 0.152.
 */
package net.hederamc.gcd.effect;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.hederamc.gcd.effect.CustomStatusEffect;
import net.hederamc.gcd.effect.CustomStatusEffectIdentifier;
import net.hederamc.gcd.effect.CustomStatusEffectPlaylist;
import net.hederamc.gr.registry.Registries;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomStatusEffectManager {
    protected final Map<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist> statusEffects;

    public CustomStatusEffectManager(Map<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist> statusEffects) {
        this.statusEffects = statusEffects;
    }

    public CustomStatusEffectManager() {
        this.statusEffects = new HashMap<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist>();
    }

    public int getActiveAmplifier(CustomStatusEffectIdentifier id) {
        CustomStatusEffectPlaylist playlist = this.get(id);
        if (playlist == null) {
            return -1;
        }
        return playlist.getActiveAmplifier();
    }

    public int getActiveDuration(CustomStatusEffectIdentifier id) {
        CustomStatusEffectPlaylist playlist = this.get(id);
        if (playlist == null) {
            return -1;
        }
        return playlist.getActiveDuration();
    }

    public boolean add(CustomStatusEffect statusEffect) {
        return this.getOrPut(statusEffect.getId()).add(statusEffect);
    }

    public boolean set(CustomStatusEffect statusEffect) {
        CustomStatusEffectPlaylist playlist = this.getOrPut(statusEffect.getId());
        playlist.clear();
        return playlist.add(statusEffect);
    }

    public void tick() {
        Iterator<CustomStatusEffectPlaylist> iterator = this.values().iterator();
        while (iterator.hasNext()) {
            CustomStatusEffectPlaylist playlist = iterator.next();
            playlist.tick();
            if (!playlist.isEmpty()) continue;
            iterator.remove();
        }
    }

    public Map<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist> getStatusEffects() {
        return this.statusEffects;
    }

    public int size() {
        return this.statusEffects.size();
    }

    public boolean isEmpty() {
        return this.statusEffects.isEmpty();
    }

    public boolean containsKey(CustomStatusEffectIdentifier id) {
        return this.statusEffects.containsKey(id);
    }

    public boolean containsValue(CustomStatusEffectPlaylist playlist) {
        return this.statusEffects.containsValue(playlist);
    }

    public Set<Map.Entry<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist>> entrySet() {
        return this.statusEffects.entrySet();
    }

    public Set<CustomStatusEffectIdentifier> keySet() {
        return this.statusEffects.keySet();
    }

    public Collection<CustomStatusEffectPlaylist> values() {
        return this.statusEffects.values();
    }

    @Nullable
    public CustomStatusEffectPlaylist get(CustomStatusEffectIdentifier id) {
        return this.statusEffects.get(id);
    }

    public CustomStatusEffectPlaylist getOrPut(CustomStatusEffectIdentifier id, CustomStatusEffectPlaylist playlist) {
        CustomStatusEffectPlaylist playlist2 = this.get(id);
        if (playlist2 != null) {
            return playlist2;
        }
        this.put(id, playlist);
        return playlist;
    }

    public CustomStatusEffectPlaylist getOrPut(CustomStatusEffectIdentifier id) {
        return this.getOrPut(id, new CustomStatusEffectPlaylist());
    }

    public CustomStatusEffectPlaylist put(CustomStatusEffectIdentifier id, CustomStatusEffectPlaylist playlist) {
        return this.statusEffects.put(id, playlist);
    }

    public void putAll(Map<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist> playlists) {
        this.statusEffects.putAll(playlists);
    }

    public CustomStatusEffectPlaylist remove(CustomStatusEffectIdentifier id) {
        return this.statusEffects.remove(id);
    }

    public boolean remove(CustomStatusEffectIdentifier id, CustomStatusEffectPlaylist playlist) {
        return this.statusEffects.remove(id, playlist);
    }

    public void clear() {
        this.statusEffects.clear();
    }

    public CustomStatusEffectPlaylist replace(CustomStatusEffectIdentifier id, CustomStatusEffectPlaylist playlist) {
        return this.statusEffects.replace(id, playlist);
    }

    public boolean replace(CustomStatusEffectIdentifier id, CustomStatusEffectPlaylist oldPlaylist, CustomStatusEffectPlaylist newPlaylist) {
        return this.statusEffects.replace(id, oldPlaylist, newPlaylist);
    }

    public void replaceAll(BiFunction<CustomStatusEffectIdentifier, CustomStatusEffectPlaylist, CustomStatusEffectPlaylist> function) {
        this.statusEffects.replaceAll(function);
    }

    public CustomStatusEffectManager copy() {
        return new CustomStatusEffectManager(this.statusEffects);
    }

    public CustomStatusEffectManager deepCopy() {
        return new CustomStatusEffectManager(this.entrySet().stream().map(entry -> Map.entry(((CustomStatusEffectIdentifier)entry.getKey()).deepCopy(), ((CustomStatusEffectPlaylist)entry.getValue()).deepCopy())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static CustomStatusEffectManager fromNbt(class_2487 nbtCompound) {
        return new CustomStatusEffectManager(nbtCompound.method_59874().stream().map(entry -> Map.entry((CustomStatusEffectIdentifier)Registries.get(CustomStatusEffectIdentifier.class, (class_2960)class_2960.method_60654((String)((String)entry.getKey()))), CustomStatusEffectPlaylist.fromNbt((class_2499)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public class_2487 toNbt() {
        return this.entrySet().stream().map(entry -> Map.entry(((CustomStatusEffectIdentifier)entry.getKey()).getId().toString(), ((CustomStatusEffectPlaylist)entry.getValue()).toNbt())).collect(class_2487::new, (nbtCompound, entry) -> nbtCompound.method_10566((String)entry.getKey(), (class_2520)entry.getValue()), (left, right) -> left.putAll(right));
    }
}

