package mods.thecomputerizer.theimpossiblelibrary.api.client.event.types;

import lombok.Getter;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.ClientEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;


import java.util.Objects;

@Getter
public abstract class ClientRenderEventType<E> extends ClientEventWrapper<E> {

    protected RenderContext renderer;

    protected ClientRenderEventType(ClientType<?> type) {
        super(type);
    }
    
    @IndirectCallers
    public float getPartialTicks() {
        return Objects.nonNull(this.renderer) ? this.renderer.getPartialTicks() : 0f;
    }

    protected abstract RenderContext initRenderer(E event);

    @Override protected void populate() {
        this.renderer = Objects.nonNull(this.event) ? initRenderer(this.event) : null;
    }
}
