package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import lombok.Setter;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SuppressWarnings("unused")
public abstract class AnchoredGeometry {

    private final List<ShapeHolder> freeShapeRenders;
    private final List<Column> columnRenders;
    @Setter private Vector3 renderVec;

    public AnchoredGeometry(Vector3 renderVec) {
        this.freeShapeRenders = new ArrayList<>();
        this.columnRenders = new ArrayList<>();
        this.renderVec = renderVec;
    }

    public void addColumn(Column column) {
        this.columnRenders.add(column);
    }

    public void addFreeShape(ShapeHolder holder) {
        this.freeShapeRenders.add(holder);
    }

    public void setRenderXZ(double x, double z) {
        this.renderVec = new Vector3(x,this.renderVec.dY(),z);
    }

    public abstract boolean canRender();

    public abstract Vector3 getRenderPos(float partialTicks);

    public void render(RenderContext ctx, float partialTicks) {
        if(canRender()) {
            Vector3 renderAt = this.renderVec.sub(getRenderPos(partialTicks));
            Iterator<Column> columnItr = this.columnRenders.iterator();
            while(columnItr.hasNext()) {
                Column column = columnItr.next();
                if(column instanceof ITickableGeometry && !((ITickableGeometry<?>)column).isInitialized())
                    columnItr.remove();
                else column.render(ctx,renderAt);
            }
            Iterator<ShapeHolder> holderItr = this.freeShapeRenders.iterator();
            while(holderItr.hasNext()) {
                ShapeHolder holder = holderItr.next();
                if(holder instanceof ITickableGeometry && !((ITickableGeometry<?>)holder).isInitialized())
                    holderItr.remove();
                else holder.render(ctx,renderAt);
            }
        }
    }

    public boolean isEmpty() {
        return this.columnRenders.isEmpty() && this.freeShapeRenders.isEmpty();
    }
}
