package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import lombok.Getter;
import lombok.Setter;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

import java.util.Objects;
import java.util.function.Supplier;

import static mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper.WHITE;

@Getter @Setter
public class RenderFuzz extends RenderShape {
    
    public static RenderFuzz from(Shape shape) {
        return from(shape,2,10,1f,1f,null);
    }
    
    public static RenderFuzz from(Shape shape, int max) {
        return from(shape,2,max,1f,1f,null);
    }
    
    public static RenderFuzz from(Shape shape, Vector2 counts) {
        return from(shape,counts.iX(),counts.iY(),1f,1f,null);
    }
    
    public static RenderFuzz from(Shape shape, int minCount, int maxCount) {
        return from(shape,minCount,maxCount,1f,1f,null);
    }
    
    public static RenderFuzz from(Shape shape, Vector2 counts, Vector2 widths) {
        return from(shape,counts.iX(),counts.iY(),widths.fX(),widths.fY(),null);
    }
    
    public static RenderFuzz from(Shape shape, int minCount, int maxCount, float minWidth, float maxWidth) {
        return from(shape,minCount,maxCount,minWidth,maxWidth,null);
    }
    
    public static RenderFuzz from(Shape shape, Vector2 counts, Vector2 widths, Supplier<ColorCache> color) {
        return from(shape,counts.iX(),counts.iY(),widths.fX(),widths.fY(),color);
    }
    
    public static RenderFuzz from(Shape shape, int minCount, int maxCount, float minWidth, float maxWidth,
            Supplier<ColorCache> color) {
        maxCount = Math.max(3,maxCount);
        minCount = Math.max(2,minCount);
        if(minCount>maxCount) minCount = maxCount;
        minWidth = Math.max(0.1f,minWidth);
        maxWidth = Math.min(10f,maxWidth);
        if(minWidth>maxWidth) minWidth = maxWidth;
        return new RenderFuzz(shape,minCount,maxCount,minWidth,maxWidth,color);
    }
    
    protected FuzzBall fuzz;
    
    public RenderFuzz(Shape shape, int minCount, int maxCount, float minWidth, float maxWidth,
            Supplier<ColorCache> color) {
        super(shape,WHITE);
        this.fuzz = shape.makeFuzzBall(minCount,maxCount,minWidth,maxWidth,color);
    }
    
    public RenderFuzz copy() {
        RenderFuzz fuzz = (RenderFuzz)super.copy();
        fuzz.fuzz = Objects.nonNull(this.fuzz) ? this.fuzz.copy() : null;
        return fuzz;
    }
    
    public void draw(RenderContext ctx, Vector3 center) {
        if(Objects.nonNull(this.fuzz)) {
            RenderAPI renderer = ctx.getRenderer();
            renderer.translate(0d,0d,-10d);
            this.fuzz.draw(ctx,center);
            renderer.translate(0d,0d,10d);
        }
    }
}