package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.common.blockentity;

import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.PosHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.tag.CompoundTag1_12_2;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class BlockEntity1_12_2 extends BlockEntityAPI<TileEntity,Class<? extends TileEntity>> {
    
    /**
     * Assumes the input object will never be null
     */
    public static BlockEntity1_12_2 entity(Object tile) {
        return new BlockEntity1_12_2(tile,tile.getClass());
    }
    
    /**
     * Assumes the input object will never be null
     */
    public static BlockEntity1_12_2 get(Object obj) {
        return obj instanceof TileEntity ? entity(obj) : type(obj);
    }
    
    /**
     * Assumes the input object will never be null
     */
    public static BlockEntity1_12_2 type(Object type) {
        return new BlockEntity1_12_2(null,type);
    }
    
    private BlockEntity1_12_2(@Nullable Object tile, Object tileClass) {
        super(tile,tileClass);
        this.registryName = WrapperHelper.wrapResourceLocation(TileEntity.getKey(this.wrapped));
    }

    @Override public RegistryAPI<?> getRegistry() {
        return RegistryHelper.getBlockEntityRegistry();
    }
    
    @Override public BlockPosAPI<?> getPos() {
        return PosHelper.getPos(this.entity.getPos());
    }

    @Override public WorldAPI<World> getWorld() {
        return WrapperHelper.wrapWorld(this.entity.getWorld());
    }
    
    @Override public CompoundTagAPI<?> readTagFrom() {
        return new CompoundTag1_12_2(Objects.nonNull(this.entity) ? this.entity.serializeNBT() : new NBTTagCompound());
    }
    
    @Override public void setRegistryName(ResourceLocationAPI<?> registryName) {
        setLocalRegistryName(registryName);
    }
    
    @Override public void writeTagTo(CompoundTagAPI<?> tag) {
        if(Objects.nonNull(this.entity)) this.entity.writeToNBT(tag.unwrap());
    }
}
