package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core;

import mods.thecomputerizer.theimpossiblelibrary.api.core.*;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.asm.ModContainerWriter1_12_2;
import net.minecraftforge.fml.common.*;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.*;
import java.util.Map.Entry;

import static net.minecraft.launchwrapper.Launch.classLoader;
import static net.minecraftforge.fml.common.discovery.ContainerType.JAR;

public class InjectedModCandidate1_12_2 extends ModCandidate {

    private static Map<String,MultiVersionModData> DATA_MAP;
    private static Map<File,InjectedModCandidate1_12_2> CANDIDATE_MAP;

    public static ModContainer findModContainer(String modid) {
        InjectedModCandidate1_12_2 candidate = getCandidate(modid);
        return Objects.nonNull(candidate) ? candidate.containerMap.get(modid).container : null;
    }

    public static File findSource(String modid) {
        MultiVersionModData data = getModData(modid);
        return Objects.nonNull(data) ? data.getSource() : null;
    }

    private static @Nullable MultiVersionModData getModData(String modid) {
        Map<String,MultiVersionModData> map = getModData();
        return Objects.nonNull(map) ? map.get(modid) : null;
    }

    private static Map<String,MultiVersionModData> getModData() {
        if(Objects.nonNull(DATA_MAP)) return DATA_MAP;
        File root = Hacks.getFieldStaticDirect(Loader.class,"minecraftDir");
        DATA_MAP = CoreAPI.getInstance().getModData(root);
        return DATA_MAP;
    }

    private static Collection<MultiVersionModData> getModDataValues() {
        Map<String,MultiVersionModData> map = getModData();
        return Objects.nonNull(map) ? map.values() : Collections.emptyList();
    }

    private static @Nullable InjectedModCandidate1_12_2 getCandidate(String modid) {
        Map<File,InjectedModCandidate1_12_2> map = getCandidateMap();
        MultiVersionModData data = getModData(modid);
        return Objects.nonNull(map) && Objects.nonNull(data) && Objects.nonNull(data.getSource()) ?
                map.get(data.getSource()) : null;
    }

    private static Map<File,InjectedModCandidate1_12_2> getCandidateMap() {
        if(Objects.nonNull(CANDIDATE_MAP)) return CANDIDATE_MAP;
        boolean java8 = JVMHelper.isJava8();
        CodeSource source = null;
        if(!java8) {
            ProtectionDomain pd = InjectedModCandidate1_12_2.class.getProtectionDomain();
            source = Objects.nonNull(pd) ? pd.getCodeSource() : null;
        }
        CANDIDATE_MAP = new HashMap<>();
        for(MultiVersionModData data : getModDataValues()) {
            CANDIDATE_MAP.putIfAbsent(data.getSource(),new InjectedModCandidate1_12_2(
                    data.getRoot(),data.getSource()));
            for(Entry<String,byte[]> classBytes : data.writeModClass()) {
                String className = classBytes.getKey();
                byte[] bytes = classBytes.getValue();
                ASMHelper.writeDebugByteCode(className,bytes);
                Class<?> clazz = java8 ? ClassHelper.defineClass(classLoader,className,bytes) :
                        Hacks.invoke(classLoader,"defineClass",className,bytes,source);
                ModContainerWriter1_12_2.cacheClass(classLoader,className,clazz);
                InjectedModCandidate1_12_2 candidate = CANDIDATE_MAP.get(data.getSource());
                candidate.injectMod(data.getInfo(),className,bytes);
                TILRef.logInfo("Successfully loaded mod class {}!",className);
            }
        }
        return CANDIDATE_MAP;
    }

    private static Collection<InjectedModCandidate1_12_2> getCandidateValues() {
        Map<File,InjectedModCandidate1_12_2> map = getCandidateMap();
        return Objects.nonNull(map) ? map.values() : Collections.emptyList();
    }

    public static boolean injectIntoTable(ModContainer container, String pkgName, ASMDataTable table) {
        Collection<InjectedModCandidate1_12_2> candidates = getCandidateValues();
        TILDev.logDebug("Checking injection for {} possible mod candidates",candidates.size());
        for(InjectedModCandidate1_12_2 candidate : candidates)
            if(candidate.appendToTable(container,pkgName,table)) return true;
        return false;
    }

    private final Map<String,ContainerData> containerMap;

    private InjectedModCandidate1_12_2(File root, File source) {
        super(root,source,JAR);
        this.containerMap = new HashMap<>();
    }

    private void addContainer(ModContainer container) {
        List<ModContainer> mods = Hacks.getFieldDirect(this,"mods");
        if(Objects.nonNull(mods)) mods.add(container);
        else Hacks.setFieldDirect(this,"mods",new ArrayList<>(Collections.singletonList(container)));
    }

    private boolean appendToTable(ModContainer container, String pkgName, ASMDataTable table) {
        TILDev.logDebug("Iterating over {} possible containers to check for type {}",
                        this.containerMap.size(), container.getClass());
        for(ContainerData data : this.containerMap.values()) {
            TILDev.logDebug("Stored container is type {}",data.container.getClass());
            if(data.container==container) {
                TILDev.logDebug("Found container! Sending its data to the ASMDataTable.");
                data.parser.sendToTable(table,this);
                table.addContainer(container);
                table.registerPackage(this,pkgName);
                //Fixes @SidedProxy check breaking
                if(Objects.nonNull(Hacks.getFieldDirect(table,"containerAnnotationData")))
                    Hacks.setFieldDirect(table,"containerAnnotationData",null);
                return true;
            }
        }
        return false;
    }

    public void injectMod(MultiVersionModInfo info, String classpath, byte[] bytes) {
        try {
            ASMModParser parser = new ASMModParser(new ByteArrayInputStream(bytes));
            parser.validate();
            ModContainer container = ModContainerFactory.instance().build(parser,getModContainer(),this);
            if(Objects.nonNull(container)) {
                Entry<String,String> pkgPair = ClassPrinter.splitPackage(classpath);
                getClassList().add(pkgPair.getKey());
                addContainer(container);
                getContainedPackages().add(pkgPair.getValue());
                container.bindMetadata(new InjectedMetaDataCollection(info));
                container.setClassVersion(parser.getClassVersion());
                this.containerMap.put(info.getModID(),new ContainerData(container,parser));
            }
        } catch(IOException ex) {
            TILRef.logError("Failed to parse candidate mod class `{}`",classpath,ex);
        }
    }

    private static final class InjectedMetaDataCollection extends MetadataCollection {

        final MultiVersionModInfo info;

        InjectedMetaDataCollection(MultiVersionModInfo info) {
            this.info = info;
        }

        @Override public ModMetadata getMetadataForId(String modId, Map<String,Object> extraData) {
            ModMetadata meta = new ModMetadata();
            meta.modId = this.info.getModID();
            meta.name = this.info.getName();
            meta.version = this.info.getVersion();
            meta.logoFile = "logo.png";
            return meta;
        }
    }

    private static final class ContainerData {

        final ModContainer container;
        final ASMModParser parser;

        ContainerData(ModContainer container, ASMModParser parser) {
            this.container = container;
            this.parser = parser;
        }
    }
}