package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.world;

import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.common.structure.StructureRef;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;

import static net.minecraft.world.EnumSkyBlock.BLOCK;
import static net.minecraft.world.EnumSkyBlock.SKY;

public class World1_12_2 extends WorldAPI<World> {

    public World1_12_2(Object world) {
        super(world);
    }

    @Override public boolean canSnowAt(BlockPosAPI<?> pos) {
        return getIfNotNullOrDefault(w -> w.canSnowAt(pos.unwrap(),false),false);
    }

    @Override public BiomeAPI<?> getBiomeAt(BlockPosAPI<?> pos) {
        return getIfNotNull(w -> WrapperHelper.wrapBiome(w.getBiome(pos.unwrap())));
    }

    @Override public Collection<BlockEntityAPI<?,?>> getBlockEntitiesInBox(Box box) {
        List<BlockEntityAPI<?,?>> entities = new ArrayList<>();
        if(Objects.nonNull(this.wrapped)) {
            synchronized(this.wrapped) {
                for(TileEntity tile : this.wrapped.loadedTileEntityList) {
                    BlockPos pos = tile.getPos();
                    if(box.isInside(pos.getX(),pos.getY(),pos.getZ()))
                        entities.add(WrapperHelper.wrapBlockEntity(tile));
                }
            }
        }
        return entities;
    }

    @Override public @Nullable BlockEntityAPI<?,?> getBlockEntityAt(BlockPosAPI<?> pos) {
        TileEntity tile = getIfNotNull(w -> w.getTileEntity(pos.unwrap()));
        return Objects.nonNull(tile) ? WrapperHelper.wrapBlockEntity(tile) : null;
    }

    @Override public int getDayNumber() {
        return (int)((double)getTimeTotal()/24000d);
    }

    @Override public int getDifficultyOrdinal() {
        if(Objects.isNull(this.wrapped)) return -1;
        if(this.wrapped.getWorldInfo().isHardcoreModeEnabled()) return 4;
        switch(this.wrapped.getDifficulty()) {
            case PEACEFUL: return 0;
            case EASY: return 1;
            case NORMAL: return 2;
            case HARD: return 3;
            default: return -1; //unreachable
        }
    }

    @Override public DimensionAPI<?> getDimension() {
        return getIfNotNull(w -> WrapperHelper.wrapDimension(this,w.provider.getDimensionType()));
    }

    @Override public List<EntityAPI<?,?>> getEntitiesInBox(Box box) {
        return getEntitiesInBox(new AxisAlignedBB(box.min.dX(),box.min.dY(),box.min.dZ(),box.max.dX(),box.max.dY(),box.max.dZ()));
    }

    public List<EntityAPI<?,?>> getEntitiesInBox(AxisAlignedBB box) {
        if(Objects.isNull(this.wrapped)) return Collections.emptyList();
        List<EntityAPI<?,?>> entities = new ArrayList<>();
        for(Entity entity : this.wrapped.getEntitiesWithinAABB(Entity.class,box))
            entities.add(WrapperHelper.wrapEntity(entity));
        return entities;
    }

    @Override public int getLightBlock(BlockPosAPI<?> pos) {
        return getIfNotNullOrDefault(w -> w.getLightFor(BLOCK,pos.unwrap()),0);
    }

    @Override public int getLightSky(BlockPosAPI<?> pos) {
        return getIfNotNullOrDefault(w -> w.getLightFor(SKY,pos.unwrap()),0);
    }

    @Override public int getLightTotal(BlockPosAPI<?> pos) {
        return getIfNotNullOrDefault(w -> w.getLight(pos.unwrap()),0);
    }

    @Override public List<LivingEntityAPI<?,?>> getLivingInBox(Box box) {
        if(Objects.isNull(this.wrapped)) return Collections.emptyList();
        return getLivingInBox(new AxisAlignedBB(
                box.min.dX(),box.min.dY(),box.min.dZ(),box.max.dX(),box.max.dY(),box.max.dZ()));
    }

    public List<LivingEntityAPI<?,?>> getLivingInBox(AxisAlignedBB box) {
        if(Objects.isNull(this.wrapped)) return Collections.emptyList();
        List<LivingEntityAPI<?,?>> entities = new ArrayList<>();
        for(EntityLivingBase entity : this.wrapped.getEntitiesWithinAABB(EntityLivingBase.class,box))
            entities.add(WrapperHelper.wrapLivingEntity(entity));
        return entities;
    }

    @Override public int getMoonPhase() {
        return getIfNotNullOrDefault(World::getMoonPhase,0);
    }
    
    @Override public @Nullable String getRaidStatus(BlockPosAPI<?> pos) {
        return null;
    }
    
    @Override public int getRaidWave(BlockPosAPI<?> pos) {
        return -1;
    }
    
    @Override public BlockStateAPI<?> getStateAt(BlockPosAPI<?> pos) {
        return getIfNotNull(w -> WrapperHelper.wrapState(w.getBlockState(pos.unwrap())));
    }

    @Override public StructureAPI<?> getStructureAt(BlockPosAPI<?> pos) {
        if(this.wrapped instanceof WorldServer) {
            StructureRef ref = StructureRef.getStructureAt((WorldServer)this.wrapped,pos.unwrap());
            return Objects.nonNull(ref) ? WrapperHelper.wrapStructure(ref) : null;
        }
        return null;
    }

    @Override public long getTimeDay() {
        return getTimeTotal()%24000L;
    }

    @Override public long getTimeTotal() {
        return getIfNotNullOrDefault(World::getWorldTime,0L);
    }

    @Override public boolean isClient() {
        return getIfNotNullOrDefault(w -> w.isRemote,false);
    }

    @Override public boolean isDaytime() {
        return getTimeDay()<13000L;
    }

    @Override public boolean isRaining() {
        return getIfNotNullOrDefault(World::isRaining,false);
    }

    @Override public boolean isSkyVisible(BlockPosAPI<?> pos) {
        return getIfNotNullOrDefault(w -> w.canBlockSeeSky(pos.unwrap()),false);
    }

    @Override public boolean isStorming() {
        return getIfNotNullOrDefault(World::isThundering,false);
    }

    @Override public boolean isSunrise() {
        return getTimeDay()>=23000L;
    }

    @Override public boolean isSunset() {
        long time = getTimeDay();
        return time>=12000L && time<13000L;
    }
    
    @Override public void setState(BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        if(Objects.nonNull(this.wrapped)) this.wrapped.setBlockState(pos.unwrap(),state.unwrap());
    }
    
    @Override public void spawnEntity(EntityAPI<?,?> entity, @Nullable Consumer<EntityAPI<?,?>> onSpawn) {
        if(Objects.nonNull(this.wrapped) && !this.wrapped.isRemote) {
            this.wrapped.spawnEntity(entity.unwrapEntity());
            if(Objects.nonNull(onSpawn)) onSpawn.accept(entity);
        }
    }
    
    @Override public void spawnItem(ItemStackAPI<?> stack, Vector3 pos, @Nullable Consumer<EntityAPI<?,?>> onSpawn) {
        if(Objects.nonNull(this.wrapped) && !this.wrapped.isRemote) {
            EntityItem item = new EntityItem(this.wrapped,pos.dX(),pos.dY(),pos.dZ(),stack.unwrap());
            item.setDefaultPickupDelay();
            spawnEntity(WrapperHelper.wrapEntity(item),onSpawn);
        }
    }
    
    @Override public void spawnItem(ItemAPI<?> api, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn,
            @Nullable Consumer<EntityAPI<?,?>> onSpawn) {
        if(Objects.nonNull(this.wrapped) && !this.wrapped.isRemote) {
            ItemStackAPI<?> stack = WrapperHelper.wrapItemStack(new ItemStack((Item)api.unwrap()));
            if(Objects.nonNull(beforeSpawn)) beforeSpawn.accept(stack);
            spawnItem(stack,pos,onSpawn);
        }
    }
}