package mods.thecomputerizer.theimpossiblelibrary.shared.v16.m5.world;

import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import net.minecraft.core.BlockPos;

public class BlockPos1_16_5 extends BlockPosAPI<BlockPos> {
    
    public static BlockPos1_16_5 get(Object obj) {
        return obj instanceof BlockPos ? pos(obj) : vec(obj);
    }
    
    public static BlockPos1_16_5 pos(Object pos) {
        return new BlockPos1_16_5((BlockPos)pos);
    }
    
    public static BlockPos1_16_5 vec(Object pos) {
        return new BlockPos1_16_5((Vector3)pos);
    }

    public BlockPos1_16_5(BlockPos pos) {
        this(pos,new Vector3(pos.getX(),pos.getY(),pos.getZ()));
    }

    public BlockPos1_16_5(Vector3 posVec) {
        this(new BlockPos(posVec.dX(),posVec.dY(),posVec.dZ()),posVec);
    }

    private BlockPos1_16_5(BlockPos pos, Vector3 posVec) {
        super(pos,posVec);
    }

    @Override public BlockPosAPI<?> add(BlockPos pos) {
        return add(pos.getX(),pos.getY(),pos.getZ());
    }

    @Override public BlockPosAPI<?> add(int x, int y, int z) {
        BlockPos newPos = this.wrapped.offset(x,y,z);
        return newPos==this.wrapped ? this : new BlockPos1_16_5(newPos);
    }
}