package mods.thecomputerizer.theimpossiblelibrary.shared.v19.m4.registry;

import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class RegistryVanilla1_19_4<V> extends Registry1_19_4<V> {

    public RegistryVanilla1_19_4(Registry<V> registry, ResourceLocationAPI<?> registryKey, Class<?> type) {
        super(registry,GenericUtils.cast(type),registryKey);
    }
    
    @SuppressWarnings("unchecked")
    @Override public Registry<V> getBackend() {
        return super.getBackend();
    }
    
    @Override public ResourceLocationAPI<?> getKey(V value) {
        return WrapperHelper.wrapResourceLocation(getBackend().getKey(value));
    }
    
    @Override public Collection<ResourceLocationAPI<?>> getKeys() {
        return getBackend().keySet().stream()
                .map(WrapperHelper::wrapResourceLocation)
                .collect(Collectors.toSet());
    }
    
    @Override public V getValue(ResourceLocationAPI<?> key) {
        return getBackend().get((ResourceLocation)key.unwrap());
    }
    
    @Override public Collection<V> getValues() {
        return getBackend().stream().collect(Collectors.toSet());
    }
    
    @Override public boolean hasKey(ResourceLocationAPI<?> key) {
        return getBackend().containsKey((ResourceLocation)key.unwrap());
    }
    
    @Override public boolean hasValue(V value) {
        return Objects.nonNull(getBackend().getKey(value));
    }
}