package mods.thecomputerizer.theimpossiblelibrary.shared.v20.common.entity;

import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.tag.CompoundTag1_20;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

import static net.minecraft.world.entity.ai.memory.MemoryModuleType.ATTACK_TARGET;

public class Entity1_20 extends EntityAPI<Entity,EntityType<?>> {
    
    public Entity1_20(Object entity) {
        super(entity,((Entity)entity).getType());
    }
    
    @Override public boolean canTarget() {
        return this.entity instanceof Mob;
    }
    
    @Override public EntityAPI<?,?> getAttackTarget() {
        if(!canTarget()) return null;
        Mob mob = (Mob)this.entity;
        if(mob.getBrain().hasMemoryValue(ATTACK_TARGET))
            return WrapperHelper.wrapEntity(mob.getBrain().getMemory(ATTACK_TARGET).orElse(null));
        return WrapperHelper.wrapEntity(mob.getTarget());
    }
    
    @Override public Box getBoundingBox() {
        return Objects.nonNull(this.entity) ? getBoundingBox(this.entity.getBoundingBox()) : null;
    }
    
    protected Box getBoundingBox(AABB box) {
        return new Box(box.minX,box.minY,box.minZ,box.maxX,box.maxY,box.maxZ);
    }
    
    @Override public CompoundTagAPI<?> getData() {
        CompoundTag tag = new CompoundTag();
        if(Objects.nonNull(this.entity)) tag = new EntityDataAccessor(this.entity).getData();
        return new CompoundTag1_20(tag);
    }
    
    @Override public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(getWorld(),this.entity.level().dimensionType());
    }
    
    @Override public String getName() {
        return this.entity.getName().getString();
    }
    
    @Override public BlockPosAPI<?> getPos() {
        return WrapperHelper.wrapPosition(this.entity.blockPosition());
    }
    
    @Override public EntityAPI<?,?> getRootVehicle() {
        return WrapperHelper.wrapEntity(this.entity.getRootVehicle());
    }
    
    @Override public @Nullable EntityAPI<?,?> getVehicle() {
        Entity entity = this.entity.getVehicle();
        return Objects.nonNull(entity) ? WrapperHelper.wrapEntity(entity) : null;
    }
    
    @Override public WorldAPI<?> getWorld() {
        return WrapperHelper.wrapWorld(this.entity.level());
    }
    
    @Override public boolean isAlive() {
        return this.entity.isAlive();
    }
    
    @Override public boolean isAnimal() {
        return this.entity instanceof Animal;
    }
    
    @Override public boolean isHostile() {
        return this.entity instanceof Enemy;
    }
    
    @Override public boolean isLiving() {
        return this.entity instanceof LivingEntity;
    }
    
    @Override public boolean isPlayer() {
        return this.entity instanceof Player;
    }
    
    @Override public boolean isOwnedBy(EntityAPI<?,?> owner) {
        return this.entity instanceof TamableAnimal && ((TamableAnimal)this.entity).getOwner()==this.entity;
    }
    
    @Override public void setRegistryName(ResourceLocationAPI<?> registryName) {
        setLocalRegistryName(registryName); //There is no built-in registryName field for forge in 1.19.+
    }
    
    @Override public void setPosition(double x, double y, double z) {
        this.entity.setPos(x,y,z);
    }
    
    @Override public double x() {
        return this.entity.position().x;
    }
    
    @Override public double y() {
        return this.entity.position().y;
    }
    
    @Override public double z() {
        return this.entity.position().z;
    }
}