package mods.thecomputerizer.theimpossiblelibrary.shared.v21.common.entity;

import mods.thecomputerizer.theimpossiblelibrary.api.common.container.PlayerInventoryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.shared.v21.tag.CompoundTag1_21;
import mods.thecomputerizer.theimpossiblelibrary.shared.v21.text.Text1_21;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.UUID;

public abstract class Player1_21<P extends Player> extends PlayerAPI<P,EntityType<?>> {

    protected Player1_21(Object player) {
        super(player,((Entity)player).getType(),(p,n) -> p.getActiveEffects());
    }
    
    @Override public boolean canTarget() {
        return false;
    }
    
    @Override public int getAir() {
        return this.entity.getAirSupply();
    }
    
    @Override public EntityAPI<?,?> getAttackTarget() {
        return null;
    }
    
    @Override public Box getBoundingBox() {
        return Objects.nonNull(this.entity) ? getBoundingBox(this.entity.getBoundingBox()) : null;
    }
    
    protected Box getBoundingBox(AABB box) {
        return new Box(box.minX,box.minY,box.minZ,box.maxX,box.maxY,box.maxZ);
    }
    
    @Override public CompoundTagAPI<?> getData() {
        CompoundTag tag = new CompoundTag();
        if(Objects.nonNull(this.entity)) tag = new EntityDataAccessor(this.entity).getData();
        return new CompoundTag1_21(tag);
    }

    @Override public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(getWorld(),this.entity.level().dimensionType());
    }
    
    @Override public float getHealth() {
        return this.entity.getHealth();
    }
    
    @Override public PlayerInventoryAPI<?> getInventory() {
        return WrapperHelper.wrapPlayerInventory(this.entity.inventoryMenu);
    }
    
    @Override public ItemStackAPI<?> getMainHandStack() {
        return WrapperHelper.wrapItemStack(this.entity.getMainHandItem());
    }
    
    @Override public float getMaxHealth() {
        return this.entity.getMaxHealth();
    }
    
    @Override public String getName() {
        return this.entity.getName().getString();
    }
    
    @Override public ItemStackAPI<?> getOffHandStack() {
        return WrapperHelper.wrapItemStack(this.entity.getOffhandItem());
    }
    
    @Override public BlockPosAPI<?> getPos() {
        return WrapperHelper.wrapPosition(this.entity.blockPosition());
    }
    
    @Override public EntityAPI<?,?> getRootVehicle() {
        return WrapperHelper.wrapEntity(this.entity.getRootVehicle());
    }
    
    @Override public UUID getUUID() {
        return this.entity.getUUID();
    }
    
    @Override public @Nullable EntityAPI<?,?> getVehicle() {
        Entity entity = this.entity.getVehicle();
        return Objects.nonNull(entity) ? WrapperHelper.wrapEntity(entity) : null;
    }
    
    @Override public WorldAPI<?> getWorld() {
        return WrapperHelper.wrapWorld(this.entity.level());
    }
    
    @Override public boolean isAlive() {
        return this.entity.isAlive();
    }

    @Override public boolean isAnimal() {
        return false;
    }
    
    @Override public boolean isFishing() {
        return Objects.nonNull(this.entity.fishing) && this.entity.fishing.isInWaterOrBubble();
    }
    
    @Override public boolean isFlying() {
        return this.entity.isFallFlying();
    }
    
    @Override public boolean isHostile() {
        return false;
    }

    @Override public boolean isLiving() {
        return true;
    }

    @Override public boolean isPlayer() {
        return true;
    }

    @Override public boolean isOwnedBy(EntityAPI<?,?> owner) {
        return false;
    }
    
    @Override public void sendMessage(TextAPI<?> text, @Nullable UUID uuid) {
        if(Objects.nonNull(this.entity) && text instanceof Text1_21)
            this.entity.sendSystemMessage(text.getAsComponent());
    }
    
    @Override public void sendStatusMessage(TextAPI<?> text, boolean actionBar) {
        if(Objects.nonNull(this.entity) && text instanceof Text1_21)
            this.entity.displayClientMessage(text.getAsComponent(),actionBar);
    }
    
    @Override public void setRegistryName(ResourceLocationAPI<?> registryName) {
        setLocalRegistryName(registryName); //There is no built-in registryName field for forge in 1.19.+
    }
    
    @Override public void setPosition(double x, double y, double z) {
        this.entity.setPos(x,y,z);
    }
    
    @Override public double x() {
        return this.entity.position().x;
    }
    
    @Override public double y() {
        return this.entity.position().y;
    }
    
    @Override public double z() {
        return this.entity.position().z;
    }
}