/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import org.jetbrains.annotations.Nullable;

public class ClientHelper {
    static Map<String, String> optionsCache;

    @IndirectCallers
    public static void addResourcePackFolder(File dir) {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        if (Objects.nonNull(api)) {
            api.addResourcePackFolder(dir);
        } else {
            TILRef.logError("Unable to add resource pack folder `{}` since MinecraftAPI<?> is null", new Object[0]);
        }
    }

    private static boolean checkString(@Nullable String str, String msg, Object ... args) {
        if (Objects.isNull(str) || str.isEmpty()) {
            TILRef.logError(msg, args);
            return true;
        }
        return false;
    }

    private static boolean checkValue(@Nullable String value, String type, Object ... args) {
        return ClientHelper.checkString(value, "Cannot get null or empty option value as " + type + " (from {})", args);
    }

    @Nullable
    public static String getCachedOption(String key) {
        if (Objects.isNull(key) || key.isEmpty()) {
            TILRef.logError("Cannot get option from null or empty key!", new Object[0]);
            return null;
        }
        return ClientHelper.getOptionsCache().get(key);
    }

    @IndirectCallers
    public static boolean getCachedOptionBoolean(String key) {
        String value = ClientHelper.getCachedOption(key);
        return !ClientHelper.checkValue(value, "boolean", key) && Boolean.parseBoolean(value);
    }

    @IndirectCallers
    public static byte getCachedOptionByte(String key) {
        return ClientHelper.getCachedOptionByte(key, (byte)0);
    }

    public static byte getCachedOptionByte(String key, byte defaultValue) {
        return ClientHelper.getCachedOptionNumber(key, defaultValue);
    }

    @IndirectCallers
    public static double getCachedOptionDouble(String key) {
        return ClientHelper.getCachedOptionDouble(key, 0.0);
    }

    public static double getCachedOptionDouble(String key, double defaultValue) {
        return ClientHelper.getCachedOptionNumber(key, defaultValue);
    }

    @IndirectCallers
    public static <E extends Enum<E>> E getCachedOptionEnum(String key, E defualtValue) {
        String value = ClientHelper.getCachedOption(key);
        Class clazz = (Class)GenericUtils.cast(defualtValue.getClass());
        if (Objects.isNull(clazz) || Objects.isNull(value)) {
            return defualtValue;
        }
        return (E)(ClientHelper.checkValue(value, "enum (" + clazz.getName() + ")", key) ? defualtValue : Enum.valueOf(clazz, value));
    }

    @IndirectCallers
    public static float getCachedOptionFloat(String key) {
        return ClientHelper.getCachedOptionFloat(key, 0.0f);
    }

    public static float getCachedOptionFloat(String key, float defaultValue) {
        return ClientHelper.getCachedOptionNumber(key, Float.valueOf(defaultValue)).floatValue();
    }

    @IndirectCallers
    public static int getCachedOptionInt(String key) {
        return ClientHelper.getCachedOptionInt(key, 0);
    }

    public static int getCachedOptionInt(String key, int defaultValue) {
        return ClientHelper.getCachedOptionNumber(key, defaultValue);
    }

    @IndirectCallers
    public static long getCachedOptionLong(String key) {
        return ClientHelper.getCachedOptionLong(key, 0L);
    }

    public static long getCachedOptionLong(String key, long defaultValue) {
        return ClientHelper.getCachedOptionNumber(key, defaultValue);
    }

    @IndirectCallers
    public static short getCachedOptionShort(String key) {
        return ClientHelper.getCachedOptionShort(key, (short)0);
    }

    public static short getCachedOptionShort(String key, short defaultValue) {
        return ClientHelper.getCachedOptionNumber(key, defaultValue);
    }

    public static float getCachedOptionSoundCategory(String name) {
        String key = "soundCategory_" + ("records".equals(name) ? "record" : name);
        return ClientHelper.getCachedOptionFloat(key, 1.0f);
    }

    private static <N extends Number> N getCachedOptionNumber(String key, N defaultValue) {
        String value = ClientHelper.getCachedOption(key);
        String type = defaultValue.getClass().getSimpleName().toLowerCase();
        if (type.equals("integer")) {
            type = "int";
        }
        return ClientHelper.checkValue(value, type, key) ? defaultValue : GenericUtils.parseNumber(value, defaultValue);
    }

    @IndirectCallers
    @Nullable
    public static Object getCurrentScreen() {
        MinecraftAPI<?> mc = ClientHelper.getMinecraft();
        if (Objects.isNull(mc)) {
            return null;
        }
        return mc.scheduleReturnable(mc::getCurrentScreen).get();
    }

    public static int getDisplayHeight() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getDisplayHeight() : 1;
    }

    public static int getDisplayWidth() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getDisplayWidth() : 1;
    }

    @Nullable
    public static FontAPI<?> getFont() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getFont() : null;
    }

    public static int getGuiScale() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getGUIScale() : 0;
    }

    @Nullable
    public static MinecraftAPI<?> getMinecraft() {
        return TILRef.getClientSubAPI(ClientAPI::getMinecraft);
    }

    public static Map<String, String> getOptionsCache() {
        if (Objects.nonNull(optionsCache)) {
            return optionsCache;
        }
        HashMap<String, String> cacheBuilder = new HashMap<String, String>();
        for (String line : FileHelper.toLines("options.txt")) {
            int split = line.indexOf(58);
            if (split <= 0) continue;
            String key = line.substring(0, split);
            String value = line.substring(split + 1);
            if (value.isEmpty()) continue;
            cacheBuilder.put(key, value);
        }
        optionsCache = Collections.unmodifiableMap(cacheBuilder);
        return optionsCache;
    }

    @Nullable
    public static PlayerAPI<?, ?> getPlayer() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getPlayer() : null;
    }

    public static RenderAPI getRenderer() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getRenderer() : null;
    }

    @IndirectCallers
    @Nullable
    public static BlockEntityAPI<?, ?> getTargetBlockEntity() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getTargetBlockEntity() : null;
    }

    @IndirectCallers
    @Nullable
    public static EntityAPI<?, ?> getTargetEntity() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getTargetEntity() : null;
    }

    @Nullable
    public static MinecraftWindow getWindow() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getWindow() : null;
    }

    @Nullable
    public static WorldAPI<?> getWorld() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.getWorld() : null;
    }

    @IndirectCallers
    public static boolean isDisplayFocused() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.isNull(api) || api.isDisplayFocused();
    }

    @IndirectCallers
    public static boolean isFinishedLoading() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) && api.isFinishedLoading();
    }

    @IndirectCallers
    public static boolean isFullScreen() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) && api.isFullScreen();
    }

    public static boolean isLoading() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) && api.isLoading();
    }

    @IndirectCallers
    public static boolean isPaused() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) && api.isPaused();
    }

    @IndirectCallers
    public static <T> Supplier<T> scheduleReturnable(Supplier<T> supplier) {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? api.scheduleReturnable(supplier) : () -> null;
    }

    public static void scheduleRunnable(Runnable runnable) {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        if (Objects.nonNull(api)) {
            api.scheduleRunnable(runnable);
        }
    }

    @IndirectCallers
    public static void sendMessage(TextAPI<?> msg) {
        ClientHelper.sendMessage(msg, null, false, false);
    }

    @IndirectCallers
    public static void sendMessage(TextAPI<?> msg, UUID uuid) {
        ClientHelper.sendMessage(msg, uuid, false, false);
    }

    @IndirectCallers
    public static void sendMessage(TextAPI<?> msg, boolean isStatusMsg) {
        ClientHelper.sendMessage(msg, null, isStatusMsg, false);
    }

    @IndirectCallers
    public static void sendMessage(TextAPI<?> msg, boolean isStatusMsg, boolean isActionBar) {
        ClientHelper.sendMessage(msg, null, isStatusMsg, isActionBar);
    }

    public static void sendMessage(TextAPI<?> msg, @Nullable UUID uuid, boolean isStatusMsg, boolean isActionBar) {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        if (Objects.isNull(api)) {
            TILRef.logWarn("Cannot send {}message `{}` since MinecraftAPI<?> is null", isStatusMsg ? "status " : "", msg.getOriginal());
            return;
        }
        ClientHelper.scheduleRunnable(() -> {
            if (isStatusMsg) {
                api.sendStatusMessageToPlayer(msg, isActionBar);
            } else {
                api.sendMessageToPlayer(msg, uuid);
            }
        });
    }
}

