/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.font;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.MutableWrapped;
import org.jetbrains.annotations.Nullable;

public abstract class FontAPI<F>
extends MutableWrapped<F> {
    private final Function<MinecraftAPI<?>, F> fontGetter;

    protected FontAPI(Function<MinecraftAPI<?>, F> fontGetter) {
        this.fontGetter = fontGetter;
    }

    public abstract void draw(RenderAPI var1, String var2, float var3, float var4, int var5);

    public abstract void drawInBatch(Object var1, float var2, float var3, int var4, boolean var5, Object var6, Object var7, boolean var8, int var9, int var10);

    public abstract void drawWithShadow(RenderAPI var1, String var2, float var3, float var4, int var5);

    @IndirectCallers
    public abstract int getCharWidth(char var1);

    public abstract int getFontHeight();

    public abstract int getStringWidth(@Nullable String var1);

    protected final int getStringWidth(@Nullable String str, BiFunction<F, String, Integer> widthGetter) {
        return Objects.nonNull(str) ? widthGetter.apply(this.getWrapped(), str) : 0;
    }

    @Override
    public F getWrapped() {
        MinecraftAPI<?> mc;
        if (Objects.isNull(this.wrapped) && Objects.nonNull(mc = ClientHelper.getMinecraft())) {
            this.wrapped = this.fontGetter.apply(mc);
        }
        return (F)this.wrapped;
    }

    public void renderToolTip(RenderAPI renderer, Collection<TextAPI<?>> lines, int x, int y, int width, int height, int maxWidth) {
        if (Objects.isNull(renderer)) {
            return;
        }
        renderer.setFont(this.getWrapped());
        TILRef.getClientHandles().renderToolTip(renderer, this.unwrapTooltipComponents(lines), x, y, width, height, maxWidth);
    }

    public String trimStringTo(String str, Number width) {
        return this.trimStringTo(str, width.intValue(), false);
    }

    public abstract String trimStringTo(String var1, int var2, boolean var3);

    public <T> List<T> unwrapTooltipComponents(Collection<TextAPI<?>> lines) {
        return (List)GenericUtils.cast(lines.stream().map(text -> text.getAsComponent()).collect(Collectors.toList()));
    }
}

