/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.Convex3D;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.ShapeHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.Shapes;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class Column {
    private final Random random;
    private final Vector3 relativeBottom;
    private final double height;
    private final double radius;
    private final double spacing;
    private final ShapeHolder outline;
    private final List<ShapeHolder> movingShapes;
    private double shapeSpeed;
    private ShapeHolder recentShape;
    private boolean shouldGenerateShapes;

    public Column(Random random, Vector3 relativeBottom, double height, double radius, double spacing) {
        this.random = random;
        this.relativeBottom = relativeBottom;
        this.height = height;
        this.radius = radius;
        this.spacing = spacing;
        this.outline = this.makeOutlineShape();
        this.movingShapes = new ArrayList<ShapeHolder>();
        this.shapeSpeed = 1.0;
        this.shouldGenerateShapes = true;
    }

    private ShapeHolder makeOutlineShape() {
        Convex3D column = Shapes.BOX.makeInstance();
        column.setColor(0.4f, 0.6f, 0.9f, 0.1f);
        column.setScale((float)this.radius, (float)this.height, (float)this.radius);
        column.setRotationSpeed(0.0, 0.075, 0.0);
        column.setEnableOutline(false);
        return new ShapeHolder(column).setRelativePosition(this.relativeBottom.add(0.0, this.height / 2.0, 0.0));
    }

    public Column disableShapes() {
        this.shouldGenerateShapes = false;
        return this;
    }

    public void setSpeed(double speed) {
        this.shapeSpeed = speed;
        for (ShapeHolder holder : this.movingShapes) {
            holder.setDirection(new Vector3(0.0, 0.04 * this.shapeSpeed, 0.0));
        }
    }

    public void render(RenderContext ctx, Vector3 relativeCenter) {
        Vector3 actualRender = relativeCenter.add(this.relativeBottom.dX(), 0.0, this.relativeBottom.dZ());
        this.outline.render(ctx, actualRender);
        if (this.shouldGenerateShapes) {
            if (this.movingShapes.isEmpty() || Objects.isNull(this.recentShape) || this.recentShape.getRelativePosition().dY() - this.relativeBottom.dY() > this.spacing) {
                ShapeHolder newholder = new ShapeHolder(this.generateRandomBox()).setRelativePosition(this.relativeBottom).setDirection(new Vector3(0.0, 0.04 * this.shapeSpeed, 0.0));
                newholder.startMoving();
                this.movingShapes.add(newholder);
                this.recentShape = newholder;
            }
            ListIterator<ShapeHolder> shapesIterator = this.movingShapes.listIterator();
            while (shapesIterator.hasNext()) {
                ShapeHolder holder = (ShapeHolder)shapesIterator.next();
                holder.render(ctx, actualRender);
                if (!(holder.getRelativePosition().dY() + this.spacing > this.relativeBottom.dY() + this.height)) continue;
                shapesIterator.remove();
            }
        }
    }

    private Convex3D generateRandomBox() {
        Convex3D newShape = Shapes.BOX.makeInstance();
        newShape.setColor(0.0f, 0.0f, 0.0f, 0.5f);
        float defaultScale = 0.5f * Math.min((float)this.radius, (float)this.spacing);
        newShape.setScale(defaultScale + (float)this.randomOffset(defaultScale / 2.0f), defaultScale + (float)this.randomOffset(defaultScale), defaultScale + (float)this.randomOffset(defaultScale / 2.0f));
        newShape.setRotationSpeed(0.3 + this.randomOffset(0.2), 0.1 + this.randomOffset(0.2), 0.2 + this.randomOffset(0.2));
        return newShape;
    }

    private double randomOffset(double range) {
        return -range / 2.0 + this.random.nextDouble() * range;
    }
}

