/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.Orbit;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.TriangleMapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;

public class Convex3D {
    private final double radius;
    private final TriangleMapper[] triangles;
    private final float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    private final double[] translationOffset = new double[]{0.0, 0.0, 0.0};
    private final double[] rotationSpeed = new double[]{0.0, 0.0, 0.0};
    private final float[] currentRotation = new float[]{0.0f, 0.0f, 0.0f};
    private boolean showOutlines = true;
    private boolean enableCull = false;
    private boolean pushMatrix = true;
    private Vector3 previousRenderPos;
    private Vector3 orbitVec;
    private Orbit orbit;

    public Convex3D(Vector3 ... relativeCoords) {
        if (Objects.isNull(relativeCoords) || relativeCoords.length <= 3) {
            throw new RuntimeException("Only convex polygons with more than 3 vertices are supported for Convex3D objects");
        }
        this.radius = relativeCoords[0].distance(VectorHelper.zero3D());
        this.triangles = new TriangleMapper[relativeCoords.length];
        for (int i = 0; i < relativeCoords.length; ++i) {
            this.triangles[i] = new TriangleMapper(relativeCoords[i], relativeCoords);
        }
    }

    public Convex3D(Convex3D copy) {
        this.radius = copy.radius;
        this.triangles = copy.triangles;
        this.setColor(copy.color);
        this.setScale(copy.scale);
        this.setTranslationOffset(copy.translationOffset);
        this.setRotationSpeed(copy.rotationSpeed);
        this.currentRotation[0] = copy.currentRotation[0];
        this.currentRotation[1] = copy.currentRotation[1];
        this.currentRotation[2] = copy.currentRotation[2];
        this.showOutlines = copy.showOutlines;
        this.enableCull = copy.enableCull;
        this.pushMatrix = copy.pushMatrix;
        this.previousRenderPos = copy.previousRenderPos;
        this.orbitVec = copy.orbitVec;
        this.orbit = copy.orbit;
    }

    public double getScaledHeight() {
        return this.radius / (double)this.scale[1];
    }

    public void setColor(float ... newColor) {
        for (int i = 0; i < 4; ++i) {
            this.color[i] = newColor.length > i ? newColor[i] : 1.0f;
            int oi = i + 4;
            this.color[oi] = newColor.length > oi ? newColor[oi] : (i < 3 ? 1.0f - this.color[i] : this.color[i]);
        }
    }

    public void setScale(float ... newScale) {
        for (int i = 0; i < this.scale.length; ++i) {
            this.scale[i] = newScale.length > i ? newScale[i] : 1.0f;
        }
    }

    public void setRotationSpeed(double ... newSpeed) {
        for (int i = 0; i < this.rotationSpeed.length; ++i) {
            this.rotationSpeed[i] = newSpeed.length > i ? newSpeed[i] : 0.0;
        }
    }

    public void setRandomRotations(Random random, double speedFactor) {
        this.setRotationSpeed(random.nextDouble() * speedFactor, random.nextDouble() * speedFactor, random.nextDouble() * speedFactor);
    }

    public void setTranslationOffset(double ... newOffset) {
        for (int i = 0; i < this.translationOffset.length; ++i) {
            this.translationOffset[i] = newOffset.length > i ? newOffset[i] : 0.0;
        }
    }

    public void setOrbit(double radius, double speed, double angle) {
        this.orbit = new Orbit(radius, speed, angle);
    }

    public void setRandomTranslationOffset(Random random, double range) {
        this.setTranslationOffset(this.randomOffset(random, range), this.randomOffset(random, range), this.randomOffset(random, range));
    }

    private double randomOffset(Random random, double range) {
        return -range / 2.0 + random.nextDouble() * range;
    }

    public void setEnableOutline(boolean showOutlines) {
        this.showOutlines = showOutlines;
    }

    private void preRender(RenderAPI renderer) {
        if (this.pushMatrix) {
            renderer.pushMatrix();
        }
        renderer.enableBlend();
        renderer.disableTexture();
        renderer.defaultBlendFunc();
        if (!this.enableCull) {
            renderer.depthMask(false);
        }
        renderer.alphaFuncGreater(0.003921569f);
        renderer.disableCull();
        renderer.disableLighting();
    }

    private void postRender(RenderAPI renderer) {
        renderer.enableTexture();
        renderer.disableBlend();
        renderer.enableLighting();
        renderer.enableCull();
        if (!this.enableCull) {
            renderer.depthMask(true);
        }
        renderer.alphaFuncGreater(0.1f);
        if (this.pushMatrix) {
            renderer.popMatrix();
        }
    }

    public void render(RenderContext ctx, double x, double y, double z) {
        this.render(ctx, new Vector3(x, y, z));
    }

    public void render(RenderContext ctx, Vector3 pos) {
        RenderAPI renderer = ctx.getRenderer();
        this.preRender(renderer);
        renderer.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        renderer.scale(this.scale[0], this.scale[1], this.scale[2]);
        this.setTranslation(renderer, new Vector3(pos.dX() / (double)this.scale[0], pos.dY() / (double)this.scale[1], pos.dZ() / (double)this.scale[2]));
        for (int i = 0; i < this.currentRotation.length; ++i) {
            this.currentRotation[i] = this.rotateClampedAxis(i);
        }
        renderer.rotate(this.currentRotation[0], 1.0f, 0.0f, 0.0f);
        renderer.rotate(this.currentRotation[1], 0.0f, 1.0f, 0.0f);
        renderer.rotate(this.currentRotation[2], 0.0f, 0.0f, 1.0f);
        for (TriangleMapper triangle : this.triangles) {
            this.renderTriangle(renderer, triangle);
        }
        if (this.showOutlines) {
            this.renderOutlines(ctx);
        }
        this.postRender(renderer);
    }

    private void setTranslation(RenderAPI renderer, Vector3 initialPos) {
        if (Objects.isNull(this.previousRenderPos)) {
            this.previousRenderPos = initialPos;
        }
        if (Objects.isNull(this.orbit)) {
            renderer.translate(initialPos.dX() + this.translationOffset[0], initialPos.dY() + this.translationOffset[1], initialPos.dZ() + this.translationOffset[2]);
        } else {
            if (Objects.isNull(this.orbitVec)) {
                this.orbitVec = new Vector3(this.translationOffset[0], this.translationOffset[1], this.translationOffset[2]);
            } else if (!initialPos.equals(this.previousRenderPos)) {
                double distance = initialPos.distance(this.previousRenderPos);
                this.orbitVec = this.orbitVec.add(initialPos.sub(this.previousRenderPos).normalize().mulScalar(distance));
            }
            this.orbitVec = this.orbit.getNextVec(this.orbitVec, initialPos);
            renderer.translate(this.orbitVec.dX(), this.orbitVec.dY(), this.orbitVec.dZ());
        }
        this.previousRenderPos = initialPos;
    }

    private float rotateClampedAxis(int index) {
        float current = this.currentRotation[index];
        double adjustedSpeed = this.rotationSpeed[index];
        current += (float)adjustedSpeed;
        while (current > 360.0f) {
            current -= 360.0f;
        }
        return Math.max(current, 0.0f);
    }

    public void renderTriangle(RenderAPI renderer, TriangleMapper triangle) {
        VertexWrapper buffer = renderer.getBufferBuilderPC(renderer.getGLAPI().triangleFan(), 3);
        buffer.start();
        for (int i = 0; i < triangle.length; ++i) {
            this.bufferVertex(buffer, triangle.getOriginal());
            this.bufferVertex(buffer, triangle.getA(i));
            this.bufferVertex(buffer, triangle.getB(i));
        }
        buffer.finish();
    }

    public void renderOutlines(RenderContext ctx) {
        ctx.prepareGradient(ColorCache.of(this.color[4], this.color[5], this.color[6], this.color[7]));
        for (TriangleMapper triangle : this.triangles) {
            for (int i = 0; i < triangle.length; ++i) {
                this.renderTriangleOutline(ctx, triangle, i);
            }
        }
    }

    public void renderTriangleOutline(RenderContext ctx, TriangleMapper triangle, int index) {
        Vector3 og = triangle.getOriginal();
        Vector3 a = triangle.getA(index);
        Vector3 b = triangle.getB(index);
        ctx.drawLine(og, a, 1.0f);
        ctx.drawLine(og, b, 1.0f);
        ctx.drawLine(a, b, 1.0f);
    }

    private void bufferVertex(VertexWrapper buffer, Vector3 vec) {
        buffer.pos(vec.dX(), vec.dY(), vec.dZ()).color(this.color[0], this.color[1], this.color[2], this.color[3]).endVertex();
    }

    @Generated
    public double getRadius() {
        return this.radius;
    }

    @Generated
    public void setEnableCull(boolean enableCull) {
        this.enableCull = enableCull;
    }

    @Generated
    public void setPushMatrix(boolean pushMatrix) {
        this.pushMatrix = pushMatrix;
    }
}

