/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextureWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Plane;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;

public class ScreenAPI
extends WidgetGroup {
    protected final ScreenAPI parentScreen;
    protected final TextAPI<?> title;
    protected final int guiScale;
    protected ShapeWidget background;
    protected boolean focused;

    public ScreenAPI(TextAPI<?> title, MinecraftWindow window, int guiScale) {
        this(null, title, window, guiScale);
    }

    public ScreenAPI(ScreenAPI parentScreen, TextAPI<?> title, MinecraftWindow window, int guiScale) {
        super(parentScreen);
        this.parentScreen = parentScreen;
        this.title = title;
        this.guiScale = guiScale;
        this.onResolutionUpdated(window);
        this.background = this.asBackground(ColorHelper.BLACK);
    }

    private ScreenAPI(ScreenAPI parentScreen, TextAPI<?> title, int guiScale, boolean focused) {
        super(parentScreen);
        this.parentScreen = parentScreen;
        this.title = title;
        this.guiScale = guiScale;
        this.focused = focused;
        this.background = this.asBackground(ColorHelper.BLACK);
    }

    protected ShapeWidget asBackground(ColorCache color) {
        return ShapeWidget.from((Shape)this.fullScreenPlane(), color.withAlpha(this.defaultBackgroundDarkness()));
    }

    protected ShapeWidget asBackground(ResourceLocationAPI<?> texture) {
        return ShapeWidget.from((Shape)this.fullScreenPlane(), texture, this.defaultBackgroundDarkness());
    }

    protected ShapeWidget asBackground(TextureWrapper texture) {
        return ShapeWidget.from((Shape)this.fullScreenPlane(), texture.setAlpha(this.defaultBackgroundDarkness()));
    }

    public void close() {
        if (this.onCloseRequested(false)) {
            ScreenHelper.open(this.parentScreen);
        }
    }

    public void closeAll() {
        ScreenHelper.open((ScreenAPI)null);
    }

    @Override
    public ScreenAPI copy() {
        ScreenAPI copy = new ScreenAPI(this.parentScreen, this.title, this.guiScale, this.focused);
        copy.copyGroup(this);
        return copy;
    }

    public float defaultBackgroundDarkness() {
        return 0.6666667f;
    }

    public void draw(RenderContext ctx, double mouseX, double mouseY) {
        this.draw(ctx, VectorHelper.zero3D(), mouseX, mouseY);
    }

    public void draw(RenderContext ctx, double mouseX, double mouseY, double z) {
        this.draw(ctx, VectorHelper.zero3D().add(0.0, 0.0, z), mouseX, mouseY);
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (Objects.nonNull(this.background)) {
            this.background.draw(ctx, center.copy(), mouseX, mouseY);
        }
        super.draw(ctx, center, mouseX, mouseY);
        Collection<TextAPI<?>> text = this.getHoverLines(mouseX, mouseY);
        if (!text.isEmpty()) {
            ctx.drawTooltip(text, mouseX, mouseY);
        }
    }

    @Override
    public void drawHovered(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
    }

    protected Plane fullScreenPlane() {
        return ShapeHelper.plane(Facing.Axis.Y, new Vector2(-1.0, -1.0), new Vector2(1.0, 1.0));
    }

    @Override
    public double getHeight() {
        return 2.0;
    }

    @Override
    public double getWidth() {
        return 2.0;
    }

    public boolean onCloseRequested(boolean pressedEsc) {
        return true;
    }

    @Override
    public void onScreenClosed() {
        this.eachWidget(Widget::onScreenClosed);
    }

    @Override
    public void onScreenOpened() {
        this.eachWidget(Widget::onScreenOpened);
    }

    public boolean shouldPauseGame() {
        return false;
    }

    @Generated
    public ScreenAPI getParentScreen() {
        return this.parentScreen;
    }

    @Generated
    public TextAPI<?> getTitle() {
        return this.title;
    }

    @Generated
    public int getGuiScale() {
        return this.guiScale;
    }

    @Generated
    public ShapeWidget getBackground() {
        return this.background;
    }

    @Generated
    public boolean isFocused() {
        return this.focused;
    }

    @Generated
    public void setBackground(ShapeWidget background) {
        this.background = background;
    }

    @Generated
    public void setFocused(boolean focused) {
        this.focused = focused;
    }
}

