/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Circle;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Plane;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import org.jetbrains.annotations.Nullable;

public class Button
extends WidgetGroup {
    protected final ShapeWidget shape;
    protected final TextWidget text;
    protected Collection<TextAPI<?>> hoverLines;
    protected Widget hover;
    protected Consumer<Button> clickFunc;
    protected Consumer<Button> contextFunc;

    public static Button basic(TextAPI<?> text, TextAPI<?> ... hoverLines) {
        return Button.basic(0.0, 0.0, text, Arrays.asList(hoverLines));
    }

    public static Button basic(TextAPI<?> text, Collection<TextAPI<?>> hoverLines) {
        return Button.basic(0.0, 0.0, text, hoverLines);
    }

    public static Button basic(Vector2 center, TextAPI<?> text, TextAPI<?> ... hoverLines) {
        return Button.basic(center.dX(), center.dY(), text, Arrays.asList(hoverLines));
    }

    public static Button basic(double centerX, double centerY, TextAPI<?> text, TextAPI<?> ... hoverLines) {
        return Button.basic(centerX, centerY, text, Arrays.asList(hoverLines));
    }

    public static Button basic(Vector2 center, TextAPI<?> text, Collection<TextAPI<?>> hoverLines) {
        return Button.basic(center.dX(), center.dY(), text, hoverLines);
    }

    public static Button basic(double centerX, double centerY, TextAPI<?> text, Collection<TextAPI<?>> hoverLines) {
        double heightRatio = RenderHelper.getCurrentHeightRatio();
        Plane shape = ShapeHelper.plane(Facing.Axis.Y, new Vector2(-0.25 * heightRatio, -0.025), new Vector2(0.25 * heightRatio, 0.025));
        ShapeWidget texture = ShapeWidget.from((Shape)shape, ScreenHelper.getVanillaButtonTexture(false, false), centerX, centerY);
        TextWidget textWidget = TextWidget.from(text);
        ShapeWidget hoverTex = ShapeWidget.from((Shape)shape, ScreenHelper.getVanillaButtonTexture(true, false), centerX, centerY);
        BasicWidgetGroup hover = BasicWidgetGroup.from(hoverTex, textWidget, ShapeWidget.outlineFrom((Shape)shape, 2.0f, centerX, centerY));
        Button button = new Button(texture, TextWidget.from(text), hover);
        button.hoverLines.addAll(hoverLines);
        return button;
    }

    public static Button colored(ColorCache color, TextAPI<?> text, TextAPI<?> ... hoverLines) {
        return Button.colored(0.0, 0.0, color, text, Arrays.asList(hoverLines));
    }

    public static Button colored(ColorCache color, TextAPI<?> text, Collection<TextAPI<?>> hoverLines) {
        return Button.colored(0.0, 0.0, color, text, hoverLines);
    }

    public static Button colored(Vector2 center, ColorCache color, TextAPI<?> text, TextAPI<?> ... hoverLines) {
        return Button.colored(center.dX(), center.dY(), color, text, Arrays.asList(hoverLines));
    }

    public static Button colored(Vector2 center, ColorCache color, TextAPI<?> text, Collection<TextAPI<?>> hoverLines) {
        return Button.colored(center.dX(), center.dY(), color, text, hoverLines);
    }

    public static Button colored(double centerX, double centerY, ColorCache color, TextAPI<?> text, TextAPI<?> ... hoverLines) {
        return Button.colored(centerX, centerY, color, text, Arrays.asList(hoverLines));
    }

    public static Button colored(double centerX, double centerY, ColorCache color, TextAPI<?> text, Collection<TextAPI<?>> hoverLines) {
        double heightRatio = RenderHelper.getCurrentHeightRatio();
        Plane shape = ShapeHelper.plane(Facing.Axis.Y, new Vector2(-0.25 * heightRatio, -0.025), new Vector2(0.25 * heightRatio, 0.025));
        ShapeWidget colorWidget = ShapeWidget.from((Shape)shape, color, centerX, centerY);
        TextWidget textWidget = TextWidget.from(text);
        ShapeWidget hoverColor = ShapeWidget.from((Shape)shape, ColorHelper.reverse(color, color.a()), centerX, centerY);
        BasicWidgetGroup hover = BasicWidgetGroup.from(hoverColor, textWidget, ShapeWidget.outlineFrom(shape, ColorHelper.RED, 3.0f, centerX, centerY));
        Button button = new Button(colorWidget, TextWidget.from(text), hover);
        button.hoverLines.addAll(hoverLines);
        return button;
    }

    public static WidgetGroup radialGroup(Circle circle, Vector2 center, int slices, BiConsumer<Integer, Button> settings) {
        return BasicWidgetGroup.from(Button.radial(circle, center, slices, 0.0, settings));
    }

    public static WidgetGroup radialGroup(Circle circle, Vector2 center, int slices, double startAngle, BiConsumer<Integer, Button> settings) {
        return BasicWidgetGroup.from(Button.radial(circle, center, slices, startAngle, settings));
    }

    public static WidgetGroup radialGroup(Circle circle, double centerX, double centerY, int slices, double startAngle, BiConsumer<Integer, Button> settings) {
        return BasicWidgetGroup.from(Button.radial(circle, centerX, centerY, slices, startAngle, settings));
    }

    public static Button[] radial(Circle circle, Vector2 center, int slices, double startAngle, BiConsumer<Integer, Button> settings) {
        return Button.radial(circle, center.dX(), center.dY(), slices, startAngle, settings);
    }

    public static Button[] radial(Circle circle, double centerX, double centerY, int slices, double startAngle, BiConsumer<Integer, Button> settings) {
        Button[] buttons = new Button[Math.max(slices, 1)];
        Circle.CircleSlice[] sliceArray = circle.slice(Math.max(slices, 1), startAngle);
        for (int i = 0; i < sliceArray.length; ++i) {
            int index = i;
            buttons[i] = Button.radial(sliceArray[i], centerX, centerY, button -> settings.accept(index, (Button)button));
        }
        return buttons;
    }

    public static Button radial(Circle circle, Vector2 center, Consumer<Button> settings) {
        return Button.radial(circle, center.dX(), center.dY(), settings);
    }

    public static Button radial(Circle circle, double centerX, double centerY, Consumer<Button> settings) {
        Button button = new Button(ShapeWidget.from((Shape)circle, centerX, centerY), null, null);
        settings.accept(button);
        return button;
    }

    public Button(@Nullable ShapeWidget shape, @Nullable TextWidget text, @Nullable Widget hover) {
        this.shape = shape;
        this.text = text;
        this.hover = hover;
        this.hoverLines = new ArrayList();
        boolean hasShape = Objects.nonNull(shape);
        if (hasShape) {
            this.addWidget(shape);
        }
        if (Objects.nonNull(text)) {
            this.addWidget(text);
        }
        if (Objects.nonNull(hover)) {
            hover.setParent(this);
        }
        this.expandShapeToText();
    }

    public void addHoverLine(TextAPI<?> text) {
        this.hoverLines.add(text);
    }

    public void addHoverLines(TextAPI<?> ... text) {
        this.hoverLines.addAll(Arrays.asList(text));
    }

    public void addHoverLines(Collection<TextAPI<?>> text) {
        this.hoverLines.addAll(text);
    }

    @Override
    public Button copy() {
        Button copy = new Button(Objects.nonNull(this.shape) ? this.shape.copy() : null, Objects.nonNull(this.text) ? this.text.copy() : null, Objects.nonNull(this.hover) ? this.hover.copy() : null);
        copy.copyBasic(this);
        copy.addHoverLines(this.hoverLines);
        copy.clickFunc = this.clickFunc;
        copy.scaleX = this.scaleX;
        copy.scaleY = this.scaleY;
        return copy;
    }

    @Override
    public void drawHovered(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (Objects.nonNull(this.hover)) {
            this.hover.draw(ctx, center, mouseX, mouseY);
        } else {
            this.draw(ctx, center, mouseX, mouseY);
        }
    }

    public void expandShapeHeightToText() {
        if (Objects.nonNull(this.shape) && Objects.nonNull(this.text)) {
            double textHeight = this.text.getHeight() * 1.25;
            if (this.shape.getHeight() < textHeight) {
                this.shape.setHeight(textHeight);
            }
        }
    }

    public void expandShapeToText() {
        if (Objects.nonNull(this.shape) && Objects.nonNull(this.text)) {
            double textWidth = this.text.getWidth() * 1.05;
            double textHeight = this.text.getHeight() * 1.25;
            if (this.shape.getWidth() < textWidth) {
                this.shape.setWidth(textWidth);
            }
            if (this.shape.getHeight() < textHeight) {
                this.shape.setHeight(textHeight);
            }
        }
    }

    public void expandShapeWidthToText() {
        if (Objects.nonNull(this.shape) && Objects.nonNull(this.text)) {
            double textWidth = this.text.getWidth() * 1.05;
            if (this.shape.getWidth() < textWidth) {
                this.shape.setWidth(textWidth);
            }
        }
    }

    public void fitShapeHeightToText() {
        if (Objects.nonNull(this.shape) && Objects.nonNull(this.text)) {
            double textHeight = this.text.getHeight() * 1.25;
            if (this.shape.getHeight() != textHeight) {
                this.shape.setHeight(textHeight);
            }
        }
    }

    public void fitShapeToText() {
        if (Objects.nonNull(this.shape) && Objects.nonNull(this.text)) {
            double textWidth = this.text.getWidth() * 1.05;
            double textHeight = this.text.getHeight() * 1.25;
            if (this.shape.getWidth() != textWidth) {
                this.shape.setWidth(textWidth);
            }
            if (this.shape.getHeight() != textHeight) {
                this.shape.setHeight(textHeight);
            }
        }
    }

    public void fitShapeWidthToText() {
        if (Objects.nonNull(this.shape) && Objects.nonNull(this.text)) {
            double textWidth = this.text.getWidth() * 1.05;
            if (this.shape.getWidth() != textWidth) {
                this.shape.setWidth(textWidth);
            }
        }
    }

    @Override
    public double getHeight() {
        return this.shape.getHeight();
    }

    @Override
    public Collection<TextAPI<?>> getHoverLines(double x, double y) {
        return Objects.nonNull(this.hoverLines) && this.isHovering(x, y) ? this.hoverLines : Collections.emptyList();
    }

    @Override
    public double getWidth() {
        return this.shape.getWidth();
    }

    public boolean hasNonBlankHoverText() {
        if (Objects.nonNull(this.hover)) {
            if (this.hover instanceof TextWidget) {
                return ((TextWidget)this.hover).isNotBlank();
            }
            if (this.hover instanceof WidgetGroup) {
                ((WidgetGroup)this.hover).hasNonBlankText();
            }
        }
        return false;
    }

    public boolean hasNonEmptyHoverText() {
        if (Objects.nonNull(this.hover)) {
            if (this.hover instanceof TextWidget) {
                return ((TextWidget)this.hover).isNotEmpty();
            }
            if (this.hover instanceof WidgetGroup) {
                ((WidgetGroup)this.hover).hasNonEmptyText();
            }
        }
        return false;
    }

    @Override
    public boolean hasNonEmptyText() {
        return Objects.nonNull(this.text) && !this.text.isEmpty();
    }

    @Override
    public boolean isHovering(double x, double y) {
        return this.shape.isInside(x, y, 0.0);
    }

    @Override
    public boolean onLeftClick(double x, double y) {
        if (this.isHovering(x, y)) {
            if (Objects.nonNull(this.clickFunc)) {
                this.playLeftClickSound();
                this.clickFunc.accept(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightClick(double x, double y) {
        if (this.isHovering(x, y)) {
            if (Objects.nonNull(this.contextFunc)) {
                this.playRightClickSound();
                this.contextFunc.accept(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void playLeftClickSound() {
        ScreenHelper.playVanillaClickSound();
    }

    public Button setClickFunc(Consumer<Button> onLeftClick) {
        this.clickFunc = onLeftClick;
        return this;
    }

    public Button setContextFunc(Consumer<Button> onRightClick) {
        this.contextFunc = onRightClick;
        return this;
    }

    public Button setHoverLines(Collection<TextAPI<?>> text) {
        this.hoverLines = text;
        return this;
    }

    public void setHoverText(Consumer<TextWidget> text) {
        if (this.hover instanceof TextWidget) {
            text.accept((TextWidget)this.hover);
        } else if (this.hover instanceof WidgetGroup) {
            ArrayList<ShapeWidget> shapes = new ArrayList<ShapeWidget>();
            TextWidget found = null;
            for (Widget widget : ((WidgetGroup)this.hover).widgets) {
                if (widget instanceof ShapeWidget) {
                    shapes.add((ShapeWidget)widget);
                    continue;
                }
                if (!(widget instanceof TextWidget)) continue;
                found = (TextWidget)widget;
                text.accept(found);
            }
            for (ShapeWidget shape : shapes) {
                if (!Objects.nonNull(found)) continue;
                double textWidth = found.getWidth() * 1.05;
                if (!(shape.getWidth() < textWidth)) continue;
                shape.setWidth(textWidth);
            }
        }
    }

    public void setText(String literal) {
        if (Objects.nonNull(this.text)) {
            this.text.setText(literal);
            this.expandShapeWidthToText();
        }
    }

    public void setText(TextAPI<?> text) {
        if (Objects.nonNull(this.text)) {
            this.text.setText(text);
            this.expandShapeWidthToText();
        }
    }

    public void setText(TextBuffer buffer) {
        if (Objects.nonNull(this.text)) {
            this.text.setText(buffer);
            this.expandShapeWidthToText();
        }
    }

    @Override
    public boolean shouldDrawHovered() {
        return Objects.nonNull(this.hover) || !this.hoverLines.isEmpty();
    }

    public String toString() {
        return String.valueOf(this.text);
    }

    @Generated
    public ShapeWidget getShape() {
        return this.shape;
    }

    @Generated
    public TextWidget getText() {
        return this.text;
    }

    @Generated
    public Collection<TextAPI<?>> getHoverLines() {
        return this.hoverLines;
    }

    @Generated
    public void setHover(Widget hover) {
        this.hover = hover;
    }

    @Generated
    public Consumer<Button> getClickFunc() {
        return this.clickFunc;
    }

    @Generated
    public Consumer<Button> getContextFunc() {
        return this.contextFunc;
    }
}

